/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdc.model;

import jsesh.mdc.model.BasicItem;
import jsesh.mdc.model.ModelElement;
import jsesh.mdc.model.ModelElementVisitor;
import jsesh.utils.TranslitterationUtilities;

public class AlphabeticText
extends BasicItem {
    private char scriptCode;
    private String text;

    public AlphabeticText(char scriptCode, String text) {
        this.scriptCode = scriptCode;
        this.setTextAux(text);
    }

    public String getText() {
        return this.text;
    }

    private void setTextAux(String text) {
        this.text = this.scriptCode == 't' ? TranslitterationUtilities.convertWindowsTranslitteration(text) : text;
    }

    public void setText(String _text) {
        this.setTextAux(_text);
        this.notifyModification();
    }

    public void accept(ModelElementVisitor v) {
        v.visitAlphabeticText(this);
    }

    public String toString() {
        return "(text " + this.text.toString() + ")";
    }

    public char getScriptCode() {
        return this.scriptCode;
    }

    public void setScriptCode(char c) {
        this.scriptCode = c;
    }

    public int compareToAux(ModelElement e) {
        AlphabeticText at = (AlphabeticText)e;
        int result = this.getText().toString().compareTo(at.getText().toString());
        if (result == 0) {
            result = this.getScriptCode() - at.getScriptCode();
        }
        if (result == 0) {
            result = this.getState().compareTo(at.getState());
        }
        return result;
    }

    public ModelElement deepCopy() {
        AlphabeticText t = new AlphabeticText(this.scriptCode, this.text);
        this.copyStateTo(t);
        return t;
    }
}

