/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdc.model;

import java.io.Serializable;
import jsesh.mdc.model.TopItem;
import jsesh.mdc.model.TopItemList;

public class MDCPosition
implements Cloneable,
Serializable,
Comparable {
    private TopItemList topItemList;
    private int index;

    public MDCPosition(TopItemList container, int index) {
        this.topItemList = container;
        if (index < 0) {
            index = 0;
        }
        if (index > container.getNumberOfChildren()) {
            index = container.getNumberOfChildren();
        }
        this.index = index;
    }

    public TopItem getElementAfter() {
        if (this.topItemList == null || this.index >= this.topItemList.getNumberOfChildren() || this.index < 0) {
            return null;
        }
        return this.topItemList.getTopItemAt(this.index);
    }

    public TopItem getElementBefore() {
        if (this.topItemList == null || this.index > this.topItemList.getNumberOfChildren() || this.index <= 0) {
            return null;
        }
        return this.topItemList.getTopItemAt(this.index - 1);
    }

    public TopItemList getTopItemList() {
        return this.topItemList;
    }

    public int getIndex() {
        return this.index;
    }

    public MDCPosition getNextPosition(int i) {
        int k = this.getIndex() + i;
        return this.getPositionAt(k);
    }

    public MDCPosition getPositionAt(int k) {
        return new MDCPosition(this.getTopItemList(), k);
    }

    public String toString() {
        return "pos " + this.getIndex();
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.topItemList.getNumberOfChildren();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MDCPosition) {
            MDCPosition p = (MDCPosition)obj;
            return this.topItemList == p.topItemList && this.index == p.index;
        }
        return false;
    }

    public int hashCode() {
        return (this.topItemList.hashCode() << 65535) + this.index;
    }

    public int compareTo(Object o) {
        MDCPosition other = (MDCPosition)o;
        return this.index - other.index;
    }
}

