/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdc.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import jsesh.mdc.model.EmbeddedModelElement;
import jsesh.mdc.model.ModelElementIterator;
import jsesh.mdc.model.ModelElementObserver;
import jsesh.mdc.model.ModelElementVisitor;
import jsesh.mdc.model.TopItem;
import jsesh.mdc.model.operations.ChildOperation;
import jsesh.mdc.model.operations.Deletion;
import jsesh.mdc.model.operations.Insertion;
import jsesh.mdc.model.operations.ModelOperation;
import jsesh.mdc.model.operations.Modification;
import jsesh.mdc.model.operations.Replacement;

public abstract class ModelElement
implements ModelElementObserver,
Comparable,
Serializable {
    private List children = this.buildChildrenList();
    private boolean fillX = false;
    private boolean fillY = false;
    private boolean updatesEnabled = true;

    public abstract void accept(ModelElementVisitor var1);

    protected final void addAll(List elementList, Class eltClass) {
        this.addAllAt(this.children.size(), elementList, eltClass);
    }

    protected void addAllAt(int index, List elementList, Class eltClass) {
        int i = index;
        this.children.addAll(index, elementList);
        Iterator iter = elementList.iterator();
        while (iter.hasNext()) {
            EmbeddedModelElement child = (EmbeddedModelElement)iter.next();
            if (!eltClass.isInstance(child)) {
                throw new ClassCastException("Bad element in list " + child + " for " + eltClass);
            }
            child.setParent(this);
            this.fixSlibings(i);
            ++i;
        }
        this.notifyModelElementObservers(new Insertion(this, index, elementList));
    }

    protected final void addChild(EmbeddedModelElement child) {
        this.addChildAt(this.children.size(), child);
    }

    protected final void addChildAt(int idx, EmbeddedModelElement child) {
        child.setParent(this);
        this.children.add(idx, child);
        this.fixSlibings(idx);
        this.notifyModelElementObservers(new Insertion(this, idx, child));
    }

    protected List buildChildrenList() {
        return new ArrayList();
    }

    public abstract TopItem buildTopItem();

    protected final void changeValue() {
    }

    protected final void clearChildren() {
        ListIterator i = this.getListIterator();
        while (i.hasNext()) {
            EmbeddedModelElement child = (EmbeddedModelElement)i.next();
            child.detachFromContainer();
        }
        this.children.clear();
        this.notifyModelElementObservers(new Modification(this));
    }

    private int compareClass(Object o) {
        if (this.getClass().equals(o.getClass())) {
            return 0;
        }
        return this.getClass().getName().compareTo(o.getClass().getName());
    }

    protected final int compareContents(ModelElement e) {
        int result = 0;
        int n = Math.min(this.getNumberOfChildren(), e.getNumberOfChildren());
        for (int i = 0; result == 0 && i < n; ++i) {
            result = this.getChildAt(i).compareTo(e.getChildAt(i));
        }
        if (result == 0) {
            result = this.getNumberOfChildren() - e.getNumberOfChildren();
        }
        return result;
    }

    public final int compareTo(Object o) {
        int result = this.compareClass(o);
        if (result == 0) {
            result = this.compareToAux((ModelElement)o);
        }
        return result;
    }

    protected abstract int compareToAux(ModelElement var1);

    protected void copyContentTo(ModelElement copy) {
        if (this.children != null) {
            copy.children = this.buildChildrenList();
            for (int i = 0; i < this.children.size(); ++i) {
                copy.addChild((EmbeddedModelElement)this.getChildAt(i).deepCopy());
            }
        }
    }

    public abstract ModelElement deepCopy();

    protected void disableUpdates() {
        this.updatesEnabled = false;
    }

    protected void enableUpdates() {
        this.updatesEnabled = true;
    }

    private void fixSlibings(int id) {
        EmbeddedModelElement child = null;
        EmbeddedModelElement nextChild = null;
        EmbeddedModelElement previousChild = null;
        if (id >= 0 && id < this.children.size()) {
            child = (EmbeddedModelElement)this.children.get(id);
        }
        if (id + 1 >= 0 && id + 1 < this.children.size()) {
            nextChild = (EmbeddedModelElement)this.children.get(id + 1);
        }
        if (id - 1 >= 0 && id - 1 < this.children.size()) {
            previousChild = (EmbeddedModelElement)this.children.get(id - 1);
        }
        if (child != null) {
            child.previous = previousChild;
            child.next = nextChild;
        }
        if (previousChild != null) {
            previousChild.next = child;
        }
        if (nextChild != null) {
            nextChild.previous = child;
        }
    }

    public final EmbeddedModelElement getChildAt(int id) {
        return (EmbeddedModelElement)this.children.get(id);
    }

    protected final String getChildrenAsString() {
        return this.children.toString();
    }

    protected final ListIterator getListIterator() {
        return this.children.listIterator();
    }

    protected final ListIterator getListIterator(int idx) {
        return this.children.listIterator(idx);
    }

    public final ModelElementIterator getModelElementIterator() {
        return new ModelElementIterator(this.children.iterator());
    }

    public abstract ModelElement getNextSlibing();

    public final int getNumberOfChildren() {
        return this.children.size();
    }

    public abstract ModelElement getPreviousSlibing();

    public boolean isBreak() {
        return false;
    }

    public boolean isFillX() {
        return this.fillX;
    }

    public boolean isFillY() {
        return this.fillY;
    }

    protected void notifyModification() {
        this.notifyModelElementObservers(new Modification(this));
    }

    protected final void removeChild(ModelElement child) {
        int id = this.children.indexOf(child);
        this.removeChildAt(id);
    }

    protected final void removeChildAt(int id) {
        if (id < 0 || id >= this.children.size()) {
            return;
        }
        EmbeddedModelElement child = (EmbeddedModelElement)this.children.get(id);
        this.children.remove(id);
        this.fixSlibings(id);
        child.detachFromContainer();
        this.notifyModelElementObservers(new Deletion(this, id, id + 1));
    }

    protected List removeChildren(int a, int b) {
        ArrayList l = new ArrayList(b - a);
        l.addAll(this.children.subList(a, b));
        for (int i = b - 1; i >= a; --i) {
            EmbeddedModelElement child = (EmbeddedModelElement)this.children.get(i);
            this.children.remove(i);
            child.detachFromContainer();
        }
        this.fixSlibings(a);
        this.notifyModelElementObservers(new Deletion(this, a, b));
        return l;
    }

    protected final void setChildAt(int idx, EmbeddedModelElement child) {
        EmbeddedModelElement oldChild = (EmbeddedModelElement)this.children.get(idx);
        oldChild.detachFromContainer();
        child.setParent(this);
        this.children.set(idx, child);
        this.fixSlibings(idx);
        this.notifyModelElementObservers(new Replacement(this, idx));
    }

    public void observedElementChanged(ModelOperation operation) {
        if (this.updatesEnabled) {
            this.notifyModelElementObservers(new ChildOperation(this, operation));
        }
    }

    protected abstract void notifyModelElementObservers(ModelOperation var1);

    public abstract ModelElement getParent();

    protected abstract void unsetContainers();
}

