/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdc.model;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jsesh.mdc.interfaces.OptionListInterface;

public class OptionsMap
implements OptionListInterface,
Comparable,
Serializable {
    TreeMap map = new TreeMap();

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public void setOption(String name, boolean value) {
        if (value) {
            this.map.put(name, null);
        } else {
            this.map.remove(name);
        }
    }

    public Object get(String name) {
        return this.map.get(name);
    }

    public boolean isDefined(String option) {
        return this.map.containsKey(option);
    }

    public String getString(String name, String defaultValue) {
        if (this.isDefined(name)) {
            return (String)this.map.get(name);
        }
        return defaultValue;
    }

    public OptionsMap deepCopy() {
        OptionsMap result = new OptionsMap();
        Set entries = this.map.entrySet();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            result.map.put(e.getKey(), e.getValue());
        }
        return result;
    }

    public int compareTo(Object o) {
        OptionsMap o1 = (OptionsMap)o;
        int result = 0;
        Iterator i = this.map.entrySet().iterator();
        Iterator j = o1.map.entrySet().iterator();
        while (result == 0 && i.hasNext() && j.hasNext()) {
            Map.Entry opt1 = i.next();
            Map.Entry opt2 = j.next();
            result = ((String)opt1.getKey()).compareTo((String)opt2.getKey());
            if (result != 0) continue;
            result = ((String)opt1.getValue()).compareTo((String)opt2.getValue());
        }
        if (result == 0) {
            int a = i.hasNext() ? 1 : 0;
            int b = j.hasNext() ? 1 : 0;
            result = a - b;
        }
        return result;
    }
}

