/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdc.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jsesh.mdc.interfaces.MDCFileInterface;
import jsesh.mdc.interfaces.TopItemListInterface;
import jsesh.mdc.model.MDCMark;
import jsesh.mdc.model.ModelElement;
import jsesh.mdc.model.ModelElementObserver;
import jsesh.mdc.model.ModelElementVisitor;
import jsesh.mdc.model.PageBreak;
import jsesh.mdc.model.TopItem;
import jsesh.mdc.model.TopItemIterator;
import jsesh.mdc.model.operations.ModelOperation;
import jsesh.mdc.model.operations.ZoneModification;

public class TopItemList
extends ModelElement
implements MDCFileInterface,
TopItemListInterface {
    transient List topItemListObservers;
    transient List marks;

    public void accept(ModelElementVisitor v) {
        v.visitTopItemList(this);
    }

    public void addAll(List elements) {
        super.addAll(elements, TopItem.class);
    }

    public void addAllAt(int index, List items) {
        super.addAllAt(index, items, TopItem.class);
    }

    public void addTopItem(TopItem topItem) {
        this.addChild(topItem);
    }

    public void addTopItemAt(int id, TopItem topItem) {
        this.addChildAt(id, topItem);
    }

    public int compareToAux(ModelElement e) {
        return this.compareContents(e);
    }

    public ModelElement deepCopy() {
        TopItemList r = new TopItemList();
        this.copyContentTo(r);
        return r;
    }

    public TopItem getTopItemAt(int i) {
        return (TopItem)this.getChildAt(i);
    }

    public TopItemIterator iterator() {
        return new TopItemIterator(this.getListIterator());
    }

    public TopItemIterator iterator(int idx) {
        return new TopItemIterator(this.getListIterator(idx));
    }

    public void removeTopItem(int i) {
        this.removeChildAt(i);
    }

    public void removeTopItem(TopItem topItem) {
        this.removeChild(topItem);
    }

    public String toString() {
        return this.getChildrenAsString();
    }

    public List removeTopItems(int a, int b) {
        return this.removeChildren(a, b);
    }

    public TopItem buildTopItem() {
        return null;
    }

    public void shade(int a, int b, boolean shade) {
        int start = Math.min(a, b);
        int end = Math.max(a, b);
        this.disableUpdates();
        for (int i = start; i < end; ++i) {
            TopItem t = this.getTopItemAt(i);
            t.getState().setShaded(shade);
        }
        this.enableUpdates();
        this.notifyModelElementObservers(new ZoneModification(this, start, end));
    }

    public void setRed(int a, int b, boolean red) {
        int start = Math.min(a, b);
        int end = Math.max(a, b);
        this.disableUpdates();
        for (int i = start; i < end; ++i) {
            TopItem t = this.getTopItemAt(i);
            t.getState().setRed(red);
        }
        this.enableUpdates();
        this.notifyModelElementObservers(new ZoneModification(this, start, end));
    }

    public int getNumberOfPages() {
        int result = 1;
        for (int i = 0; i < this.getNumberOfChildren(); ++i) {
            if (!(this.getChildAt(i) instanceof PageBreak)) continue;
            ++result;
        }
        return result;
    }

    protected void notifyModelElementObservers(ModelOperation op) {
        Iterator it;
        if (this.marks != null) {
            it = this.marks.iterator();
            while (it.hasNext()) {
                MDCMark mark = (MDCMark)it.next();
                mark.updateMark(op);
            }
        }
        if (this.topItemListObservers != null) {
            it = this.topItemListObservers.iterator();
            while (it.hasNext()) {
                ModelElementObserver observer = (ModelElementObserver)it.next();
                observer.observedElementChanged(op);
            }
        }
    }

    public ModelElement getParent() {
        return null;
    }

    protected void unsetContainers() {
        this.topItemListObservers = null;
    }

    public ModelElement getNextSlibing() {
        return null;
    }

    public ModelElement getPreviousSlibing() {
        return null;
    }

    public void deleteObserver(ModelElementObserver obs) {
        if (this.topItemListObservers != null) {
            this.topItemListObservers.remove(obs);
            if (this.topItemListObservers.isEmpty()) {
                this.topItemListObservers = null;
            }
        }
    }

    public void addObserver(ModelElementObserver obs) {
        if (this.topItemListObservers == null) {
            this.topItemListObservers = new ArrayList();
        }
        this.topItemListObservers.add(obs);
    }

    public void addMark(MDCMark mdcMark) {
        if (this.marks == null) {
            this.marks = new ArrayList();
        }
        this.marks.add(mdcMark);
    }

    public void removeMark(MDCMark mdcMark) {
        if (this.marks != null) {
            this.marks.remove(mdcMark);
            if (this.marks.isEmpty()) {
                this.marks = null;
            }
        }
    }
}

