/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdc.model.utilities;

import java.util.Iterator;
import java.util.List;
import jsesh.mdc.model.AlphabeticText;
import jsesh.mdc.model.BasicItem;
import jsesh.mdc.model.BasicItemList;
import jsesh.mdc.model.Cadrat;
import jsesh.mdc.model.HBox;
import jsesh.mdc.model.ModelElement;
import jsesh.mdc.model.ModelElementAdapter;
import jsesh.mdc.model.SubCadrat;

public class VerticalGrouper {
    public Cadrat buildCadrat(List elts) {
        CadratBuilderAux aux = new CadratBuilderAux();
        Iterator i = elts.iterator();
        while (aux.correct && i.hasNext()) {
            ModelElement e = (ModelElement)i.next();
            e.accept(aux);
        }
        if (aux.correct) {
            return aux.cadrat;
        }
        return null;
    }

    private static class CadratBuilderAux
    extends ModelElementAdapter {
        Cadrat cadrat = new Cadrat();
        boolean correct = true;

        public void visitCadrat(Cadrat c) {
            for (int i = 0; i < c.getNumberOfHBoxes(); ++i) {
                HBox box = (HBox)c.getHBox(i).deepCopy();
                this.cadrat.addHBox(box);
            }
        }

        public void visitAlphabeticText(AlphabeticText t) {
            HBox box = new HBox();
            BasicItemList l = new BasicItemList();
            l.addBasicItem((BasicItem)t.deepCopy());
            box.addHorizontalListElement(new SubCadrat(l));
        }

        public void visitDefault(ModelElement t) {
            this.correct = false;
        }
    }
}

