/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdc.output;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import jsesh.mdc.constants.LexicalSymbolsUtils;
import jsesh.mdc.constants.WordEndingCode;
import jsesh.mdc.model.AbsoluteGroup;
import jsesh.mdc.model.AlphabeticText;
import jsesh.mdc.model.BasicItemList;
import jsesh.mdc.model.Cadrat;
import jsesh.mdc.model.Cartouche;
import jsesh.mdc.model.ComplexLigature;
import jsesh.mdc.model.EmbeddedModelElement;
import jsesh.mdc.model.HBox;
import jsesh.mdc.model.HRule;
import jsesh.mdc.model.Hieroglyph;
import jsesh.mdc.model.InnerGroup;
import jsesh.mdc.model.Ligature;
import jsesh.mdc.model.LineBreak;
import jsesh.mdc.model.ModelElement;
import jsesh.mdc.model.ModelElementVisitor;
import jsesh.mdc.model.Modifier;
import jsesh.mdc.model.ModifiersList;
import jsesh.mdc.model.OptionsMap;
import jsesh.mdc.model.Overwrite;
import jsesh.mdc.model.PageBreak;
import jsesh.mdc.model.Philology;
import jsesh.mdc.model.SubCadrat;
import jsesh.mdc.model.Superscript;
import jsesh.mdc.model.TabStop;
import jsesh.mdc.model.TopItem;
import jsesh.mdc.model.TopItemList;
import jsesh.mdc.model.TopItemState;
import jsesh.mdc.model.ZoneStart;

public class ModelWriter {
    private Writer out = null;
    private int startIndex;
    private int endIndex;

    public void write(String fileName, TopItemList top) throws IOException {
        FileWriter w = new FileWriter(fileName);
        this.write(w, top);
        ((Writer)w).close();
    }

    public void write(File f, TopItemList top) throws IOException {
        FileWriter w = new FileWriter(f);
        this.write(w, top);
        ((Writer)w).close();
    }

    public void write(Writer out, TopItemList top) {
        this.write(out, top, 0, top.getNumberOfChildren());
    }

    public void write(Writer w, TopItemList top, int a, int b) {
        this.out = w;
        ModelWriterAux aux = new ModelWriterAux();
        this.startIndex = a;
        this.endIndex = b;
        top.accept(aux);
    }

    class ModelWriterAux
    implements ModelElementVisitor {
        boolean wantsMinus = true;

        ModelWriterAux() {
        }

        private void write(String s) {
            try {
                ModelWriter.this.out.write(s);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void write(char s) {
            try {
                ModelWriter.this.out.write(s);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void visitElementList(ModelElement elt, String separator) {
            for (int i = 0; i < elt.getNumberOfChildren(); ++i) {
                EmbeddedModelElement sub = elt.getChildAt(i);
                if (i > 0) {
                    this.write(separator);
                }
                sub.accept(this);
            }
        }

        public void visitAlphabeticText(AlphabeticText t) {
            this.write("+" + t.getScriptCode());
            String text = t.getText().toString();
            text = text.replaceAll("\\\\", "\\\\");
            text = text.replaceAll("\\+", "\\\\+");
            this.write(text);
            this.write("+s");
        }

        public void visitBasicItemList(BasicItemList l) {
            this.visitElementList(l, "-");
        }

        public void visitCadrat(Cadrat c) {
            this.visitElementList(c, ":");
            int sh = c.getShading();
            if (sh != 0) {
                this.write("#");
                if ((sh & 1) != 0) {
                    this.write("1");
                }
                if ((sh & 2) != 0) {
                    this.write("2");
                }
                if ((sh & 4) != 0) {
                    this.write("3");
                }
                if ((sh & 8) != 0) {
                    this.write("4");
                }
            }
        }

        public void visitCartouche(Cartouche c) {
            String end;
            String start;
            String cartoucheCode = "";
            if (c.getType() != 99) {
                cartoucheCode = "" + (char)c.getType();
            }
            if (c.getStartPart() == 1 && c.getEndPart() == 2) {
                start = "<" + cartoucheCode.toUpperCase() + "-";
                end = "->";
            } else {
                start = "<" + cartoucheCode + c.getStartPart() + "-";
                end = "-" + cartoucheCode + c.getEndPart() + ">";
            }
            this.write(start);
            c.getBasicItemList().accept(this);
            this.write(end);
        }

        public void visitHBox(HBox b) {
            this.visitElementList(b, "*");
        }

        public void visitHieroglyph(Hieroglyph h) {
            boolean explicitPosition = false;
            if (h.isGrammar()) {
                this.write("=");
            }
            this.write(h.getCode());
            ModifiersList l = h.getModifiers();
            if (l.isReversed()) {
                this.write("\\");
            }
            if (h.getX() != 0 || h.getY() != 0) {
                explicitPosition = true;
            }
            if (!explicitPosition && l.getScale() != 100) {
                this.write("\\" + l.getScale());
            }
            if (l.getAngle() != 0) {
                this.write("\\R" + l.getAngle());
            }
            this.visitModifierList(l);
            if (explicitPosition) {
                this.write("{{");
                this.write("" + h.getX() + "," + h.getY() + "," + l.getScale());
                this.write("}}");
            }
            if (h.getEndingCode().equals(WordEndingCode.WORD_END)) {
                this.write("_");
            } else if (h.getEndingCode().equals(WordEndingCode.SENTENCE_END)) {
                this.write("__");
            }
        }

        public void visitHRule(HRule h) {
            this.write("{");
            this.write(h.getType());
            this.write("" + h.getStartPos());
            this.write("," + h.getEndPos() + "}");
        }

        public void visitLigature(Ligature l) {
            this.visitElementList(l, "&");
        }

        public void visitModifier(Modifier mod) {
            this.write('\\');
            if (mod.getName() != null) {
                this.write(mod.getName());
            }
            if (mod.getValue() != null) {
                this.write(mod.getValue().toString());
            }
        }

        public void visitModifierList(ModifiersList l) {
            for (int i = 0; i < l.getNumberOfChildren(); ++i) {
                this.visitModifier(l.getModifierAt(i));
            }
        }

        public void visitOverwrite(Overwrite o) {
            o.getFirst().accept(this);
            this.write("##");
            o.getSecond().accept(this);
        }

        public void visitPhilology(Philology p) {
            String open = LexicalSymbolsUtils.getOpenCodeForPhilology(p.getType());
            String close = LexicalSymbolsUtils.getCloseCodeForPhilology(p.getType());
            this.write(open);
            this.write('-');
            this.visitElementList(p, "-");
            this.write('-');
            this.write(close);
        }

        public void visitSubCadrat(SubCadrat c) {
            this.write("(");
            this.visitElementList(c, "-");
            this.write(")");
        }

        public void visitSuperScript(Superscript s) {
            this.write("|" + s.getText() + "-");
            this.wantsMinus = false;
        }

        public void visitTabStop(TabStop t) {
            this.write("?" + t.getStopPos());
        }

        public void visitTopItemList(TopItemList t) {
            TopItemState state = new TopItemState();
            boolean virtualpos = false;
            boolean redCloser = false;
            for (int i = ModelWriter.this.startIndex; i < ModelWriter.this.endIndex; ++i) {
                TopItem sub = t.getTopItemAt(i);
                TopItemState newState = sub.getState();
                if (i > ModelWriter.this.startIndex && this.wantsMinus) {
                    this.write('-');
                }
                this.wantsMinus = true;
                if (sub instanceof LineBreak || sub instanceof PageBreak) {
                    newState = new TopItemState();
                }
                redCloser = this.fixToggles(state, newState, redCloser);
                sub.accept(this);
                state = newState;
            }
            this.fixToggles(state, new TopItemState(), redCloser);
        }

        private boolean fixToggles(TopItemState state, TopItemState newState, boolean redCloser) {
            if (newState.isRed() != state.isRed() || newState.isShaded() != state.isShaded()) {
                boolean openRed;
                boolean closeGray = !newState.isShaded() && state.isShaded();
                boolean openGray = newState.isShaded() && !state.isShaded();
                boolean closeRed = !newState.isRed() && state.isRed();
                boolean bl = openRed = newState.isRed() && !state.isRed();
                if (closeGray && closeRed) {
                    if (redCloser) {
                        this.write("$b-#e-");
                    } else {
                        this.write("#e-$b-");
                    }
                } else if (closeGray) {
                    if (state.isRed() && redCloser) {
                        this.write("$b-#e-$r-");
                        redCloser = true;
                    } else {
                        this.write("#e-");
                    }
                } else if (closeRed) {
                    if (state.isShaded() && !redCloser) {
                        this.write("#e-$b-#b-");
                        redCloser = false;
                    } else {
                        this.write("$b-");
                    }
                }
                if (openGray) {
                    this.write("#b-");
                    redCloser = false;
                }
                if (openRed) {
                    this.write("$r-");
                    redCloser = true;
                }
            }
            return redCloser;
        }

        public void visitLineBreak(LineBreak b) {
            this.write("!");
            if (b.getSpacing() != 100) {
                this.write("=" + b.getSpacing() + "%");
            }
            this.write("\n");
            this.wantsMinus = false;
        }

        public void visitPageBreak(PageBreak b) {
            this.write("!!\n");
            this.wantsMinus = false;
        }

        public void visitAbsoluteGroup(AbsoluteGroup g) {
            this.visitElementList(g, "**");
        }

        public void visitZoneStart(ZoneStart start) {
            this.write("zone");
        }

        public void visitOptionList(OptionsMap list) {
        }

        public void visitComplexLigature(ComplexLigature ligature) {
            InnerGroup before = ligature.getBeforeGroup();
            InnerGroup after = ligature.getAfterGroup();
            if (before != null) {
                before.accept(this);
                this.write("^^^");
            }
            ligature.getHieroglyph().accept(this);
            if (after != null) {
                this.write("&&&");
                after.accept(this);
            }
        }
    }
}

