/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdc.output.dom;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import jsesh.mdc.model.AbsoluteGroup;
import jsesh.mdc.model.AlphabeticText;
import jsesh.mdc.model.BasicItemList;
import jsesh.mdc.model.Cadrat;
import jsesh.mdc.model.Cartouche;
import jsesh.mdc.model.ComplexLigature;
import jsesh.mdc.model.HBox;
import jsesh.mdc.model.HRule;
import jsesh.mdc.model.Hieroglyph;
import jsesh.mdc.model.Ligature;
import jsesh.mdc.model.LineBreak;
import jsesh.mdc.model.ModelElement;
import jsesh.mdc.model.ModelElementIterator;
import jsesh.mdc.model.ModelElementVisitor;
import jsesh.mdc.model.Modifier;
import jsesh.mdc.model.ModifiersList;
import jsesh.mdc.model.OptionsMap;
import jsesh.mdc.model.Overwrite;
import jsesh.mdc.model.PageBreak;
import jsesh.mdc.model.Philology;
import jsesh.mdc.model.SubCadrat;
import jsesh.mdc.model.Superscript;
import jsesh.mdc.model.TabStop;
import jsesh.mdc.model.TopItemList;
import jsesh.mdc.model.ZoneStart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class MDCDOMBuilder {
    public static final String ALPHABETIC_TEXT = "alphabeticText";
    public static final String FILL_X = "fillX";
    public static final String FILL_Y = "fillY";
    public static final String ORIENTATION = "orientation";
    public static final String BASIC_ITEM_LIST = "basicItemList";
    public static final String CADRAT = "cadrat";
    public static final String SHADING = "shading";
    public static final String CARTOUCHE = "cartouche";
    public static final String START_PART = "startPart";
    public static final String END_PART = "endPart";
    public static final String TYPE = "type";
    public static final String TOGGLE = "toggle";
    public static final String TABSTOP = "tabStop";
    public static final String VALUE = "value";
    public static final String HBOX = "hbox";
    public static final String HRULE = "hrule";
    public static final String START_POS = "startPos";
    public static final String END_POS = "endPos";
    public static final String LIGATURE = "ligature";
    public static final String OVERWRITE = "overwrite";
    public static final String PHILOLOGY = "philology";
    public static final String SUBCADRAT = "subcadrat";
    public static final String SUPERSCRIPT = "superscript";
    public static final String TOP_ITEM_LIST = "topItemList";
    public static final String LINE_BREAK = "lineBreak";
    public static final String SKIP = "skip";
    public static final String PAGE_BREAK = "pageBreak";
    public static final String HIEROGLYPH = "hieroglyph";
    public static final String ENDINGCODE = "endingCode";
    public static final String GRAMMAR = "grammar";
    public static final String ANGLE = "angle";
    public static final String SCALE = "scale";
    public static final String REVERSED = "reversed";
    public static final String UNSURE = "unsure";
    public static final String ABSOLUTE = "absolute";
    public static final String COMPLEXLIGATURE = "complexLigature";
    private Document theDocument;
    MDCDOMBuilderAux visitor = new MDCDOMBuilderAux();

    public Document buildMDCDOM(TopItemList l) {
        this.theDocument = null;
        this.visitor.init();
        l.accept(this.visitor);
        return this.theDocument;
    }

    private class MDCDOMBuilderAux
    implements ModelElementVisitor {
        DocumentBuilder documentBuilder;
        Node parent;

        public MDCDOMBuilderAux() {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                this.documentBuilder = factory.newDocumentBuilder();
            }
            catch (FactoryConfigurationError e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
        }

        public void init() {
            MDCDOMBuilder.this.theDocument = this.documentBuilder.newDocument();
            this.parent = MDCDOMBuilder.this.theDocument;
        }

        public void visitAlphabeticText(AlphabeticText t) {
            Element node = this.createModelElement(MDCDOMBuilder.ALPHABETIC_TEXT, t);
            this.setText(node, t.getText().toString());
            this.parent.appendChild(node);
        }

        public void visitBasicItemList(BasicItemList l) {
            Element e = this.createContainerElement(MDCDOMBuilder.BASIC_ITEM_LIST, l);
        }

        public void visitCadrat(Cadrat c) {
            Element e = this.createContainerElement(MDCDOMBuilder.CADRAT, c);
            e.setAttribute(MDCDOMBuilder.SHADING, "" + c.getShading());
        }

        public void visitCartouche(Cartouche c) {
            Element node = this.createContainerElement(MDCDOMBuilder.CARTOUCHE, c);
            node.setAttribute(MDCDOMBuilder.START_PART, "" + c.getStartPart());
            node.setAttribute(MDCDOMBuilder.END_PART, "" + c.getEndPart());
            node.setAttribute(MDCDOMBuilder.TYPE, "" + c.getType());
        }

        public void visitHBox(HBox b) {
            Element node = this.createContainerElement(MDCDOMBuilder.HBOX, b);
        }

        public void visitHieroglyph(Hieroglyph h) {
            Node oldParent = this.parent;
            Element node = this.createModelElement(MDCDOMBuilder.HIEROGLYPH, h);
            node.setAttribute(MDCDOMBuilder.ENDINGCODE, "" + h.getEndingCode());
            node.setAttribute(MDCDOMBuilder.GRAMMAR, "" + h.isGrammar());
            node.setAttribute(MDCDOMBuilder.TYPE, "" + h.getType());
            this.parent = node;
            h.getModifiers().accept(this);
            this.setText(node, h.getCode());
            this.parent = oldParent;
        }

        public void visitHRule(HRule h) {
            Element node = this.createModelElement(MDCDOMBuilder.HRULE, h);
            node.setAttribute(MDCDOMBuilder.START_POS, "" + h.getStartPos());
            node.setAttribute(MDCDOMBuilder.END_POS, "" + h.getEndPos());
            node.setAttribute(MDCDOMBuilder.TYPE, "" + h.getType());
        }

        public void visitLigature(Ligature l) {
            Element e = this.createContainerElement(MDCDOMBuilder.LIGATURE, l);
        }

        public void visitAbsoluteGroup(AbsoluteGroup g) {
            Element e = this.createContainerElement(MDCDOMBuilder.ABSOLUTE, g);
        }

        public void visitModifier(Modifier mod) {
            Element e = (Element)this.parent;
            if ("?".equals(mod.getName())) {
                e.setAttribute(MDCDOMBuilder.UNSURE, "true");
            } else if (mod.getValue() == null) {
                e.setAttribute(mod.getName(), "true");
            } else {
                e.setAttribute(mod.getName(), "" + mod.getValue().toString());
            }
        }

        public void visitModifierList(ModifiersList l) {
            Element e = (Element)this.parent;
            if (l.getAngle() != 0) {
                e.setAttribute(MDCDOMBuilder.ANGLE, "" + l.getAngle());
            }
            if (l.isReversed()) {
                e.setAttribute(MDCDOMBuilder.REVERSED, "true");
            }
            if (l.getScale() != 100) {
                e.setAttribute(MDCDOMBuilder.SCALE, "" + l.getScale());
            }
            ModelElementIterator i = l.getModelElementIterator();
            while (i.hasNext()) {
                ModelElement subElement = i.next();
                subElement.accept(this);
            }
        }

        public void visitOverwrite(Overwrite o) {
            Element node = this.createContainerElement(MDCDOMBuilder.OVERWRITE, o);
        }

        public void visitPhilology(Philology p) {
            Element e = this.createContainerElement(MDCDOMBuilder.PHILOLOGY, p);
            e.setAttribute(MDCDOMBuilder.TYPE, "" + p.getType());
        }

        public void visitComplexLigature(ComplexLigature ligature) {
            Element subNode;
            Node oldParent = this.parent;
            Element e = this.createModelElement(MDCDOMBuilder.COMPLEXLIGATURE, ligature);
            if (ligature.getBeforeGroup() != null) {
                subNode = MDCDOMBuilder.this.theDocument.createElement("beforeGroup");
                e.appendChild(subNode);
                this.parent = subNode;
                ligature.getBeforeGroup().accept(this);
            }
            subNode = MDCDOMBuilder.this.theDocument.createElement("mainSign");
            e.appendChild(subNode);
            this.parent = subNode;
            ligature.getHieroglyph().accept(this);
            if (ligature.getAfterGroup() != null) {
                Element subNode1 = MDCDOMBuilder.this.theDocument.createElement("afterGroup");
                e.appendChild(subNode1);
                this.parent = subNode1;
                ligature.getAfterGroup().accept(this);
            }
            this.parent = oldParent;
        }

        public void visitSubCadrat(SubCadrat c) {
            Element e = this.createContainerElement(MDCDOMBuilder.SUBCADRAT, c);
        }

        public void visitSuperScript(Superscript s) {
            Element node = this.createModelElement(MDCDOMBuilder.SUPERSCRIPT, s);
            this.setText(node, s.getText().toString());
        }

        public void visitTabStop(TabStop t) {
            Element node = this.createModelElement(MDCDOMBuilder.TABSTOP, t);
            node.setAttribute(MDCDOMBuilder.VALUE, "" + t.getStopPos());
        }

        public void visitTopItemList(TopItemList t) {
            Element e = this.createContainerElement(MDCDOMBuilder.TOP_ITEM_LIST, t);
        }

        public void visitLineBreak(LineBreak b) {
            Element node = this.createModelElement(MDCDOMBuilder.LINE_BREAK, b);
            node.setAttribute(MDCDOMBuilder.SKIP, "" + b.getSpacing());
        }

        public void visitPageBreak(PageBreak b) {
            Element node = this.createModelElement(MDCDOMBuilder.PAGE_BREAK, b);
        }

        public Element createContainerElement(String title, ModelElement e) {
            Node oldParent = this.parent;
            Element node = this.createModelElement(title, e);
            this.parent = node;
            ModelElementIterator i = e.getModelElementIterator();
            while (i.hasNext()) {
                ModelElement subElement = i.next();
                subElement.accept(this);
            }
            this.parent = oldParent;
            return node;
        }

        private Element createModelElement(String name, ModelElement elt) {
            Element node = MDCDOMBuilder.this.theDocument.createElement(name);
            node.setAttribute(MDCDOMBuilder.FILL_X, "" + elt.isFillX());
            node.setAttribute(MDCDOMBuilder.FILL_Y, "" + elt.isFillY());
            this.parent.appendChild(node);
            return node;
        }

        private void setText(Node n, String t) {
            Text e = MDCDOMBuilder.this.theDocument.createTextNode(t);
            n.appendChild(e);
        }

        public void visitZoneStart(ZoneStart start) {
        }

        public void visitOptionList(OptionsMap list) {
        }
    }
}

