/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.draw;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jsesh.mdc.model.MDCMark;
import jsesh.mdc.model.MDCPosition;
import jsesh.mdc.model.TopItemList;
import jsesh.mdcDisplayer.draw.MDCCaretChangeListener;

public class MDCCaret {
    private MDCMark insert;
    private MDCMark mark = null;
    private List listeners = new ArrayList();

    public MDCCaret(MDCMark insert) {
        this.setInsert(insert);
    }

    public MDCCaret(TopItemList model) {
        this(new MDCMark(new MDCPosition(model, 0)));
    }

    public MDCMark getInsert() {
        return this.insert;
    }

    public void setInsert(MDCMark insert) {
        if (this.insert != null) {
            this.insert.release();
        }
        this.insert = insert;
        this.notifyCaretListeners();
    }

    public void changeModel(TopItemList model) {
        if (this.mark != null) {
            this.mark.release();
        }
        this.mark = null;
        this.setInsert(new MDCMark(new MDCPosition(model, 0)));
    }

    public MDCMark getMark() {
        return this.mark;
    }

    public void setMark(MDCMark newMark) {
        if (this.mark != null) {
            this.mark.release();
        }
        this.mark = newMark;
        this.notifyCaretListeners();
    }

    public void unsetMark() {
        this.setMark(null);
    }

    public TopItemList getModel() {
        return this.insert.getPosition().getTopItemList();
    }

    public void moveInsertBy(int i) {
        this.setInsertPosition(this.insert.getNextPosition(i));
    }

    public void moveInsertTo(int i) {
        this.setInsertPosition(this.insert.getPositionAt(i));
    }

    public void setMarkAt(int i) {
        this.setMark(new MDCMark(this.insert.getPosition().getPositionAt(i)));
    }

    private void notifyCaretListeners() {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            MDCCaretChangeListener l = (MDCCaretChangeListener)i.next();
            l.caretChanged(this);
        }
    }

    public void addCaretChangeListener(MDCCaretChangeListener l) {
        this.listeners.add(l);
    }

    public void removeCaretChangeListener(MDCCaretChangeListener l) {
        this.listeners.remove(l);
    }

    public boolean hasMark() {
        return this.mark != null;
    }

    public int getMin() {
        if (this.hasMark()) {
            return Math.min(this.getInsert().getIndex(), this.getMark().getIndex());
        }
        return this.getInsert().getIndex();
    }

    public int getMax() {
        if (this.hasMark()) {
            return Math.max(this.getInsert().getIndex(), this.getMark().getIndex());
        }
        return this.getInsert().getIndex();
    }

    public boolean hasSelection() {
        return this.hasMark() && this.getMin() != this.getMax();
    }

    public void setInsertPosition(MDCPosition p) {
        MDCMark newInsert = new MDCMark(p);
        this.setInsert(newInsert);
    }

    public void advanceInsertBy(int dir) {
        MDCPosition pos = this.insert.getNextPosition(dir);
        this.setInsertPosition(pos);
    }
}

