/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.layout;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jsesh.mdc.constants.TextDirection;
import jsesh.mdc.model.AlphabeticText;
import jsesh.mdc.model.LineBreak;
import jsesh.mdc.model.ModelElement;
import jsesh.mdc.model.ModelElementAdapter;
import jsesh.mdc.model.PageBreak;
import jsesh.mdc.model.TabStop;
import jsesh.mdcDisplayer.layout.TopItemLayout;
import jsesh.mdcDisplayer.layout.Zone;
import jsesh.mdcDisplayer.mdcView.MDCView;
import jsesh.mdcDisplayer.preferences.DrawingSpecifications;

public class LineLayout
extends TopItemLayout {
    private MDCView documentView;
    Rectangle2D documentArea;
    private Point2D insertionPoint;
    private Zone zone;
    private Point2D.Double zoneStart;
    private DrawingSpecifications drawingSpecifications;
    private TextDirection currentTextDirection;
    private MDCView subView;
    private boolean addTopMargin;
    private LineLayoutAux aux = new LineLayoutAux();

    public LineLayout(MDCView documentView, DrawingSpecifications drawingSpecifications) {
        this.documentView = documentView;
        this.documentArea = new Rectangle2D.Double();
        this.insertionPoint = new Point2D.Double();
        this.drawingSpecifications = drawingSpecifications;
        this.currentTextDirection = drawingSpecifications.getTextDirection();
    }

    public void layoutElement(MDCView subView) {
        this.subView = subView;
        subView.getPosition().setLocation(0.0, 0.0);
        subView.getModel().accept(this.aux);
        this.subView = null;
    }

    public void endLayout() {
        if (!this.zone.isEmpty()) {
            this.flushZone();
        }
    }

    public Rectangle2D getDocumentArea() {
        return this.documentArea;
    }

    public void startLayout() {
        this.addTopMargin = true;
        this.resetView();
        this.documentView.setDirection(this.currentTextDirection);
        this.insertionPoint.setLocation(0.0, 0.0);
        this.zone = new Zone(0.0, this.drawingSpecifications.getMaxCadratHeight());
        this.zoneStart = new Point2D.Double();
    }

    public void resetView() {
        this.documentView.reset();
    }

    private void flushZone() {
        float marginx = 0.0f;
        float marginy = 0.0f;
        if (this.addTopMargin) {
            marginy = this.drawingSpecifications.getTopMargin();
        }
        marginx = this.drawingSpecifications.getLeftMargin();
        this.zoneStart.y = this.zoneStart.y + (double)marginy - this.zone.getMinY();
        this.zoneStart.x = (double)marginx - this.zone.getMinX();
        this.zone.translateBy(this.zoneStart);
        this.documentArea.add(new Rectangle2D.Double(this.zoneStart.x, this.zoneStart.y, this.zone.getWidth(), this.zone.getHeight()));
    }

    private class LineLayoutAux
    extends ModelElementAdapter {
        private LineLayoutAux() {
        }

        public void visitLineBreak(LineBreak b) {
            double verticalSkip = LineLayout.this.zone.getHeight() + LineLayout.this.zone.getMinY() + (double)LineLayout.this.drawingSpecifications.getLineSkip();
            if (b.getSpacing() != 100) {
                verticalSkip = verticalSkip * (double)b.getSpacing() / 100.0;
            }
            LineLayout.this.zone.add(LineLayout.this.subView);
            LineLayout.this.flushZone();
            LineLayout.this.zone = new Zone(0.0, LineLayout.this.drawingSpecifications.getMaxCadratHeight());
            ((LineLayout)LineLayout.this).zoneStart.y += verticalSkip;
            LineLayout.this.addTopMargin = false;
        }

        public void visitPageBreak(PageBreak b) {
            double dh = LineLayout.this.zone.getHeight();
            LineLayout.this.flushZone();
            LineLayout.this.zone = new Zone(0.0, 0.0);
            ((LineLayout)LineLayout.this).zoneStart.y += (double)LineLayout.this.drawingSpecifications.getLineSkip() + dh;
            LineLayout.this.subView.setWidth(32.0f);
            LineLayout.this.subView.setHeight(LineLayout.this.drawingSpecifications.getLineSkip());
            LineLayout.this.zone.add(LineLayout.this.subView);
            LineLayout.this.flushZone();
            LineLayout.this.zone = new Zone(0.0, LineLayout.this.drawingSpecifications.getMaxCadratHeight());
            LineLayout.this.addTopMargin = true;
        }

        public void visitTabStop(TabStop tab) {
            float pos = (float)tab.getStopPos() / 200.0f * LineLayout.this.drawingSpecifications.getBaseLength();
            LineLayout.this.zone.getCurrentPoint().setLocation(pos, 0.0);
            LineLayout.this.zone.add(LineLayout.this.subView);
        }

        public void visitAlphabeticText(AlphabeticText t) {
            this.visitDefault(t);
        }

        public void visitDefault(ModelElement t) {
            double dx = 0.0;
            double dy = 0.0;
            if (LineLayout.this.subView.getWidth() != 0.0f) {
                dx = LineLayout.this.subView.getWidth() + LineLayout.this.drawingSpecifications.getSmallSkip();
            }
            LineLayout.this.zone.add(LineLayout.this.subView);
            LineLayout.this.zone.moveCurrentPoint(dx, dy);
        }
    }
}

