/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.layout;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import jsesh.mdc.constants.LexicalSymbolsUtils;
import jsesh.mdc.constants.TextOrientation;
import jsesh.mdc.model.AbsoluteGroup;
import jsesh.mdc.model.AlphabeticText;
import jsesh.mdc.model.BasicItemList;
import jsesh.mdc.model.Cadrat;
import jsesh.mdc.model.Cartouche;
import jsesh.mdc.model.ComplexLigature;
import jsesh.mdc.model.HBox;
import jsesh.mdc.model.HRule;
import jsesh.mdc.model.Hieroglyph;
import jsesh.mdc.model.Ligature;
import jsesh.mdc.model.LineBreak;
import jsesh.mdc.model.ModelElement;
import jsesh.mdc.model.ModelElementAdapter;
import jsesh.mdc.model.Modifier;
import jsesh.mdc.model.ModifiersList;
import jsesh.mdc.model.Overwrite;
import jsesh.mdc.model.PageBreak;
import jsesh.mdc.model.Philology;
import jsesh.mdc.model.SubCadrat;
import jsesh.mdc.model.Superscript;
import jsesh.mdc.model.TabStop;
import jsesh.mdc.model.TopItemList;
import jsesh.mdcDisplayer.draw.HieroglyphsDrawer;
import jsesh.mdcDisplayer.draw.LigatureManager;
import jsesh.mdcDisplayer.layout.AbstractLayout;
import jsesh.mdcDisplayer.layout.ColumnLayout;
import jsesh.mdcDisplayer.layout.ExplicitPosition;
import jsesh.mdcDisplayer.layout.LineLayout;
import jsesh.mdcDisplayer.layout.TopItemLayout;
import jsesh.mdcDisplayer.mdcView.MDCView;
import jsesh.mdcDisplayer.mdcView.ViewIterator;
import jsesh.mdcDisplayer.mdcView.ViewSide;
import jsesh.mdcDisplayer.preferences.DrawingSpecifications;
import jsesh.utils.TranslitterationUtilities;

public class SimpleLayout
extends AbstractLayout {
    protected LigatureManager ligatureManager = LigatureManager.getInstance();

    public void preLayoutHook(MDCView view, int depth) {
        if (view.getModel() instanceof Cartouche) {
            this.centerSigns = true;
        }
    }

    public void postLayoutHook(MDCView result, int depth) {
    }

    protected void commonLayoutHook() {
        this.currentView.setDirection(this.currentTextDirection);
    }

    public void reset(DrawingSpecifications drawingSpecifications) {
        this.drawingSpecifications = drawingSpecifications;
        this.currentTextOrientation = drawingSpecifications.getTextOrientation();
        this.currentTextDirection = drawingSpecifications.getTextDirection();
        this.centerSigns = drawingSpecifications.isSmallSignsCentered();
    }

    public void cleanup() {
        this.drawingSpecifications = null;
    }

    public void visitAbsoluteGroup(AbsoluteGroup g) {
        for (int i = 0; i < this.currentView.getNumberOfSubviews(); ++i) {
            MDCView subv = this.currentView.getSubView(i);
            Hieroglyph h = g.getHieroglyphAt(i);
            subv.resetPos();
            double x = (double)((float)h.getX() * this.drawingSpecifications.getBaseLength()) / 1000.0;
            double y = (double)((float)h.getY() * this.drawingSpecifications.getBaseLength()) / 1000.0;
            subv.getPosition().setLocation(x, y);
        }
        this.currentView.fitToSubViews(false);
    }

    public void visitAlphabeticText(AlphabeticText t) {
        if (t.getScriptCode() == '+') {
            this.currentView.reset();
            this.currentView.resetPos();
            return;
        }
        String text = t.getText();
        if (t.getScriptCode() == 't') {
            text = TranslitterationUtilities.toLowerCase(text);
        }
        Rectangle2D dims = this.drawingSpecifications.getTextDimensions(t.getScriptCode(), text);
        this.currentView.setHeight((float)dims.getHeight());
        this.currentView.setWidth((float)dims.getWidth());
        this.currentView.setDeltaBaseX(dims.getMinX());
        this.currentView.setDeltaBaseY(dims.getMinY() + (double)this.drawingSpecifications.getMaxCadratHeight());
        this.currentView.setDeltaBaseY(dims.getMinY() + (double)this.drawingSpecifications.getMaxCadratHeight() / 2.0);
    }

    public void visitBasicItemList(BasicItemList l) {
        if (this.drawingSpecifications.getTextOrientation().equals(TextOrientation.HORIZONTAL)) {
            this.visitDefault(l);
        } else {
            this.currentView.stackTop(this.drawingSpecifications.getSmallSkip());
            this.currentView.centerSubViewHorizontally();
        }
    }

    public void visitCadrat(Cadrat c) {
        ViewIterator i;
        boolean honourMaxWidth;
        boolean honourMaxHeight;
        this.currentView.setYStretchable(true);
        this.currentView.setXStretchable(true);
        if (this.currentTextOrientation.isHorizontal()) {
            honourMaxHeight = true;
            honourMaxWidth = false;
        } else {
            honourMaxHeight = false;
            honourMaxWidth = true;
        }
        boolean embedded = false;
        ModelElement e = c;
        while (!embedded && ((ModelElement)e).getParent() != null) {
            if (!((e = ((ModelElement)e).getParent()) instanceof SubCadrat)) continue;
            embedded = true;
        }
        if (embedded) {
            honourMaxHeight = false;
            honourMaxWidth = false;
        }
        float maxWidth = this.drawingSpecifications.getMaxCadratWidth();
        boolean wide = c.isWide();
        if (honourMaxWidth || this.currentView.getNumberOfSubviews() != 1 && !wide) {
            i = this.currentView.iterator();
            while (i.hasNext()) {
                i.next().scaleForMaxWidth(maxWidth);
            }
        }
        if (wide) {
            float maxw = honourMaxWidth ? maxWidth : this.currentView.getMaximalWidthOfSubView();
            for (int k = 0; k < this.currentView.getNumberOfSubviews(); ++k) {
                if (!c.getHBox(k).isWide()) continue;
                this.currentView.getSubView(k).scaleToWidth(maxw);
            }
        }
        float h = this.currentView.getSumOfSubViewsHeights();
        h += (float)(this.currentView.getNumberOfSubviews() - 1) * this.drawingSpecifications.getSmallSkip();
        if (honourMaxHeight && h < this.drawingSpecifications.getMaxCadratHeight()) {
            h = this.drawingSpecifications.getMaxCadratHeight();
        }
        this.currentView.setHeight(h);
        float w = this.currentView.getMaximalWidthOfSubView();
        if (honourMaxWidth && !embedded && w < maxWidth) {
            w = maxWidth;
        }
        this.currentView.setWidth(w);
        if (this.currentView.getNumberOfSubviews() > 1) {
            this.currentView.distributeFromTopToBottom();
        } else if (this.centerSigns) {
            this.currentView.centerSubViewsVertically();
        } else {
            this.currentView.stickSubViewsTo(ViewSide.BOTTOM);
        }
        i = this.currentView.iterator();
        while (i.hasNext()) {
            MDCView sub = i.next();
            if (sub.getWidth() < w) {
                sub.setWidth(w);
            }
            if (sub.getNumberOfSubviews() == 1) {
                sub.centerSubViewHorizontally();
                continue;
            }
            sub.distributeHorizontally();
            sub.stickSubViewsTo(ViewSide.BOTTOM);
        }
        if (honourMaxHeight && h > this.drawingSpecifications.getMaxCadratHeight()) {
            this.currentView.reScale(this.drawingSpecifications.getMaxCadratHeight() / h);
        }
    }

    public void visitCartouche(Cartouche c) {
        MDCView subView = this.currentView.getFirstSubView();
        float longDim = 0.0f;
        float smallDim = 2.0f * this.drawingSpecifications.computeCartoucheSecondaryLength(c.getType());
        float dLong = 0.0f;
        float dSmall = this.drawingSpecifications.computeCartoucheSecondaryLength(c.getType());
        dLong = longDim += this.drawingSpecifications.computeCartouchePartLength(c.getType(), c.getStartPart());
        longDim += this.drawingSpecifications.computeCartouchePartLength(c.getType(), c.getEndPart());
        if (this.currentTextOrientation.isHorizontal()) {
            this.currentView.setWidth(subView.getWidth() + longDim);
            this.currentView.setHeight(Math.max(subView.getHeight(), this.drawingSpecifications.getMaxCadratHeight()) + smallDim);
            subView.getPosition().setLocation(dLong, dSmall);
        } else {
            this.currentView.setHeight(subView.getHeight() + longDim);
            if (subView.getWidth() < this.drawingSpecifications.getMaxCadratWidth()) {
                this.currentView.setWidth(this.drawingSpecifications.getMaxCadratWidth() + smallDim);
            } else {
                this.currentView.setWidth(subView.getWidth() + smallDim);
            }
            float innerMargin = (this.currentView.getWidth() - subView.getWidth()) / 2.0f;
            subView.getPosition().setLocation(innerMargin, dLong);
        }
        if (this.currentTextOrientation.isHorizontal()) {
            this.currentView.setDeltaBaseY(-dSmall);
            this.currentView.setDeltaBaseX(0.0);
        } else {
            this.currentView.setDeltaBaseY(0.0);
            this.currentView.setDeltaBaseX(-dSmall);
        }
        this.centerSigns = this.drawingSpecifications.isSmallSignsCentered();
    }

    public void visitComplexLigature(ComplexLigature ligature) {
        HieroglyphsDrawer d = this.drawingSpecifications.getHieroglyphsDrawer();
        Rectangle2D zone1 = d.getLigatureArea(0, ligature.getHieroglyph().getCode());
        Rectangle2D zone3 = d.getLigatureArea(2, ligature.getHieroglyph().getCode());
        Rectangle2D zone2 = d.getLigatureArea(1, ligature.getHieroglyph().getCode());
        int index = 0;
        if (ligature.getBeforeGroup() != null) {
            MDCView beforeGroupView = this.currentView.getSubView(index);
            if (zone1 != null) {
                beforeGroupView.scaleToFitDimensions(zone1.getWidth(), zone1.getHeight());
                beforeGroupView.getPosition().setLocation(zone1.getMinX() + (zone1.getWidth() - (double)beforeGroupView.getWidth()), zone1.getMinY());
            }
            ++index;
        }
        ++index;
        if (ligature.getAfterGroup() != null) {
            MDCView afterGroupView = this.currentView.getSubView(index);
            if (zone3 != null) {
                afterGroupView.scaleToFitDimensions(zone3.getWidth(), zone3.getHeight());
                afterGroupView.getPosition().setLocation(zone3.getMinX() + (zone3.getWidth() - (double)afterGroupView.getWidth()) / 2.0, zone3.getMinY() + (zone3.getHeight() - (double)afterGroupView.getHeight()) / 3.0);
            } else if (zone2 != null) {
                afterGroupView.scaleToFitDimensions(zone2.getWidth(), zone2.getHeight());
                afterGroupView.getPosition().setLocation(zone2.getMinX(), zone2.getMinY());
            }
        }
        this.currentView.fitToSubViews(true);
    }

    public void visitDefault(ModelElement t) {
        if (this.currentView.getNumberOfSubviews() != 0) {
            if (this.drawingSpecifications.getTextOrientation().equals(TextOrientation.HORIZONTAL)) {
                float width = this.currentView.getSumOfSubViewsWidths();
                this.currentView.setWidth(width += this.drawingSpecifications.getSmallSkip() * (float)(this.currentView.getNumberOfSubviews() - 1));
                this.currentView.setHeight(this.currentView.getMaximalHeightOfSubView());
                this.currentView.distributeHorizontally();
            } else {
                float height = this.currentView.getSumOfSubViewsHeights();
                this.currentView.setWidth(this.currentView.getMaximalWidthOfSubView());
                this.currentView.setHeight(height += this.drawingSpecifications.getSmallSkip() * (float)(this.currentView.getNumberOfSubviews() - 1));
                this.currentView.distributeFromTopToBottom();
            }
        }
    }

    public void visitHBox(HBox b) {
        float w = this.currentView.getSumOfSubViewsWidths();
        float h = this.currentView.getMaximalHeightOfSubView();
        this.currentView.setHeight(h);
        this.currentView.setWidth(w += (float)(this.currentView.getNumberOfSubviews() - 1) * this.drawingSpecifications.getSmallSkip());
        ViewIterator iter = this.currentView.iterator();
        while (iter.hasNext()) {
            MDCView subView = iter.next();
            new ViewVerticalEnlarger().enlarge(subView, h);
        }
    }

    public void visitHieroglyph(Hieroglyph h) {
        switch (h.getType()) {
            case 2: 
            case 5: {
                this.currentView.setWidth(this.drawingSpecifications.getCadratWidth());
                this.currentView.setHeight(this.drawingSpecifications.getMaxCadratHeight());
                break;
            }
            case 1: 
            case 8: {
                this.currentView.setWidth(this.drawingSpecifications.getCadratWidth() / 2.0f);
                this.currentView.setHeight(this.drawingSpecifications.getMaxCadratHeight() / 2.0f);
                break;
            }
            case 6: {
                this.currentView.setWidth(this.drawingSpecifications.getCadratWidth() / 2.0f);
                this.currentView.setHeight(this.drawingSpecifications.getMaxCadratHeight());
                break;
            }
            case 7: {
                this.currentView.setWidth(this.drawingSpecifications.getCadratWidth());
                this.currentView.setHeight(this.drawingSpecifications.getMaxCadratHeight() / 2.0f);
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                HieroglyphsDrawer d = this.drawingSpecifications.getHieroglyphsDrawer();
                if (d.isKnown(h.getCode())) {
                    Rectangle2D s = d.getBBox(h.getCode());
                    this.currentView.setWidth((float)s.getWidth());
                    this.currentView.setHeight((float)s.getHeight());
                    if (h.getAngle() == 0) break;
                    Shape shape = this.drawingSpecifications.getHieroglyphsDrawer().getShape(h.getCode());
                    AffineTransform rot = AffineTransform.getRotateInstance((double)h.getAngle() * Math.PI / 180.0);
                    shape = rot.createTransformedShape(shape);
                    Rectangle2D r = shape.getBounds2D();
                    this.currentView.setHeight((float)r.getHeight());
                    this.currentView.setWidth((float)r.getWidth());
                    break;
                }
                Dimension2D r = this.drawingSpecifications.getSuperScriptDimensions(h.getCode());
                this.currentView.setHeight((float)r.getHeight());
                this.currentView.setWidth((float)r.getWidth());
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                String txt = LexicalSymbolsUtils.getStringForPhilology(h.getType());
                Rectangle2D r = this.drawingSpecifications.getTextDimensions('l', txt);
                this.currentView.setWidth((float)r.getWidth());
                this.currentView.setHeight((float)r.getHeight());
            }
        }
        if (h.getRelativeSize() != 100) {
            this.currentView.reScale((float)h.getRelativeSize() / 100.0f);
        }
    }

    public void visitHRule(HRule h) {
        this.currentView.setWidth(this.drawingSpecifications.getPageWidth());
        this.currentView.setHeight(this.drawingSpecifications.getWideLineWidth());
    }

    public void visitLigature(Ligature l) {
        String[] codes = new String[l.getNumberOfChildren()];
        for (int i = 0; i < codes.length; ++i) {
            codes[i] = l.getHieroglyphAt(i).getCode();
        }
        ExplicitPosition[] pos = LigatureManager.getInstance().getPositions(codes);
        if (pos != null) {
            for (int k = 0; k < pos.length; ++k) {
                MDCView subv = this.currentView.getSubView(k);
                float x = pos[k].getX() * this.drawingSpecifications.getBaseLength() / 1000.0f;
                float y = pos[k].getY() * this.drawingSpecifications.getBaseLength() / 1000.0f;
                subv.resetPos();
                subv.reScale(pos[k].getScale() / 100.0f);
                subv.getPosition().setLocation(x, y);
            }
        } else if (l.getNumberOfChildren() == 2) {
            Rectangle2D rect;
            int larger = 0;
            int smaller = 1;
            int ligPos = 2;
            if (this.currentView.getSubView(1).getHeight() > this.currentView.getSubView(0).getHeight()) {
                larger = 1;
                smaller = 0;
                ligPos = 0;
            }
            if (ligPos == 2 && this.drawingSpecifications.getHieroglyphsDrawer().getLigatureArea(ligPos, l.getHieroglyphAt(larger).getCode()) == null) {
                ligPos = 1;
            }
            if ((rect = this.drawingSpecifications.getHieroglyphsDrawer().getLigatureArea(ligPos, l.getHieroglyphAt(larger).getCode())) != null) {
                this.currentView.getSubView(larger).resetPos();
                this.currentView.getSubView(smaller).scaleToFitDimensions(rect.getWidth(), rect.getHeight());
                this.currentView.getSubView((int)smaller).getPosition().y = rect.getMinY();
                this.currentView.getSubView((int)smaller).getPosition().x = smaller == 0 ? rect.getMinX() : rect.getMaxX() - (double)this.currentView.getSubView(smaller).getWidth();
                this.currentView.fitToSubViews(true);
            }
        } else if (l.getNumberOfChildren() == 3) {
            String code = l.getHieroglyphAt(1).getCode();
            Rectangle2D r1 = this.drawingSpecifications.getHieroglyphsDrawer().getLigatureArea(0, code);
            Rectangle2D r2 = this.drawingSpecifications.getHieroglyphsDrawer().getLigatureArea(1, code);
            if (r1 != null && r2 != null) {
                this.currentView.getSubView(1).resetPos();
                this.currentView.getSubView(0).scaleToFitDimensions(r1.getWidth(), r1.getHeight());
                this.currentView.getSubView(2).scaleToFitDimensions(r2.getWidth(), r2.getHeight());
                this.currentView.getSubView((int)0).getPosition().y = r1.getMinY();
                this.currentView.getSubView((int)2).getPosition().y = r2.getMinY();
                this.currentView.getSubView((int)0).getPosition().x = r1.getMinX();
                this.currentView.getSubView((int)2).getPosition().x = r2.getMaxX() - (double)this.currentView.getSubView(2).getWidth();
            }
        }
        this.currentView.fitToSubViews(true);
    }

    public void visitLineBreak(LineBreak b) {
        this.currentView.setWidth(0.1f);
        this.currentView.setHeight(this.drawingSpecifications.getMaxCadratHeight());
    }

    public void visitModifier(Modifier mod) {
        super.visitModifier(mod);
    }

    public void visitModifierList(ModifiersList l) {
        super.visitModifierList(l);
    }

    public void visitOverwrite(Overwrite o) {
        double wmax = Math.max(this.currentView.getSubView(0).getWidth(), this.currentView.getSubView(1).getWidth());
        double hmax = Math.max(this.currentView.getSubView(0).getHeight(), this.currentView.getSubView(1).getHeight());
        this.currentView.setWidth((float)wmax);
        this.currentView.setHeight((float)hmax);
        this.currentView.centerSubViewHorizontally();
        this.currentView.centerSubViewsVertically();
    }

    public void visitPageBreak(PageBreak b) {
    }

    public void visitPhilology(Philology p) {
        MDCView subView = this.currentView.getFirstSubView();
        float margin = this.drawingSpecifications.getPhilologyWidth(p.getType()) + this.drawingSpecifications.getSmallSkip();
        this.currentView.getFirstSubView().getPosition().setLocation(margin, 0.0);
        this.currentView.setWidth(margin * 2.0f + subView.getWidth());
        this.currentView.setHeight(subView.getHeight());
    }

    public void visitSubCadrat(SubCadrat c) {
        this.currentView.setWidth(this.currentView.getSumOfSubViewsWidths());
        this.currentView.setHeight(this.currentView.getMaximalHeightOfSubView());
        this.currentView.distributeHorizontally();
    }

    public void visitSuperScript(Superscript s) {
        Dimension2D dims = this.drawingSpecifications.getSuperScriptDimensions(s.getText());
        this.currentView.setWidth((float)dims.getWidth());
        this.currentView.setHeight((float)Math.max((double)this.drawingSpecifications.getMaxCadratHeight(), dims.getHeight() + (double)(this.drawingSpecifications.getSmallSkip() * 2.0f)));
    }

    public void visitTabStop(TabStop t) {
    }

    public void visitTopItemList(TopItemList t) {
        this.compositeVisitTopItemList(t);
    }

    public void compositeVisitTopItemList(TopItemList t) {
        TopItemLayout topItemLayout = null;
        topItemLayout = this.currentTextOrientation.equals(TextOrientation.HORIZONTAL) ? new LineLayout(this.currentView, this.drawingSpecifications) : new ColumnLayout(this.currentView, this.drawingSpecifications);
        ViewIterator i = this.currentView.iterator();
        topItemLayout.startLayout();
        while (i.hasNext()) {
            MDCView v = i.next();
            v.resetPos();
            topItemLayout.layoutElement(v);
        }
        topItemLayout.endLayout();
        this.currentView.setWidth((float)topItemLayout.getDocumentArea().getWidth());
        this.currentView.setHeight((float)topItemLayout.getDocumentArea().getHeight());
    }

    class ViewVerticalEnlarger
    extends ModelElementAdapter {
        float height;
        MDCView view;

        ViewVerticalEnlarger() {
        }

        public void enlarge(MDCView subView, float h) {
            this.height = h;
            this.view = subView;
            subView.getModel().accept(this);
        }

        public void visitSubCadrat(SubCadrat c) {
            MDCView basicElementsListView = this.view.getFirstSubView();
            boolean changed = false;
            for (int i = 0; i < basicElementsListView.getNumberOfSubviews(); ++i) {
                MDCView elementView = basicElementsListView.getSubView(i);
                if (!elementView.isYStretchable()) continue;
                elementView.setHeight(this.height);
                elementView.distributeFromTopToBottom();
                changed = true;
            }
            if (changed) {
                basicElementsListView.fitToSubViews(false);
                this.view.fitToSubViews(false);
            }
        }
    }
}

