/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.swing.editor;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Observable;
import jsesh.mdc.MDCParserModelGenerator;
import jsesh.mdc.model.ModelElementObserver;
import jsesh.mdc.model.TopItemList;
import jsesh.mdc.model.operations.ModelOperation;
import jsesh.mdc.utils.MDCSyntaxError;

public class HieroglyphicTextModel
extends Observable
implements ModelElementObserver {
    private TopItemList model;
    private boolean philologyIsSign;
    private boolean debug;

    public HieroglyphicTextModel() {
        this.setModel(new TopItemList());
        this.philologyIsSign = false;
        this.debug = false;
    }

    public TopItemList getModel() {
        return this.model;
    }

    public void setModel(TopItemList model) {
        if (this.model != null) {
            this.model.deleteObserver(this);
        }
        this.model = model;
        if (model != null) {
            model.addObserver(this);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void clear() {
        this.setModel(new TopItemList());
    }

    public void readModel(Reader in) throws MDCSyntaxError {
        TopItemList l = this.createGenerator().parse(in);
        this.setModel(l);
    }

    public void setMDCCode(String text) throws MDCSyntaxError {
        StringReader r = new StringReader(text);
        this.readModel(r);
    }

    private MDCParserModelGenerator createGenerator() {
        MDCParserModelGenerator generator = new MDCParserModelGenerator();
        generator.setPhilologyAsSigns(this.philologyIsSign);
        generator.setDebug(this.debug);
        return generator;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isPhilologyIsSign() {
        return this.philologyIsSign;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setPhilologyIsSign(boolean philologyIsSign) {
        this.philologyIsSign = philologyIsSign;
    }

    public void observedElementChanged(ModelOperation operation) {
        this.setChanged();
        this.notifyObservers(operation);
    }

    public List buildItems(String text) throws MDCSyntaxError {
        MDCParserModelGenerator generator = this.createGenerator();
        StringReader r = new StringReader(text);
        TopItemList t = generator.parse(r);
        return t.removeTopItems(0, t.getNumberOfChildren());
    }

    public void insertMDCText(int index, String mdcText) throws MDCSyntaxError {
        List items = this.buildItems(mdcText);
        this.getModel().addAllAt(index, items);
    }
}

