/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.swing.editor;

import java.util.Iterator;
import jsesh.mdc.model.ModelElement;
import jsesh.mdc.model.TopItem;
import jsesh.mdc.model.operations.ChildOperation;
import jsesh.mdc.model.operations.Deletion;
import jsesh.mdc.model.operations.Insertion;
import jsesh.mdc.model.operations.ModelOperationVisitor;
import jsesh.mdc.model.operations.Modification;
import jsesh.mdc.model.operations.Replacement;
import jsesh.mdc.model.operations.ZoneModification;
import jsesh.mdcDisplayer.mdcView.MDCView;
import jsesh.mdcDisplayer.swing.editor.JMDCEditor;

class MDCViewUpdater
implements ModelOperationVisitor {
    private final JMDCEditor editor;

    MDCViewUpdater(JMDCEditor editor) {
        this.editor = editor;
    }

    public void visitChildOperation(ChildOperation operation) {
        int k;
        for (k = 0; k < this.editor.mdcView.getNumberOfSubviews() && this.editor.mdcView.getSubView(k).getModel() != operation.getChildOperation().getElement(); ++k) {
        }
        if (this.editor.mdcView.getSubView(k).getModel() == operation.getChildOperation().getElement()) {
            MDCView subv = this.editor.builder.buildView(operation.getChildOperation().getElement(), this.editor.getDrawingSpecifications());
            this.editor.mdcView.replaceSubView(k, subv);
        }
        this.editor.builder.reLayout(this.editor.mdcView, this.editor.getDrawingSpecifications());
    }

    public void visitDeletion(Deletion deletion) {
        this.editor.mdcView.remove(deletion.getStart(), deletion.getEnd());
        this.editor.builder.reLayout(this.editor.mdcView, this.editor.getDrawingSpecifications());
    }

    public void visitInsertion(Insertion insertion) {
        int index = insertion.getIndex();
        Iterator i = insertion.getChildren().iterator();
        while (i.hasNext()) {
            MDCView subView = this.editor.builder.buildView((ModelElement)i.next(), this.editor.getDrawingSpecifications());
            this.editor.mdcView.addAt(index++, subView);
        }
        this.editor.builder.reLayout(this.editor.mdcView, this.editor.getDrawingSpecifications());
    }

    public void visitModification(Modification modification) {
        this.editor.mdcView = null;
    }

    public void visitReplacement(Replacement replacement) {
        this.editor.mdcView = null;
    }

    public void visitZoneModification(ZoneModification modification) {
        for (int i = modification.getStart(); i < modification.getEnd(); ++i) {
            TopItem it = this.editor.getHieroglyphicTextModel().getModel().getTopItemAt(i);
            MDCView v = this.editor.builder.buildView(it, this.editor.getDrawingSpecifications());
            this.editor.mdcView.replaceSubView(i, v);
        }
        this.editor.builder.reLayout(this.editor.mdcView, this.editor.getDrawingSpecifications());
    }
}

