/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.swing.preferencesEditor;

import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import jsesh.mdcDisplayer.swing.preferencesEditor.FontChooserPresenter;
import jsesh.mdcDisplayer.swing.preferencesEditor.FormPresenter;
import jsesh.mdcDisplayer.swing.preferencesEditor.PreferencesFacade;
import jsesh.mdcDisplayer.swing.preferencesEditor.RTFPreferencesPresenter;

public class PreferencesEditor {
    private Component parent;
    private FormPresenter[] formPresenters;
    private JTabbedPane panel;

    public PreferencesEditor(Component parent, PreferencesFacade facade) {
        this.parent = parent;
        this.panel = new JTabbedPane();
        this.formPresenters = new FormPresenter[]{new FontChooserPresenter("Fonts selection"), new RTFPreferencesPresenter("Export Preferences (large size)", facade.getRTFPreference(0)), new RTFPreferencesPresenter("Export Preferences (small size)", facade.getRTFPreference(1))};
        for (int i = 0; i < this.formPresenters.length; ++i) {
            FormPresenter p = this.formPresenters[i];
            this.panel.addTab(p.getTitle(), p.getPanel());
        }
    }

    public JTabbedPane getPanel() {
        return this.panel;
    }

    public void initializePreferences(PreferencesFacade facade) {
        for (int i = 0; i < this.formPresenters.length; ++i) {
            this.formPresenters[i].loadPreferences(facade);
        }
    }

    public int askForPreferences() {
        int option = JOptionPane.showConfirmDialog(this.parent, this.getPanel(), "Edit preferences", 2, -1);
        return option;
    }

    public void updatePreferences(PreferencesFacade facade) {
        for (int i = 0; i < this.formPresenters.length; ++i) {
            this.formPresenters[i].updatePreferences(facade);
        }
    }
}

