/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.swing.preferencesEditor;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import jsesh.graphicExport.RTFExportPreferences;
import jsesh.mdcDisplayer.swing.preferencesEditor.FormPresenter;
import jsesh.mdcDisplayer.swing.preferencesEditor.PreferencesFacade;
import jsesh.mdcDisplayer.swing.preferencesEditor.RTFPreferencesForm;
import jsesh.mdcDisplayer.swing.units.LengthUnit;
import jsesh.mdcDisplayer.swing.units.UnitMaintainter;

public class RTFPreferencesPresenter
extends FormPresenter {
    private RTFPreferencesForm form = new RTFPreferencesForm();
    private LengthUnit currentUnit;
    private RTFExportPreferences preferences;

    public RTFPreferencesPresenter(String title, RTFExportPreferences preferences) {
        super(title);
        this.preferences = preferences;
        this.currentUnit = LengthUnit.POINT;
        this.form.exportModeField.setModel(new DefaultComboBoxModel<RTFExportPreferences.RTFExportGranularity>(RTFExportPreferences.exportModes));
        LengthUnit.attachToCombobox(this.form.unitField, LengthUnit.POINT);
        this.form.cadratHeightField.setValue(new Double(preferences.getCadratHeight()));
        this.form.exportModeField.setSelectedItem(RTFExportPreferences.RTFExportGranularity.ONE_PICTURE_PER_CADRAT);
        this.form.exportModeField.setModel(new DefaultComboBoxModel<RTFExportPreferences.RTFExportGranularity>(RTFExportPreferences.RTFExportGranularity.GRANULARITIES));
        UnitMaintainter.linkUnitsToValueField(this.form.unitField, this.form.cadratHeightField);
    }

    public JComponent getPanel() {
        return this.form;
    }

    public void updatePreferences(PreferencesFacade facade) {
        this.preferences.setCadratHeight(this.getCadratHeightInPoints());
        this.preferences.setExportGranularity(this.getExportGranularity());
    }

    public void loadPreferences(PreferencesFacade facade) {
        this.form.unitField.setSelectedItem(facade.getPreferedUnit());
        this.form.exportModeField.setSelectedItem(this.preferences.getExportGranularity());
        double heightInPoints = this.preferences.getCadratHeight();
        this.setCadratHeightInPoints(heightInPoints);
    }

    private int getCadratHeightInPoints() {
        int pointValue = (int)(((Number)this.form.cadratHeightField.getValue()).doubleValue() * this.currentUnit.getPointsValue());
        return pointValue;
    }

    private void setCadratHeightInPoints(double heightInPoints) {
        this.form.cadratHeightField.setValue(new Double(heightInPoints / this.currentUnit.getPointsValue()));
    }

    private void unitChanged() {
        double height = this.getCadratHeightInPoints();
        this.currentUnit = (LengthUnit)this.form.unitField.getSelectedItem();
        this.setCadratHeightInPoints(height);
    }

    private RTFExportPreferences.RTFExportGranularity getExportGranularity() {
        RTFExportPreferences.RTFExportGranularity result = (RTFExportPreferences.RTFExportGranularity)this.form.exportModeField.getSelectedItem();
        if (result == null) {
            result = RTFExportPreferences.RTFExportGranularity.ONE_PICTURE_PER_CADRAT;
        }
        return result;
    }

    private class UnitMaintainterOLD
    implements ItemListener {
        private UnitMaintainterOLD() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1 && e.getItem() != null) {
                RTFPreferencesPresenter.this.unitChanged();
            }
        }
    }
}

