/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.swing.units;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import jsesh.mdcDisplayer.swing.units.LengthUnit;

public class UnitMaintainter
implements ItemListener {
    private LengthUnit currentUnit;
    private JComboBox unitField;
    private JFormattedTextField lengthField;

    public static void linkUnitsToValueField(JComboBox unitField, JFormattedTextField lengthField) {
        unitField.addItemListener(new UnitMaintainter(unitField, lengthField));
    }

    private UnitMaintainter(JComboBox unitField, JFormattedTextField lengthField) {
        this.currentUnit = (LengthUnit)unitField.getSelectedItem();
        this.unitField = unitField;
        this.lengthField = lengthField;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1 && e.getItem() != null) {
            double height = this.getCadratHeightInPoints();
            this.currentUnit = (LengthUnit)this.unitField.getSelectedItem();
            this.setCadratHeightInPoints(height);
        }
    }

    private void setCadratHeightInPoints(double length) {
        this.lengthField.setValue(new Double(length / this.currentUnit.getPointsValue()));
    }

    private double getCadratHeightInPoints() {
        int pointValue = (int)(((Number)this.lengthField.getValue()).doubleValue() * this.currentUnit.getPointsValue());
        return pointValue;
    }
}

