/*
 * Decompiled with CFR 0.152.
 */
package jsesh.softwares;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jsesh.bzr.simple.ShapeChar;
import jsesh.externalFonts.model.SVGSignSource;
import jsesh.hieroglyphs.HieroglyphicBitmapBuilder;
import jsesh.utils.FileUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class MakeSVGIndex {
    static final String USAGE = "usage : \njava jsesh.softwares.MakeSVGIndex DIRECTORY \nbuild an index.html with png pictures of the svg files in a directory.\nalso create a zipped version of the directory.\nif a file README.html is available, it will be inserted at the beginning of the file.\nThe README.html file should not contain <html> or <body> tags\n\tfor each sign, if a .txt file with the same name of the sign is found, it's used as a commentary.\nThe software can also use the 'description' field of SVG files (see inkscape, document preferences)";
    private static final String XSLFILTER = "<xsl:stylesheet version=\"1.0\"  xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"  xmlns:dc='http://purl.org/dc/elements/1.1/' ><xsl:output method='text'/><xsl:template match='text()|@*'></xsl:template><xsl:template match='//dc:description'><xsl:value-of select='.'/></xsl:template></xsl:stylesheet>";

    public static void main(String[] args) throws IOException {
        int i;
        if (args.length == 0) {
            MakeSVGIndex.displayUsage();
        }
        File[] directories = new File[args.length];
        for (i = 0; i < args.length; ++i) {
            directories[i] = new File(args[i]);
            if (directories[i].isDirectory()) continue;
            System.err.println(directories[i].getName() + " is not a directory");
            MakeSVGIndex.displayUsage();
        }
        for (i = 0; i < args.length; ++i) {
            System.out.println("working on " + directories[i].getName());
            MakeSVGIndex.makeIndex(directories[i]);
        }
    }

    private static void makeIndex(File directory) throws IOException {
        StringBuffer buffer = new StringBuffer();
        MakeSVGIndex.makeHeader(buffer);
        MakeSVGIndex.makeReadme(directory, buffer);
        MakeSVGIndex.makeBody(directory, buffer);
        MakeSVGIndex.makeFooter(buffer);
        FileWriter index = new FileWriter(new File(directory, "index.html"));
        index.write(buffer.toString());
        index.close();
    }

    private static void makeFooter(StringBuffer buffer) {
        buffer.append("</body>\n");
        buffer.append("</html>\n");
    }

    private static void makeHeader(StringBuffer buffer) {
        buffer.append("<html>\n");
        buffer.append("<head>");
        buffer.append("<title>");
        buffer.append("SVG hieroglyphs");
        buffer.append("</title>");
        buffer.append("</head>");
        buffer.append("<body>\n");
    }

    private static void makeBody(File directory, StringBuffer buffer) throws IOException {
        Object[] files = directory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().toLowerCase().endsWith(".svg");
            }
        });
        ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(new File(directory, "svgsigns.zip")));
        Arrays.sort(files);
        buffer.append("<ul>\n");
        for (int i = 0; i < files.length; ++i) {
            buffer.append("<li>");
            buffer.append(((File)files[i]).getName());
            buffer.append("<a href=\"");
            buffer.append(((File)files[i]).getName());
            buffer.append("\"> ");
            buffer.append("<img src=\"");
            File imageFile = FileUtils.buildFileWithExtension((File)files[i], "png");
            buffer.append(imageFile.getName());
            MakeSVGIndex.buildImageFile((File)files[i], imageFile);
            File commentFile = FileUtils.buildFileWithExtension((File)files[i], "txt");
            buffer.append("\"> ");
            buffer.append("</a>\n");
            buffer.append(MakeSVGIndex.extractXMLInfo((File)files[i]));
            if (commentFile.exists()) {
                int c;
                FileReader commentReader = new FileReader(commentFile);
                while ((c = ((Reader)commentReader).read()) != -1) {
                    buffer.append((char)c);
                }
                ((Reader)commentReader).close();
            }
            ZipEntry entry = new ZipEntry("svgsigns/" + ((File)files[i]).getName());
            zipOut.putNextEntry(entry);
            FileInputStream svgin = new FileInputStream((File)files[i]);
            byte[] bytes = new byte[(int)((File)files[i]).length()];
            svgin.read(bytes);
            svgin.close();
            zipOut.write(bytes);
            zipOut.closeEntry();
        }
        buffer.append("</ul>\n");
        zipOut.close();
        buffer.append("<b> directory content as <a href=\"svgsigns.zip\"> zip file </a>");
    }

    private static String extractXMLInfo(File file) {
        String result = "";
        TransformerFactory factory2 = TransformerFactory.newInstance();
        StreamSource source = new StreamSource(new StringReader(XSLFILTER));
        try {
            Transformer f = factory2.newTransformer(source);
            StringWriter stringWriter = new StringWriter();
            StreamResult outputTarget = new StreamResult(stringWriter);
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
                }
            });
            SAXSource source1 = new SAXSource(xmlReader, new InputSource(new FileInputStream(file)));
            f.transform(source1, outputTarget);
            result = stringWriter.toString().trim();
        }
        catch (TransformerConfigurationException exception) {
            exception.printStackTrace();
        }
        catch (TransformerException exception) {
            exception.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static void buildImageFile(File svgFile, File imageFile) throws IOException {
        SVGSignSource source = new SVGSignSource(svgFile);
        if (source.hasNext()) {
            source.next();
            ShapeChar shapeChar = source.getCurrentShape();
            HieroglyphicBitmapBuilder builder = new HieroglyphicBitmapBuilder();
            builder.setSize(56);
            builder.setMaxSize(20.0);
            builder.setFit(true);
            builder.setTransparent(true);
            BufferedImage b = builder.buildSignBitmap(shapeChar);
            ImageIO.write((RenderedImage)b, "png", imageFile);
        }
    }

    private static void makeReadme(File directory, StringBuffer buffer) throws FileNotFoundException, IOException {
        File readme = new File(directory, "README.html");
        if (readme.exists()) {
            int c;
            FileReader in = new FileReader(readme);
            while ((c = ((Reader)in).read()) != -1) {
                buffer.append((char)c);
            }
            ((Reader)in).close();
        }
    }

    private static void displayUsage() {
        System.err.println(USAGE);
        System.exit(1);
    }
}

