/*
 * Decompiled with CFR 0.152.
 */
package jsesh.swingUtils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class FileButtonMapper
implements ActionListener {
    public static final int OPEN = 1;
    public static final int SAVE = 2;
    private JButton button;
    private JFormattedTextField fileField;
    private int mode;
    private int fileSelectionMode;
    private List fileFilters;
    private String dialogTitle;
    private String approveButtonLabel;

    public FileButtonMapper(JButton button, JFormattedTextField field) {
        this.button = button;
        this.fileField = field;
        button.addActionListener(this);
        this.mode = 2;
        this.fileSelectionMode = 0;
        this.fileFilters = null;
        this.dialogTitle = null;
        this.approveButtonLabel = null;
    }

    public void askForCreation() {
        this.fileField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("value".equals(evt.getPropertyName())) {
                    int result;
                    File f = (File)FileButtonMapper.this.fileField.getValue();
                    if (f == null) {
                        return;
                    }
                    if (!f.exists() && (result = JOptionPane.showConfirmDialog(FileButtonMapper.this.button, "The directory " + f.getAbsolutePath() + " does not exist. Should I Create it ?", "Directory does not exist", 0)) == 0) {
                        f.mkdirs();
                    }
                }
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        int result;
        File f;
        try {
            f = (File)this.fileField.getValue();
        }
        catch (ClassCastException exc) {
            f = new File(this.fileField.getText());
        }
        JFileChooser chooser = new JFileChooser(f){};
        chooser.setFileSelectionMode(this.fileSelectionMode);
        if (this.getDialogTitle() != null) {
            chooser.setDialogTitle(this.getDialogTitle());
        }
        if (this.getApproveButtonLabel() != null) {
            chooser.setApproveButtonText(this.getApproveButtonLabel());
        }
        if (this.fileFilters != null) {
            for (int i = 0; i < this.fileFilters.size(); ++i) {
                chooser.addChoosableFileFilter((FileFilter)this.fileFilters.get(i));
            }
        }
        if ((result = this.mode == 1 ? chooser.showOpenDialog(this.button) : chooser.showSaveDialog(this.button)) == 0) {
            this.fileField.setValue(chooser.getSelectedFile());
        }
    }

    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    public void setFileSelectionMode(int fileSelectionMode) {
        this.fileSelectionMode = fileSelectionMode;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void addFileFilter(FileFilter filter) {
        if (this.fileFilters == null) {
            this.fileFilters = new ArrayList();
        }
        this.fileFilters.add(filter);
    }

    public String getApproveButtonLabel() {
        return this.approveButtonLabel;
    }

    public void setApproveButtonLabel(String okLabel) {
        this.approveButtonLabel = okLabel;
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public void setDialogTitle(String title) {
        this.dialogTitle = title;
    }
}

