/*
 * Decompiled with CFR 0.152.
 */
package jsesh.tmp.simpleDemo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import jsesh.hieroglyphs.DefaultHieroglyphicFontManager;
import jsesh.swingUtils.GraphicsUtils;
import jsesh.tmp.simpleDemo.HieroglyphicDrawer;
import jsesh.tmp.simpleDemo.HieroglyphicText;

public class DemoMDCDisplayer
extends JPanel {
    private HieroglyphicText text;
    private HieroglyphicDrawer drawer;
    private double scale = 2.0;

    public DemoMDCDisplayer() {
        this.setSize(this.getPreferredSize());
        this.setBackground(Color.white);
        DefaultHieroglyphicFontManager manager = DefaultHieroglyphicFontManager.getInstance();
        this.drawer = new HieroglyphicDrawer(manager);
        this.setDoubleBuffered(true);
    }

    public Dimension getPreferredSize() {
        if (this.text == null) {
            return new Dimension(6000, 600);
        }
        int textHeight = (int)(this.drawer.getTextHeight(this.text) * this.scale);
        return new Dimension(6000, textHeight);
    }

    public HieroglyphicText getText() {
        return this.text;
    }

    public void setText(HieroglyphicText v) {
        this.text = v;
        this.revalidate();
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        GraphicsUtils.antialias(g);
        g2d.scale(this.scale, this.scale);
        this.drawer.draw(g2d, this.text);
    }
}

