/*
 * Decompiled with CFR 0.152.
 */
package jsesh.tmp.simpleDemo;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import jsesh.bzr.simple.ShapeChar;
import jsesh.hieroglyphs.HieroglyphicFontManager;
import jsesh.swingUtils.GraphicsUtils;
import jsesh.tmp.simpleDemo.HieroglyphicText;

public class HieroglyphicDrawer {
    private double scale;
    public double lineHeight = 18.0;
    public double lineSkip = 5.0;
    public double minSpace = 1.0;
    private double xPos;
    private double yPos;
    Graphics2D g;
    HieroglyphicText t;
    HieroglyphicFontManager paleography;

    public HieroglyphicDrawer(HieroglyphicFontManager paleography) {
        this.paleography = paleography;
        this.scale = 1.0;
    }

    public void draw(Graphics2D g, HieroglyphicText t) {
        this.g = g;
        this.t = t;
        if (g != null && t != null) {
            GraphicsUtils.antialias(g);
            g.scale(this.scale, this.scale);
            this.draw();
        }
    }

    private void drawCadrat(List cadrat) {
        double width = 0.0;
        double height = 0.0;
        double verticalSpace = 0.0;
        if (cadrat.size() > 1) {
            verticalSpace = (double)cadrat.size() * this.minSpace;
        }
        double[] linesWidths = new double[cadrat.size()];
        double[] linesHeigths = new double[cadrat.size()];
        Iterator hboxIterator = cadrat.iterator();
        int lineNum = 0;
        while (hboxIterator.hasNext()) {
            List signList = (List)hboxIterator.next();
            double cadratLineHeight = 0.0;
            double cadratLineWidth = 0.0;
            double horizontalSpacing = 0.0;
            if (signList.size() > 1) {
                horizontalSpacing = this.minSpace * (double)(signList.size() - 1);
            }
            Iterator signIterator = signList.iterator();
            while (signIterator.hasNext()) {
                String code = (String)signIterator.next();
                ShapeChar mychar = this.paleography.get(code);
                if (mychar == null) continue;
                Rectangle2D bbox = mychar.getBbox();
                cadratLineWidth += bbox.getMaxX();
                if (!(bbox.getMaxY() > cadratLineHeight)) continue;
                cadratLineHeight = bbox.getMaxY();
            }
            height += cadratLineHeight;
            linesWidths[lineNum] = cadratLineWidth;
            linesHeigths[lineNum++] = cadratLineHeight;
            if (!(cadratLineWidth + horizontalSpacing > width)) continue;
            width = cadratLineWidth + horizontalSpacing;
        }
        double goodScale = this.lineHeight / (height + verticalSpace);
        if (goodScale > 1.0) {
            goodScale = 1.0;
        }
        double vspace = this.minSpace * goodScale;
        double x = this.xPos;
        double y = this.yPos;
        if (height * goodScale < this.lineHeight) {
            if (cadrat.size() == 1) {
                y += this.lineHeight - height * goodScale;
            } else {
                vspace = (this.lineHeight - height * goodScale) / (double)(cadrat.size() - 1);
            }
        }
        hboxIterator = cadrat.iterator();
        lineNum = 0;
        while (hboxIterator.hasNext()) {
            List signList = (List)hboxIterator.next();
            double thisLineHeight = linesHeigths[lineNum] * goodScale;
            double thisLineWidth = linesWidths[lineNum++] * goodScale;
            double hspace = this.minSpace * goodScale;
            x = this.xPos;
            if (thisLineWidth < width * goodScale) {
                if (signList.size() == 1) {
                    hspace = 0.0;
                    x += (width * goodScale - thisLineWidth) / 2.0;
                } else {
                    hspace = (width * goodScale - thisLineWidth) / (double)(signList.size() - 1);
                }
            }
            Iterator signIterator = signList.iterator();
            while (signIterator.hasNext()) {
                String code = (String)signIterator.next();
                ShapeChar mychar = this.paleography.get(code);
                if (mychar == null) continue;
                Rectangle2D bbox = mychar.getBbox();
                if (this.g != null) {
                    mychar.draw(this.g, x, y + (thisLineHeight - bbox.getMaxY() * goodScale), goodScale, goodScale, 0.0f);
                }
                x += bbox.getMaxX() * goodScale + hspace;
            }
            y += thisLineHeight + vspace;
        }
        this.xPos = this.xPos + width * goodScale + this.minSpace;
    }

    private void draw() {
        double yMax;
        double yMin;
        Rectangle r = this.g.getClipBounds();
        if (r != null) {
            yMin = r.getMinY() - (this.lineHeight + this.lineSkip);
            yMax = r.getMaxY() + this.lineHeight + this.lineSkip;
        } else {
            yMin = 0.0;
            yMax = this.getTextHeight(this.t);
        }
        this.xPos = 0.0;
        this.yPos = 0.0;
        Iterator lineIterator = this.t.lines.iterator();
        while (lineIterator.hasNext()) {
            Iterator cadratIterator = ((List)lineIterator.next()).iterator();
            if (this.yPos >= yMin && this.yPos <= yMax) {
                while (cadratIterator.hasNext()) {
                    List cadrat = (List)cadratIterator.next();
                    this.drawCadrat(cadrat);
                }
            }
            this.yPos = this.yPos + this.lineHeight + this.lineSkip;
            this.xPos = 0.0;
        }
    }

    public double getTextWidth(HieroglyphicText t) {
        double result = 0.0;
        this.t = t;
        this.xPos = 0.0;
        this.yPos = 0.0;
        this.g = null;
        Iterator lineIterator = t.lines.iterator();
        while (lineIterator.hasNext()) {
            Iterator cadratIterator = ((List)lineIterator.next()).iterator();
            while (cadratIterator.hasNext()) {
                List cadrat = (List)cadratIterator.next();
                this.drawCadrat(cadrat);
            }
            if (this.xPos > result) {
                result = this.xPos;
            }
            this.xPos = 0.0;
        }
        return result * this.scale;
    }

    public double getTextHeight(HieroglyphicText t) {
        double res = t.lines.size() > 1 ? (double)t.lines.size() * (this.lineHeight + this.lineSkip) : this.lineHeight;
        return res * this.scale;
    }

    public void setSigneHeight(int h) {
        this.scale = (double)h / 18.0;
    }
}

