/*
 * Decompiled with CFR 0.152.
 */
package jsesh.utils;

import java.awt.geom.Point2D;

public class Bezier {
    public Point2D.Double[] controls = new Point2D.Double[4];
    static final int MAXPTS = 8;
    private String s;

    public Bezier() {
        for (int i = 0; i < 4; ++i) {
            this.controls[i] = new Point2D.Double(0.0, 0.0);
        }
    }

    public Bezier(double p1x, double p1y, double c1x, double c1y, double c2x, double c2y, double p2x, double p2y) {
        this.controls[0] = new Point2D.Double(p1x, p1y);
        this.controls[1] = new Point2D.Double(c1x, c1y);
        this.controls[2] = new Point2D.Double(c2x, c2y);
        this.controls[3] = new Point2D.Double(p2x, p2y);
    }

    public double getControlX(int i) {
        return this.controls[i].getX();
    }

    public double getControlY(int i) {
        return this.controls[i].getY();
    }

    public void setControl(int i, double x, double y) {
        this.controls[i].setLocation(x, y);
    }

    public double getArea() {
        return Bezier.area(this.getControlX(0), this.getControlY(0), this.getControlX(1), this.getControlY(1), this.getControlX(2), this.getControlY(2), this.getControlX(3), this.getControlY(3));
    }

    public static double area(double p1x, double p1y, double c1x, double c1y, double c2x, double c2y, double p2x, double p2y) {
        double result = 0.0;
        double ux = -p1x + 3.0 * c1x - 3.0 * c2x + p2x;
        double vx = 3.0 * c2x + 3.0 * p1x - 6.0 * c1x;
        double wx = 3.0 * c1x - 3.0 * p1x;
        double zx = p1x;
        double uy = -p1y + 3.0 * c1y - 3.0 * c2y + p2y;
        double vy = 3.0 * c2y + 3.0 * p1y - 6.0 * c1y;
        double wy = 3.0 * c1y - 3.0 * p1y;
        double zy = p1y;
        for (double t = 0.0; t < 1.0; t += 0.125) {
            double x = ((ux * t + vx) * t + wx) * t + zx;
            double y = ((uy * t + vy) * t + wy) * t + zy;
            result += (x - p1x) * (y + p1y);
            p1x = x;
            p1y = y;
        }
        p1x = p2x;
        p1y = p2y;
        return result;
    }
}

