/*
 * Decompiled with CFR 0.152.
 */
package openglyph.dictionary;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Reader;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jsesh.mdcDisplayer.swing.application.MDCIconAction;
import jsesh.mdcDisplayer.swing.editor.HieroglyphicTextModel;
import jsesh.mdcDisplayer.swing.editor.JMDCEditor;
import jsesh.mdcDisplayer.swing.hieroglyphicMenu.HieroglyphicMenu;
import jsesh.mdcDisplayer.swing.hieroglyphicMenu.HieroglyphicMenuListener;
import openglyph.dictionary.DictionaryDataBase;
import openglyph.splash.SplashScreen;

public class AncientTextPanel
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 275968290539679276L;
    private ResourceBundle _captions = null;
    private Locale _local = null;
    private JMenu _dictionary;
    private JMenu hieroglyphs;
    private JMenu _idiomas;
    private boolean _buscoTransliteracion = true;
    private boolean _buscoGardiner = false;
    private boolean _buscoEnglish = false;
    private boolean _buscoBegin = true;
    private boolean _buscoEvery = false;
    private boolean _buscoEnd = false;
    private boolean _buscoExacto = false;
    JRadioButton _rTranslit = null;
    JRadioButton _rGardiner = null;
    JRadioButton _rEnglish = null;
    JRadioButton _rInicio = null;
    JRadioButton _rMedio = null;
    JRadioButton _rFinal = null;
    JRadioButton _rExacto = null;
    private OptionPanel _panEd = null;
    private JPanel _panOptions = null;
    private JTextField _cajaTranslit;
    private JLabel _numRegistros = new JLabel();
    private JPanel _statePan;
    private JButton _botonTransliteracion;
    private JMenuItem _menuSpanish = null;
    private JMenuItem _menuEnglish = null;
    private DictionaryDataBase _myDB = null;
    private DictionaryAction[] dictionaryActions;
    private ArrayList _resultadosDiccionario = null;
    private String transliteration;
    private String gardiner;
    private JMenuBar _menu = new JMenuBar();

    public AncientTextPanel() {
        this.setDefaults();
        this.setTitle(this._captions.getString("Titulo.Textos"));
    }

    public void setDefaults() {
        this._local = Locale.getDefault();
        this._captions = ResourceBundle.getBundle("languages/Messages", this._local);
        Locale[] list = DateFormat.getAvailableLocales();
        for (int i = 0; i < list.length; ++i) {
            System.out.println(list[i].getLanguage() + " " + list[i].getCountry());
        }
        System.out.println("Idioma seleccionado: " + this._local.getLanguage() + "_" + this._local.getCountry());
        this._menu = new JMenuBar();
        this.buildDictionaryActions();
        this.buildDictionaryMenu(this._menu);
        this.buildHieroglyphicMenus(this._menu);
        this.buildLanguagesMenus(this._menu);
        this.setJMenuBar(this._menu);
        this.getContentPane().setLayout(new BorderLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AncientTextPanel.this._myDB.close();
                System.exit(0);
            }
        });
    }

    private void regeneraPanel() {
        this.setTitle(this._captions.getString("Titulo"));
        this._botonTransliteracion.setText(this._captions.getString("Boton.busqueda"));
        this._rInicio.setText(this._captions.getString("Opcion.1"));
        this._rMedio.setText(this._captions.getString("Opcion.2"));
        this._rFinal.setText(this._captions.getString("Opcion.3"));
        this._rExacto.setText(this._captions.getString("Opcion.4"));
        this._rEnglish.setText(this._captions.getString("Criterio.1"));
        this._rGardiner.setText(this._captions.getString("Criterio.2"));
        this._rTranslit.setText(this._captions.getString("Criterio.3"));
        this._menu.remove(this._dictionary);
        this._menu.remove(this.hieroglyphs);
        this._menu.remove(this._idiomas);
        this.buildDictionaryMenu(this._menu);
        this.buildHieroglyphicMenus(this._menu);
        this.buildLanguagesMenus(this._menu);
    }

    private void buildLanguagesMenus(JMenuBar menubar) {
        this._idiomas = new JMenu(this._captions.getString("Menu.3"));
        this._menuSpanish = new JMenuItem("Espa\u00f1ol");
        this._menuSpanish.addActionListener(this);
        this._menuEnglish = new JMenuItem("English");
        this._menuEnglish.addActionListener(this);
        this._idiomas.add(this._menuSpanish);
        this._idiomas.add(this._menuEnglish);
        menubar.add(this._idiomas);
    }

    private void buildDictionaryMenu(JMenuBar menubar) {
        this._dictionary = new JMenu(this._captions.getString("Menu.1"));
        this._dictionary.setMnemonic(68);
        JPopupMenu pm = this._dictionary.getPopupMenu();
        pm.setLayout(new GridLayout(0, 5));
        int _numClaves = this.dictionaryActions.length;
        for (int i = 0; i < _numClaves; ++i) {
            this._dictionary.add((Action)((Object)this.dictionaryActions[i]));
        }
        menubar.add(this._dictionary);
    }

    private void buildHieroglyphicMenus(JMenuBar menubar) {
        String[] families = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "Aa", "Ff"};
        String[] titles = new String[]{this._captions.getString("Jero.A"), this._captions.getString("Jero.B"), this._captions.getString("Jero.C"), this._captions.getString("Jero.D"), this._captions.getString("Jero.E"), this._captions.getString("Jero.F"), this._captions.getString("Jero.G"), this._captions.getString("Jero.H"), this._captions.getString("Jero.I"), this._captions.getString("Jero.K"), this._captions.getString("Jero.L"), this._captions.getString("Jero.M"), this._captions.getString("Jero.N"), this._captions.getString("Jero.O"), this._captions.getString("Jero.P"), this._captions.getString("Jero.Q"), this._captions.getString("Jero.R"), this._captions.getString("Jero.S"), this._captions.getString("Jero.T"), this._captions.getString("Jero.U"), this._captions.getString("Jero.V"), this._captions.getString("Jero.W"), this._captions.getString("Jero.X"), this._captions.getString("Jero.Y"), this._captions.getString("Jero.Z"), this._captions.getString("Jero.Aa"), this._captions.getString("Jero.Ff")};
        this.hieroglyphs = new JMenu(this._captions.getString("Menu.2"));
        for (int i = 0; i < families.length; ++i) {
            HieroglyphicMenu fmenu = new HieroglyphicMenu(titles[i], families[i], 6);
            fmenu.setHieroglyphicMenuListener((HieroglyphicMenuListener)new HieroglyphicMenuMediator());
            if (i < 25) {
                fmenu.setMnemonic(families[i].toUpperCase().charAt(0));
            } else if (i == 25) {
                fmenu.setMnemonic(74);
            } else if (i == 26) {
                fmenu.setMnemonic(150);
            }
            this.hieroglyphs.add((JMenuItem)fmenu);
        }
        this.hieroglyphs.setMnemonic(72);
        menubar.add(this.hieroglyphs);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._botonTransliteracion) {
            int _tipoBusqueda = 0;
            this._buscoBegin = false;
            this._buscoEnd = false;
            this._buscoEnglish = false;
            this._buscoEvery = false;
            this._buscoGardiner = false;
            this._buscoTransliteracion = false;
            this._buscoExacto = false;
            if (this._rInicio.isSelected()) {
                this._buscoBegin = true;
            } else if (this._rMedio.isSelected()) {
                this._buscoEvery = true;
            } else if (this._rFinal.isSelected()) {
                this._buscoEnd = true;
            } else if (this._rExacto.isSelected()) {
                this._buscoExacto = true;
            }
            if (this._rTranslit.isSelected()) {
                this._buscoTransliteracion = true;
            } else if (this._rGardiner.isSelected()) {
                this._buscoGardiner = true;
            } else if (this._rEnglish.isSelected()) {
                this._buscoEnglish = true;
            }
            if (this._buscoBegin) {
                _tipoBusqueda = 1;
            } else if (this._buscoEvery) {
                _tipoBusqueda = 2;
            } else if (this._buscoEnd) {
                _tipoBusqueda = 3;
            } else if (this._buscoExacto) {
                _tipoBusqueda = 0;
            }
            try {
                if (this._buscoTransliteracion) {
                    this._panEd.searchTransliteracion(this._cajaTranslit.getText(), _tipoBusqueda);
                } else if (this._buscoGardiner) {
                    this._panEd.searchGardiner(this._cajaTranslit.getText(), _tipoBusqueda);
                } else if (this._buscoEnglish) {
                    this._panEd.searchEnglish(this._cajaTranslit.getText(), _tipoBusqueda);
                }
            }
            catch (Exception eT) {
                eT.printStackTrace(System.out);
                JOptionPane.showMessageDialog(this, eT.toString(), this._captions.getString("Error.Diccionario"), 0);
            }
        } else if (e.getSource() == this._menuSpanish) {
            System.out.println("Idioma Seleccionado Espa\u00f1ol");
            this._local = new Locale("es", "ES");
            this._captions = ResourceBundle.getBundle("languages/Messages", this._local);
            this.regeneraPanel();
        } else if (e.getSource() == this._menuEnglish) {
            System.out.println("Idioma Seleccionado Ingl\u00e9s");
            this._local = new Locale("en", "US");
            this._captions = ResourceBundle.getBundle("languages/Messages", this._local);
            this.regeneraPanel();
        }
    }

    public void generateSearchCriteriaPanel() {
        this._panOptions = new JPanel(new BorderLayout());
        JPanel _panOptionsA = new JPanel(new BorderLayout());
        _panOptionsA.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this._cajaTranslit = new JTextField("");
        this._botonTransliteracion = new JButton(this._captions.getString("Boton.busqueda"));
        this._botonTransliteracion.addActionListener(this);
        _panOptionsA.add((Component)this._cajaTranslit, "Center");
        _panOptionsA.add((Component)this._botonTransliteracion, "East");
        JPanel _panOptionsB = new JPanel();
        _panOptionsB.setLayout(new GridLayout(1, 0));
        _panOptionsB.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this._rInicio = new JRadioButton(this._captions.getString("Opcion.1"));
        this._rInicio.setSelected(true);
        this._rMedio = new JRadioButton(this._captions.getString("Opcion.2"));
        this._rFinal = new JRadioButton(this._captions.getString("Opcion.3"));
        this._rExacto = new JRadioButton(this._captions.getString("Opcion.4"));
        ButtonGroup _grupo = new ButtonGroup();
        _grupo.add(this._rInicio);
        _grupo.add(this._rMedio);
        _grupo.add(this._rFinal);
        _grupo.add(this._rExacto);
        _panOptionsB.add(this._rInicio);
        _panOptionsB.add(this._rMedio);
        _panOptionsB.add(this._rFinal);
        _panOptionsB.add(this._rExacto);
        JPanel _panOptionsC = new JPanel();
        _panOptionsC.setLayout(new GridBagLayout());
        _panOptionsC.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this._rTranslit = new JRadioButton(this._captions.getString("Criterio.1"));
        this._rTranslit.setSelected(true);
        this._rGardiner = new JRadioButton(this._captions.getString("Criterio.2"));
        this._rEnglish = new JRadioButton(this._captions.getString("Criterio.3"));
        ButtonGroup _grupo2 = new ButtonGroup();
        _grupo2.add(this._rTranslit);
        _grupo2.add(this._rGardiner);
        _grupo2.add(this._rEnglish);
        _panOptionsC.add(this._rTranslit);
        _panOptionsC.add(this._rGardiner);
        _panOptionsC.add(this._rEnglish);
        this._panOptions.add((Component)_panOptionsA, "North");
        this._panOptions.add((Component)_panOptionsC, "East");
        this._panOptions.add((Component)_panOptionsB, "West");
        this.getContentPane().add((Component)this._panOptions, "North");
    }

    public void generateOptionPanel(Component parent, String title) {
        this._panEd = new OptionPanel(parent, title, this.transliteration, this.gardiner);
        this._panEd.setSize(400, 300);
        JScrollPane _scroll = new JScrollPane(this._panEd);
        this.getContentPane().add((Component)_scroll, "Center");
    }

    public void generateStatePanel() {
        this._statePan = new JPanel();
        this._numRegistros.setText("");
        this._statePan.add(this._numRegistros);
        this.getContentPane().add((Component)this._statePan, "South");
    }

    private void buildDictionaryActions() {
        this.dictionaryActions = new DictionaryAction[23];
        int i = 0;
        this.dictionaryActions[i++] = new DictionaryAction("G1+tA", "A");
        this.dictionaryActions[i++] = new DictionaryAction("M17+ti", "i");
        this.dictionaryActions[i++] = new DictionaryAction("D36+ta", "a");
        this.dictionaryActions[i++] = new DictionaryAction("G43-V1+tw", "w");
        this.dictionaryActions[i++] = new DictionaryAction("D58+tb", "b");
        this.dictionaryActions[i++] = new DictionaryAction("Q3+tp", "p");
        this.dictionaryActions[i++] = new DictionaryAction("I9+tf", "f");
        this.dictionaryActions[i++] = new DictionaryAction("G17+tm", "m");
        this.dictionaryActions[i++] = new DictionaryAction("N35+tn", "n");
        this.dictionaryActions[i++] = new DictionaryAction("D21+tr", "r");
        this.dictionaryActions[i++] = new DictionaryAction("O4+th", "h");
        this.dictionaryActions[i++] = new DictionaryAction("V28+tH", "H");
        this.dictionaryActions[i++] = new DictionaryAction("Aa1+tx", "x");
        this.dictionaryActions[i++] = new DictionaryAction("O29+tX", "X");
        this.dictionaryActions[i++] = new DictionaryAction("S29-O34+ts", "s");
        this.dictionaryActions[i++] = new DictionaryAction("O39+tS", "S");
        this.dictionaryActions[i++] = new DictionaryAction("X7+tq", "q");
        this.dictionaryActions[i++] = new DictionaryAction("V31+tk", "k");
        this.dictionaryActions[i++] = new DictionaryAction("W11+tg", "g");
        this.dictionaryActions[i++] = new DictionaryAction("X1+tt", "t");
        this.dictionaryActions[i++] = new DictionaryAction("V13+tT", "T");
        this.dictionaryActions[i++] = new DictionaryAction("D46+td", "d");
        this.dictionaryActions[i++] = new DictionaryAction("I10+tD", "D");
    }

    public void setTransliteration(String string) {
        this.transliteration = string;
    }

    public void setGardiner(String string) {
        this.gardiner = string;
    }

    public static void main(String[] args) {
        SplashScreen splash = new SplashScreen();
        splash.display();
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        AncientTextPanel dictionaryPanel = new AncientTextPanel();
        dictionaryPanel.setTransliteration("Htp");
        dictionaryPanel.setGardiner(null);
        dictionaryPanel.generateSearchCriteriaPanel();
        dictionaryPanel.generateOptionPanel(null, "Diccionario");
        dictionaryPanel.generateStatePanel();
        dictionaryPanel.setSize(544, 403);
        dictionaryPanel.show();
        dictionaryPanel.addWindowListener(new SplashCloser(splash));
    }

    class OptionPanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = -5196578994058417940L;
        HieroglyphicTextModel _modelo;
        JMDCEditor _panDicResul = null;

        public void searchTransliteracion(String transliteration, int _tipoBusqueda) throws Exception {
            AncientTextPanel.this._resultadosDiccionario = AncientTextPanel.this._myDB.doSearchTransliteration(transliteration, _tipoBusqueda);
            this.actualizaPanelDiccionario();
            AncientTextPanel.this._resultadosDiccionario = null;
        }

        public void searchEnglish(String english, int _tipoBusqueda) throws Exception {
            AncientTextPanel.this._resultadosDiccionario = AncientTextPanel.this._myDB.doSearchEnglish(english, _tipoBusqueda);
            this.actualizaPanelDiccionario();
            AncientTextPanel.this._resultadosDiccionario = null;
        }

        public void searchGardiner(String gardiner, int _tipoBusqueda) throws Exception {
            AncientTextPanel.this._resultadosDiccionario = AncientTextPanel.this._myDB.doSearchGardiner(gardiner, _tipoBusqueda);
            this.actualizaPanelDiccionario();
            AncientTextPanel.this._resultadosDiccionario = null;
        }

        private void actualizaPanelDiccionario() throws Exception {
            this._modelo = this._panDicResul == null ? new HieroglyphicTextModel() : this._panDicResul.getWorkflow().getHieroglyphicTextModel();
            int _num = AncientTextPanel.this._resultadosDiccionario.size();
            if (this._panDicResul != null && this._panDicResul.getWorkflow() != null) {
                this._panDicResul.getWorkflow().setMDCCode("");
            }
            String _cadSalida = "";
            String _cadResultado = AncientTextPanel.this._captions.getString("Resultado.1");
            int _iPosiResul = _cadResultado.indexOf("%");
            if (_iPosiResul != -1) {
                _cadResultado = AncientTextPanel.this._captions.getString("Resultado.1").substring(0, _iPosiResul) + Integer.toString(_num) + AncientTextPanel.this._captions.getString("Resultado.1").substring(_iPosiResul + 1);
            }
            AncientTextPanel.this._numRegistros.setText(_cadResultado);
            _cadResultado = null;
            for (int i = 0; i < _num; ++i) {
                _cadSalida = _cadSalida + (String)AncientTextPanel.this._resultadosDiccionario.get(i);
            }
            this._modelo.readModel((Reader)new StringReader(_cadSalida));
            _cadSalida = null;
        }

        private OptionPanel(Component parent, String paneltitle, String transliteration, String gardiner) {
            try {
                AncientTextPanel.this._myDB = new DictionaryDataBase();
                this.searchTransliteracion(transliteration, 1);
                this._panDicResul = new JMDCEditor(this._modelo);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                JOptionPane.showMessageDialog(null, e.toString(), AncientTextPanel.this._captions.getString("Error.Busqueda"), 0);
            }
            this.add((Component)this._panDicResul);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private class HieroglyphicMenuMediator
    implements HieroglyphicMenuListener {
        private HieroglyphicMenuMediator() {
        }

        public void codeSelected(String code) {
            String _translitSign = "";
            String _translateSign = "";
            String _gardiner = "";
            try {
                ArrayList _arr = AncientTextPanel.this._myDB.doSearchSign(code);
                if (_arr != null && _arr.size() > 0) {
                    HashMap _hm = (HashMap)_arr.get(0);
                    _translitSign = (String)_hm.get("TRANSLITERATION");
                    _translateSign = (String)_hm.get("TRANSLATION");
                    _gardiner = (String)_hm.get("GARDINER");
                    _hm = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                JOptionPane.showMessageDialog(null, e.toString(), AncientTextPanel.this._captions.getString("Error.Signo"), 0);
            }
            if (AncientTextPanel.this._cajaTranslit.getText().length() > 0) {
                if (AncientTextPanel.this._rTranslit.isSelected()) {
                    AncientTextPanel.this._cajaTranslit.setText(AncientTextPanel.this._cajaTranslit.getText() + " " + _translitSign);
                } else if (AncientTextPanel.this._rGardiner.isSelected()) {
                    AncientTextPanel.this._cajaTranslit.setText(AncientTextPanel.this._cajaTranslit.getText() + "-" + _gardiner);
                } else {
                    AncientTextPanel.this._cajaTranslit.setText(AncientTextPanel.this._cajaTranslit.getText() + " " + _translateSign);
                }
            } else if (AncientTextPanel.this._rTranslit.isSelected()) {
                AncientTextPanel.this._cajaTranslit.setText(_translitSign);
            } else if (AncientTextPanel.this._rGardiner.isSelected()) {
                AncientTextPanel.this._cajaTranslit.setText(_gardiner);
            } else {
                AncientTextPanel.this._cajaTranslit.setText(_translateSign);
            }
        }

        public void enter(String code) {
        }

        public void exit(String code) {
        }
    }

    class DictionaryAction
    extends MDCIconAction {
        private static final long serialVersionUID = 3084392352183198626L;
        private String tTranslit;

        public DictionaryAction(String mdcText, String trCode) {
            super(mdcText);
            this.tTranslit = trCode;
        }

        public String getTranslit() {
            return this.tTranslit;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                AncientTextPanel.this.setTransliteration(this.tTranslit);
                AncientTextPanel.this._panEd.searchTransliteracion(this.tTranslit, 1);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }
    }

    private static class SplashCloser
    extends WindowAdapter {
        private SplashScreen splash;

        public void windowOpened(WindowEvent e) {
            this.splash.setVisible(false);
            this.splash.dispose();
        }

        public SplashCloser(SplashScreen splash) {
            this.splash = splash;
        }
    }
}

