/*
 * Decompiled with CFR 0.152.
 */
package openglyph.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import openglyph.ui.OpenGlyphEditor;

public class OpenGlyphTree
extends JPanel {
    private OpenGlyphEditor _panelTextos = null;
    private String _rutaBase = "";
    private ResourceBundle _captions = null;

    public OpenGlyphTree(File dir, OpenGlyphEditor panelTextos, ResourceBundle _res) {
        this._panelTextos = panelTextos;
        this._rutaBase = dir.getAbsolutePath();
        this._captions = _res;
        this.setLayout(new BorderLayout());
        JTree tree = new JTree(this.addNodes(null, dir));
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
                TreeNode[] _rutas = node.getPath();
                String _cadenaRuta = "";
                int _numNiveles = _rutas.length;
                for (int i = 0; i < _numNiveles; ++i) {
                    _cadenaRuta = _cadenaRuta + "/" + _rutas[i].toString();
                }
                try {
                    OpenGlyphTree.this._panelTextos.loadFile("." + _cadenaRuta, OpenGlyphTree.this._captions);
                }
                catch (Exception ex) {
                    System.out.println("Error al cargar fichero");
                    ex.printStackTrace(System.out);
                }
            }
        });
        JScrollPane scrollpane = new JScrollPane();
        scrollpane.getViewport().add(tree);
        this.add("Center", scrollpane);
    }

    DefaultMutableTreeNode addNodes(DefaultMutableTreeNode curTop, File dir) {
        String curPath = dir.getName();
        DefaultMutableTreeNode curDir = new DefaultMutableTreeNode(curPath);
        if (curTop != null) {
            curTop.add(curDir);
        }
        File[] _ficheros = dir.listFiles();
        int _numFicheros = _ficheros.length;
        for (int i = 0; i < _numFicheros; ++i) {
            File f = _ficheros[i];
            if (f.isDirectory()) {
                this.addNodes(curDir, f);
                continue;
            }
            curDir.add(new DefaultMutableTreeNode(f.getName()));
        }
        return curDir;
    }

    public Dimension getMinimumSize() {
        return new Dimension(200, 400);
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 400);
    }

    public static void main(String[] av) {
        JFrame frame = new JFrame("FileTree");
        frame.setForeground(Color.black);
        frame.setBackground(Color.lightGray);
        Container cp = frame.getContentPane();
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

