/*
 * Decompiled with CFR 0.152.
 */
package openglyph.dictionary;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jsesh.mdcDisplayer.swing.application.MDCIconAction;
import jsesh.mdcDisplayer.swing.hieroglyphicMenu.HieroglyphicMenu;
import jsesh.mdcDisplayer.swing.hieroglyphicMenu.HieroglyphicMenuListener;
import openglyph.dictionary.DictionaryDataBase;
import openglyph.splash.SplashScreen;
import openglyph.ui.OpenGlyphEditor;
import openglyph.ui.OpenGlyphTree;

public class DictionaryPanel
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 275968290539679276L;
    private ResourceBundle _captions = null;
    private Locale _local = null;
    private JSplitPane _jSeparador = null;
    private JPanel _panOpenGlyph = null;
    private JPanel _panDiccionario = null;
    private JSplitPane _jSeparadorTextos = null;
    private JPanel _pan1 = null;
    private JMenu _dictionary;
    private JMenu hieroglyphs;
    private JMenu _idiomas;
    private boolean _buscoTransliteracion = true;
    private boolean _buscoGardiner = false;
    private boolean _buscoEnglish = false;
    private boolean _buscoBegin = true;
    private boolean _buscoEvery = false;
    private boolean _buscoEnd = false;
    private boolean _buscoExacto = false;
    JRadioButton _rTranslit = null;
    JRadioButton _rGardiner = null;
    JRadioButton _rEnglish = null;
    JRadioButton _rInicio = null;
    JRadioButton _rMedio = null;
    JRadioButton _rFinal = null;
    JRadioButton _rExacto = null;
    private OpenGlyphEditor _panEd = null;
    private OpenGlyphEditor _panText = null;
    private JPanel _panOptions = null;
    private JTextField _cajaTranslit;
    private JLabel _numRegistros = new JLabel();
    private JPanel _statePan;
    private JButton _botonTransliteracion;
    private JMenuItem _menuSpanish = null;
    private JMenuItem _menuEnglish = null;
    private DictionaryDataBase _myDB = null;
    private DictionaryAction[] dictionaryActions;
    private String transliteration;
    private String gardiner;
    private JMenuBar _menu = new JMenuBar();

    public DictionaryPanel() {
        this.setDefaults();
        this.setTitle(this._captions.getString("Titulo"));
    }

    public void setDefaults() {
        this._myDB = new DictionaryDataBase();
        this._local = Locale.getDefault();
        this._captions = ResourceBundle.getBundle("languages/Messages", this._local);
        Locale[] list = DateFormat.getAvailableLocales();
        this._menu = new JMenuBar();
        this.buildDictionaryActions();
        this.buildDictionaryMenu();
        this.buildHieroglyphicMenus();
        this.buildLanguagesMenus();
        this.setJMenuBar(this._menu);
        this.getContentPane().setLayout(new BorderLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DictionaryPanel.this._myDB.close();
                System.exit(0);
            }
        });
    }

    private void regeneraPanel() {
        this.setTitle(this._captions.getString("Titulo"));
        this._botonTransliteracion.setText(this._captions.getString("Boton.busqueda"));
        this._rInicio.setText(this._captions.getString("Opcion.1"));
        this._rMedio.setText(this._captions.getString("Opcion.2"));
        this._rFinal.setText(this._captions.getString("Opcion.3"));
        this._rExacto.setText(this._captions.getString("Opcion.4"));
        this._rEnglish.setText(this._captions.getString("Criterio.1"));
        this._rGardiner.setText(this._captions.getString("Criterio.2"));
        this._rTranslit.setText(this._captions.getString("Criterio.3"));
        this._menu.remove(this._dictionary);
        this._menu.remove(this.hieroglyphs);
        this._menu.remove(this._idiomas);
        this.buildDictionaryMenu();
        this.buildHieroglyphicMenus();
        this.buildLanguagesMenus();
        this.setJMenuBar(this._menu);
    }

    private void buildLanguagesMenus() {
        this._idiomas = new JMenu(this._captions.getString("Menu.3"));
        this._menuSpanish = new JMenuItem("Espa\u00f1ol");
        this._menuSpanish.addActionListener(this);
        this._menuEnglish = new JMenuItem("English");
        this._menuEnglish.addActionListener(this);
        this._idiomas.add(this._menuSpanish);
        this._idiomas.add(this._menuEnglish);
        this._menu.add(this._idiomas);
    }

    private void buildDictionaryMenu() {
        this._dictionary = new JMenu(this._captions.getString("Menu.1"));
        this._dictionary.setMnemonic(68);
        JPopupMenu pm = this._dictionary.getPopupMenu();
        pm.setLayout(new GridLayout(0, 5));
        int _numClaves = this.dictionaryActions.length;
        for (int i = 0; i < _numClaves; ++i) {
            this._dictionary.add(this.dictionaryActions[i]);
        }
        this._menu.add(this._dictionary);
    }

    private void buildHieroglyphicMenus() {
        String[] families = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "Aa", "Ff"};
        String[] titles = new String[]{this._captions.getString("Jero.A"), this._captions.getString("Jero.B"), this._captions.getString("Jero.C"), this._captions.getString("Jero.D"), this._captions.getString("Jero.E"), this._captions.getString("Jero.F"), this._captions.getString("Jero.G"), this._captions.getString("Jero.H"), this._captions.getString("Jero.I"), this._captions.getString("Jero.K"), this._captions.getString("Jero.L"), this._captions.getString("Jero.M"), this._captions.getString("Jero.N"), this._captions.getString("Jero.O"), this._captions.getString("Jero.P"), this._captions.getString("Jero.Q"), this._captions.getString("Jero.R"), this._captions.getString("Jero.S"), this._captions.getString("Jero.T"), this._captions.getString("Jero.U"), this._captions.getString("Jero.V"), this._captions.getString("Jero.W"), this._captions.getString("Jero.X"), this._captions.getString("Jero.Y"), this._captions.getString("Jero.Z"), this._captions.getString("Jero.Aa"), this._captions.getString("Jero.Ff")};
        this.hieroglyphs = new JMenu(this._captions.getString("Menu.2"));
        for (int i = 0; i < families.length; ++i) {
            HieroglyphicMenu fmenu = new HieroglyphicMenu(titles[i], families[i], 6);
            fmenu.setHieroglyphicMenuListener(new HieroglyphicMenuMediator());
            if (i < 25) {
                fmenu.setMnemonic(families[i].toUpperCase().charAt(0));
            } else if (i == 25) {
                fmenu.setMnemonic(74);
            } else if (i == 26) {
                fmenu.setMnemonic(150);
            }
            this.hieroglyphs.add(fmenu);
        }
        this.hieroglyphs.setMnemonic(72);
        this._menu.add(this.hieroglyphs);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._botonTransliteracion) {
            int _tipoBusqueda = 0;
            this._buscoBegin = false;
            this._buscoEnd = false;
            this._buscoEnglish = false;
            this._buscoEvery = false;
            this._buscoGardiner = false;
            this._buscoTransliteracion = false;
            this._buscoExacto = false;
            if (this._rInicio.isSelected()) {
                this._buscoBegin = true;
            } else if (this._rMedio.isSelected()) {
                this._buscoEvery = true;
            } else if (this._rFinal.isSelected()) {
                this._buscoEnd = true;
            } else if (this._rExacto.isSelected()) {
                this._buscoExacto = true;
            }
            if (this._rTranslit.isSelected()) {
                this._buscoTransliteracion = true;
            } else if (this._rGardiner.isSelected()) {
                this._buscoGardiner = true;
            } else if (this._rEnglish.isSelected()) {
                this._buscoEnglish = true;
            }
            if (this._buscoBegin) {
                _tipoBusqueda = 1;
            } else if (this._buscoEvery) {
                _tipoBusqueda = 2;
            } else if (this._buscoEnd) {
                _tipoBusqueda = 3;
            } else if (this._buscoExacto) {
                _tipoBusqueda = 0;
            }
            try {
                if (this._buscoTransliteracion) {
                    this._panEd.searchTransliteracion(this._cajaTranslit.getText(), _tipoBusqueda, this._captions);
                } else if (this._buscoGardiner) {
                    this._panEd.searchGardiner(this._cajaTranslit.getText(), _tipoBusqueda, this._captions);
                } else if (this._buscoEnglish) {
                    this._panEd.searchEnglish(this._cajaTranslit.getText(), _tipoBusqueda, this._captions);
                }
            }
            catch (Exception eT) {
                eT.printStackTrace(System.out);
                JOptionPane.showMessageDialog(this, eT.toString(), this._captions.getString("Error.Diccionario"), 0);
            }
        } else if (e.getSource() == this._menuSpanish) {
            this._local = new Locale("es", "ES");
            this._captions = ResourceBundle.getBundle("languages/Messages", this._local);
            this.regeneraPanel();
        } else if (e.getSource() == this._menuEnglish) {
            this._local = new Locale("en", "US");
            this._captions = ResourceBundle.getBundle("languages/Messages", this._local);
            this.regeneraPanel();
        }
    }

    public void generateSearchCriteriaPanel() {
        this._panOptions = new JPanel(new BorderLayout());
        JPanel _panOptionsA = new JPanel(new BorderLayout());
        _panOptionsA.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this._cajaTranslit = new JTextField("");
        this._botonTransliteracion = new JButton(this._captions.getString("Boton.busqueda"));
        this._botonTransliteracion.addActionListener(this);
        _panOptionsA.add((Component)this._cajaTranslit, "Center");
        _panOptionsA.add((Component)this._botonTransliteracion, "East");
        JPanel _panOptionsB = new JPanel();
        _panOptionsB.setLayout(new GridLayout(1, 0));
        _panOptionsB.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this._rInicio = new JRadioButton(this._captions.getString("Opcion.1"));
        this._rInicio.setSelected(true);
        this._rMedio = new JRadioButton(this._captions.getString("Opcion.2"));
        this._rFinal = new JRadioButton(this._captions.getString("Opcion.3"));
        this._rExacto = new JRadioButton(this._captions.getString("Opcion.4"));
        ButtonGroup _grupo = new ButtonGroup();
        _grupo.add(this._rInicio);
        _grupo.add(this._rMedio);
        _grupo.add(this._rFinal);
        _grupo.add(this._rExacto);
        _panOptionsB.add(this._rInicio);
        _panOptionsB.add(this._rMedio);
        _panOptionsB.add(this._rFinal);
        _panOptionsB.add(this._rExacto);
        JPanel _panOptionsC = new JPanel();
        _panOptionsC.setLayout(new GridBagLayout());
        _panOptionsC.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this._rTranslit = new JRadioButton(this._captions.getString("Criterio.1"));
        this._rTranslit.setSelected(true);
        this._rGardiner = new JRadioButton(this._captions.getString("Criterio.2"));
        this._rEnglish = new JRadioButton(this._captions.getString("Criterio.3"));
        ButtonGroup _grupo2 = new ButtonGroup();
        _grupo2.add(this._rTranslit);
        _grupo2.add(this._rGardiner);
        _grupo2.add(this._rEnglish);
        _panOptionsC.add(this._rTranslit);
        _panOptionsC.add(this._rGardiner);
        _panOptionsC.add(this._rEnglish);
        this._panOptions.add((Component)_panOptionsA, "North");
        this._panOptions.add((Component)_panOptionsC, "East");
        this._panOptions.add((Component)_panOptionsB, "West");
        this._panOpenGlyph = new JPanel(new BorderLayout());
        this._panDiccionario = new JPanel(new BorderLayout());
        this._jSeparador = new JSplitPane(1);
        this._jSeparador.setRightComponent(this._panDiccionario);
        this._jSeparador.setLeftComponent(this._panOpenGlyph);
        this._jSeparador.setOneTouchExpandable(true);
        Dimension minimumSize = new Dimension(200, 150);
        this._panDiccionario.setMinimumSize(minimumSize);
        this._panOpenGlyph.setMinimumSize(minimumSize);
        this._jSeparador.setDividerLocation(200);
        this._jSeparador.setDividerSize(10);
        this._jSeparador.setPreferredSize(new Dimension(800, 520));
        this._pan1 = new JPanel(new BorderLayout());
        this._jSeparadorTextos = new JSplitPane(0);
        this._jSeparadorTextos.setRightComponent(this._pan1);
        this._jSeparadorTextos.setLeftComponent(this._jSeparador);
        this._jSeparadorTextos.setOneTouchExpandable(true);
        this._pan1.setMinimumSize(minimumSize);
        this._jSeparadorTextos.setDividerLocation(200);
        this._jSeparadorTextos.setDividerSize(10);
        this._jSeparadorTextos.setPreferredSize(new Dimension(800, 520));
        this._panDiccionario.add((Component)this._panOptions, "North");
        this.getContentPane().add((Component)this._jSeparadorTextos, "Center");
    }

    public void generateOptionPanel(Component parent, String title) {
        this._panEd = new OpenGlyphEditor(parent, title, this.transliteration, this.gardiner, this._myDB, this._captions, this._numRegistros);
        this._panEd.setSize(400, 300);
        JScrollPane _scroll = new JScrollPane(this._panEd);
        this._panDiccionario.add((Component)_scroll, "Center");
        this._panText = new OpenGlyphEditor(parent, title, this.transliteration, this.gardiner, this._myDB, this._captions, this._numRegistros);
        this._panText.setSize(400, 300);
        JScrollPane _scrollTextos = new JScrollPane(this._panText);
        this._pan1.add((Component)_scrollTextos, "Center");
        this._panOpenGlyph.add((Component)new OpenGlyphTree(new File("./textos"), this._panText, this._captions), "Center");
    }

    public void generateStatePanel() {
        this._statePan = new JPanel();
        this._numRegistros.setText("");
        this._statePan.add(this._numRegistros);
        this.getContentPane().add((Component)this._statePan, "South");
    }

    private void buildDictionaryActions() {
        this.dictionaryActions = new DictionaryAction[23];
        int i = 0;
        this.dictionaryActions[i++] = new DictionaryAction("G1+tA", "A");
        this.dictionaryActions[i++] = new DictionaryAction("M17+ti", "i");
        this.dictionaryActions[i++] = new DictionaryAction("D36+ta", "a");
        this.dictionaryActions[i++] = new DictionaryAction("G43-V1+tw", "w");
        this.dictionaryActions[i++] = new DictionaryAction("D58+tb", "b");
        this.dictionaryActions[i++] = new DictionaryAction("Q3+tp", "p");
        this.dictionaryActions[i++] = new DictionaryAction("I9+tf", "f");
        this.dictionaryActions[i++] = new DictionaryAction("G17+tm", "m");
        this.dictionaryActions[i++] = new DictionaryAction("N35+tn", "n");
        this.dictionaryActions[i++] = new DictionaryAction("D21+tr", "r");
        this.dictionaryActions[i++] = new DictionaryAction("O4+th", "h");
        this.dictionaryActions[i++] = new DictionaryAction("V28+tH", "H");
        this.dictionaryActions[i++] = new DictionaryAction("Aa1+tx", "x");
        this.dictionaryActions[i++] = new DictionaryAction("O29+tX", "X");
        this.dictionaryActions[i++] = new DictionaryAction("S29-O34+ts", "s");
        this.dictionaryActions[i++] = new DictionaryAction("O39+tS", "S");
        this.dictionaryActions[i++] = new DictionaryAction("X7+tq", "q");
        this.dictionaryActions[i++] = new DictionaryAction("V31+tk", "k");
        this.dictionaryActions[i++] = new DictionaryAction("W11+tg", "g");
        this.dictionaryActions[i++] = new DictionaryAction("X1+tt", "t");
        this.dictionaryActions[i++] = new DictionaryAction("V13+tT", "T");
        this.dictionaryActions[i++] = new DictionaryAction("D46+td", "d");
        this.dictionaryActions[i++] = new DictionaryAction("I10+tD", "D");
    }

    public void setTransliteration(String string) {
        this.transliteration = string;
    }

    public void setGardiner(String string) {
        this.gardiner = string;
    }

    public static void main(String[] args) {
        SplashScreen splash = new SplashScreen();
        splash.display();
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        DictionaryPanel dictionaryPanel = new DictionaryPanel();
        dictionaryPanel.setTransliteration("Htp");
        dictionaryPanel.setGardiner(null);
        dictionaryPanel.generateSearchCriteriaPanel();
        dictionaryPanel.generateOptionPanel(null, "Diccionario");
        dictionaryPanel.generateStatePanel();
        dictionaryPanel.setSize(800, 600);
        dictionaryPanel.show();
        dictionaryPanel.addWindowListener(new SplashCloser(splash));
    }

    private class HieroglyphicMenuMediator
    implements HieroglyphicMenuListener {
        private HieroglyphicMenuMediator() {
        }

        public void codeSelected(String code) {
            String _translitSign = "";
            String _translateSign = "";
            String _gardiner = "";
            try {
                ArrayList _arr = DictionaryPanel.this._myDB.doSearchSign(code);
                if (_arr != null && _arr.size() > 0) {
                    HashMap _hm = (HashMap)_arr.get(0);
                    _translitSign = (String)_hm.get("TRANSLITERATION");
                    _translateSign = (String)_hm.get("TRANSLATION");
                    _gardiner = (String)_hm.get("GARDINER");
                    _hm = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                JOptionPane.showMessageDialog(null, e.toString(), DictionaryPanel.this._captions.getString("Error.Signo"), 0);
            }
            if (DictionaryPanel.this._cajaTranslit.getText().length() > 0) {
                if (DictionaryPanel.this._rTranslit.isSelected()) {
                    DictionaryPanel.this._cajaTranslit.setText(DictionaryPanel.this._cajaTranslit.getText() + " " + _translitSign);
                } else if (DictionaryPanel.this._rGardiner.isSelected()) {
                    DictionaryPanel.this._cajaTranslit.setText(DictionaryPanel.this._cajaTranslit.getText() + "-" + _gardiner);
                } else {
                    DictionaryPanel.this._cajaTranslit.setText(DictionaryPanel.this._cajaTranslit.getText() + " " + _translateSign);
                }
            } else if (DictionaryPanel.this._rTranslit.isSelected()) {
                DictionaryPanel.this._cajaTranslit.setText(_translitSign);
            } else if (DictionaryPanel.this._rGardiner.isSelected()) {
                DictionaryPanel.this._cajaTranslit.setText(_gardiner);
            } else {
                DictionaryPanel.this._cajaTranslit.setText(_translateSign);
            }
        }

        public void enter(String code) {
        }

        public void exit(String code) {
        }
    }

    class DictionaryAction
    extends MDCIconAction {
        private static final long serialVersionUID = 3084392352183198626L;
        private String tTranslit;

        public DictionaryAction(String mdcText, String trCode) {
            super(mdcText);
            this.tTranslit = trCode;
        }

        public String getTranslit() {
            return this.tTranslit;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                DictionaryPanel.this.setTransliteration(this.tTranslit);
                DictionaryPanel.this._panEd.searchTransliteracion(this.tTranslit, 1, DictionaryPanel.this._captions);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }
    }

    private static class SplashCloser
    extends WindowAdapter {
        private SplashScreen splash;

        public void windowOpened(WindowEvent e) {
            this.splash.setVisible(false);
            this.splash.dispose();
        }

        public SplashCloser(SplashScreen splash) {
            this.splash = splash;
        }
    }
}

