/*
 * Decompiled with CFR 0.152.
 */
package openglyph.splash;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class SplashScreen
extends Frame {
    private Image img;

    public SplashScreen() {
        this.setUndecorated(true);
        this.buildImage();
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(this.img, 0);
        this.setSize(this.img.getWidth(this), this.img.getHeight(this));
        this.center();
        this.toFront();
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                SplashScreen.this.closeSplash();
            }
        });
    }

    public void display() {
        Runnable r = new Runnable(){

            public void run() {
                SplashScreen.this.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    private void buildImage() {
        URL imgURL = this.getClass().getResource("/openglyphResources/images/303lg.jpg");
        this.img = new ImageIcon(imgURL).getImage();
    }

    private void center() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frame = this.getBounds();
        this.setLocation((screen.width - frame.width) / 2, (screen.height - frame.height) / 2);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        g.drawImage(this.img, 0, 0, this.getWidth(), this.getHeight(), this);
    }

    public void closeSplash() {
        this.img.flush();
        this.dispose();
    }
}

