/*
 * Decompiled with CFR 0.152.
 */
package openglyph.ui;

import java.awt.Component;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jsesh.mdc.utils.MDCSyntaxError;
import jsesh.mdcDisplayer.swing.editor.HieroglyphicTextModel;
import jsesh.mdcDisplayer.swing.editor.JMDCEditor;
import openglyph.dictionary.DictionaryDataBase;

public class OpenGlyphEditor
extends JPanel {
    private ArrayList _resultadosDiccionario = null;
    private DictionaryDataBase _myDB = null;
    private ResourceBundle _captions = null;
    private Locale _local = null;
    private JLabel _numRegistros;
    HieroglyphicTextModel _modelo;
    JMDCEditor _panDicResul;

    public void searchTransliteracion(String transliteration, int _tipoBusqueda, ResourceBundle _res) throws Exception {
        this._resultadosDiccionario = this._myDB.doSearchTransliteration(transliteration, _tipoBusqueda);
        this.actualizaPanelDiccionario(_res);
        this._resultadosDiccionario = null;
    }

    public void searchEnglish(String english, int _tipoBusqueda, ResourceBundle _res) throws Exception {
        this._resultadosDiccionario = this._myDB.doSearchEnglish(english, _tipoBusqueda);
        this.actualizaPanelDiccionario(_res);
        this._resultadosDiccionario = null;
    }

    public void searchGardiner(String gardiner, int _tipoBusqueda, ResourceBundle _res) throws Exception {
        this._resultadosDiccionario = this._myDB.doSearchGardiner(gardiner, _tipoBusqueda);
        this.actualizaPanelDiccionario(_res);
        this._resultadosDiccionario = null;
    }

    private void actualizaPanelDiccionario(ResourceBundle _res) throws Exception {
        this._captions = _res;
        this._modelo = this._panDicResul == null ? new HieroglyphicTextModel() : this._panDicResul.getWorkflow().getHieroglyphicTextModel();
        int _num = this._resultadosDiccionario.size();
        if (this._panDicResul != null && this._panDicResul.getWorkflow() != null) {
            this._panDicResul.getWorkflow().setMDCCode("");
        }
        String _cadSalida = "";
        String _cadResultado = this._captions.getString("Resultado.1");
        int _iPosiResul = _cadResultado.indexOf("%");
        if (_iPosiResul != -1) {
            _cadResultado = this._captions.getString("Resultado.1").substring(0, _iPosiResul) + Integer.toString(_num) + this._captions.getString("Resultado.1").substring(_iPosiResul + 1);
        }
        this._numRegistros.setText(_cadResultado);
        _cadResultado = null;
        for (int i = 0; i < _num; ++i) {
            _cadSalida = _cadSalida + (String)this._resultadosDiccionario.get(i);
        }
        this._modelo.readModel(new StringReader(_cadSalida));
        _cadSalida = null;
    }

    public OpenGlyphEditor(Component parent, String paneltitle, String transliteration, String gardiner, DictionaryDataBase myDB, ResourceBundle captions, JLabel numRegistros) {
        this._myDB = myDB;
        this._captions = captions;
        this._numRegistros = numRegistros;
        this._panDicResul = null;
        try {
            this.searchTransliteracion(transliteration, 1, this._captions);
            this._panDicResul = new JMDCEditor(this._modelo);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            JOptionPane.showMessageDialog(null, e.toString(), this._captions.getString("Error.Busqueda"), 0);
        }
        this.add(this._panDicResul);
    }

    public void loadFile(String _fichero, ResourceBundle _res) throws Exception {
        StringBuffer buffer = new StringBuffer();
        try {
            int c;
            File file = new File(_fichero);
            if (file.isDirectory()) {
                return;
            }
            FileReader r = new FileReader(file);
            while ((c = ((Reader)r).read()) != -1) {
                buffer.append((char)c);
            }
            ((Reader)r).close();
            if (buffer.length() != 0 && buffer.charAt(0) == '@') {
                int first = buffer.indexOf("\n");
                if (first == -1) {
                    first = buffer.length();
                }
                buffer.replace(0, first, "");
            }
            this._panDicResul.getWorkflow().getHieroglyphicTextModel().setPhilologyIsSign(!file.getName().endsWith(".hie"));
            this._modelo.readModel(new StringReader(buffer.toString()));
        }
        catch (MDCSyntaxError e) {
            String msg = "error at line " + e.getLine();
            int infPos = e.getCharPos() - 10 > 0 ? e.getCharPos() - 10 : 0;
            int supPos = e.getCharPos() + 10 > buffer.length() ? buffer.length() : e.getCharPos() + 10;
            msg = msg + ". Wrong text : " + buffer.substring(infPos, supPos);
            JOptionPane.showMessageDialog(null, msg, "Syntax Error", 0);
            e.getCharPos();
            e.printStackTrace();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Syntax Error", 0);
        }
    }
}

