/*
 * Decompiled with CFR 0.152.
 */
package jsesh.bzr;

import java.io.IOException;
import java.io.InputStream;
import jsesh.bzr.BzrCodes;
import jsesh.bzr.BzrFontBuilder;
import jsesh.bzr.BzrFormatException;
import jsesh.bzr.BzrPortableFile;
import jsesh.utils.Bezier;

public class BzrFontReader
implements BzrCodes {
    private BzrFontBuilder builder;
    private BzrPortableFile in;
    private int c;
    private double size;

    public BzrFontReader(BzrFontBuilder builder) {
        this.builder = builder;
    }

    public void read(InputStream in) throws BzrFormatException, IOException {
        this.builder.reset();
        this.in = new BzrPortableFile(in);
        this.readHeader();
        this.readChars();
        this.readPostFace();
        in.close();
    }

    private void readHeader() throws IOException {
        this.size = this.in.readBDouble();
        this.builder.setSize(this.size);
        this.builder.setFontName(this.in.readString());
    }

    /*
     * WARNING - void declaration
     */
    private void readChars() throws IOException, BzrFormatException {
        while ((this.c = this.in.skipNops()) != 80) {
            void var9_5;
            void var7_4;
            void var5_3;
            void var3_2;
            void var1_1;
            int code = this.in.read();
            switch (this.c) {
                case 66: {
                    double width = this.readSDouble();
                    double llx = this.readSDouble();
                    double lly = this.readSDouble();
                    double urx = this.readSDouble();
                    double ury = this.readSDouble();
                    break;
                }
                case 98: {
                    double width = this.readBDouble();
                    double llx = this.readBDouble();
                    double lly = this.readBDouble();
                    double urx = this.readBDouble();
                    double ury = this.readBDouble();
                    break;
                }
                default: {
                    throw new BzrFormatException("found char " + this.c + "while expecting beginning of char indicator");
                }
            }
            this.builder.startChar(code, (double)var1_1, (double)var3_2, (double)var5_3, (double)var7_4, (double)var9_5);
            this.c = this.in.skipNops();
            while (this.c != 101) {
                double c1x = 0.0;
                double c1y = 0.0;
                double c2x = 0.0;
                double c2y = 0.0;
                double area = 0.0;
                int pathType = this.c;
                double p1x = this.readBDouble();
                double p1y = this.readBDouble();
                switch (pathType) {
                    case 112: {
                        this.builder.newPath(p1x, p1y);
                        break;
                    }
                    case 116: {
                        this.builder.newCurve(1, p1x, p1y);
                        break;
                    }
                    case 79: {
                        this.builder.newClosedCurve(1, p1x, p1y);
                        break;
                    }
                    default: {
                        throw new BzrFormatException("unsupported path type " + pathType);
                    }
                }
                while ((this.c = this.in.skipNops()) != 112 && this.c != 116 && this.c != 79 && this.c != 101) {
                    void var18_10;
                    void var16_9;
                    switch (this.c) {
                        case 108: {
                            double p2x = this.readBDouble();
                            double p2y = this.readBDouble();
                            this.builder.addLineSegment(p2x, p2y);
                            break;
                        }
                        case 76: {
                            double p2x = this.readSDouble();
                            double p2y = this.readSDouble();
                            this.builder.addLineSegment(p2x, p2y);
                            break;
                        }
                        case 115: {
                            c1x = this.readBDouble();
                            c1y = this.readBDouble();
                            c2x = this.readBDouble();
                            c2y = this.readBDouble();
                            double p2x = this.readBDouble();
                            double p2y = this.readBDouble();
                            this.builder.addSplineSegment(c1x, c1y, c2x, c2y, p2x, p2y);
                            break;
                        }
                        case 83: {
                            c1x = this.readSDouble();
                            c1y = this.readSDouble();
                            c2x = this.readSDouble();
                            c2y = this.readSDouble();
                            double p2x = this.readSDouble();
                            double p2y = this.readSDouble();
                            this.builder.addSplineSegment(c1x, c1y, c2x, c2y, p2x, p2y);
                            break;
                        }
                        default: {
                            throw new BzrFormatException("unexpected char " + this.c);
                        }
                    }
                    switch (this.c) {
                        case 76: 
                        case 108: {
                            area += (var16_9 - p1x) * (var18_10 + p1y);
                            break;
                        }
                        case 83: 
                        case 115: {
                            area += Bezier.area(p1x, p1y, c1x, c1y, c2x, c2y, (double)var16_9, (double)var18_10);
                        }
                    }
                    p1x = var16_9;
                    p1y = var18_10;
                }
                this.builder.pathEnd(area >= 0.0);
            }
            this.builder.charEnd();
        }
    }

    private void readPostFace() throws BzrFormatException, IOException {
        if (this.c != 80) {
            throw new BzrFormatException("unexpected char " + this.c);
        }
        double llx = this.readBDouble();
        double lly = this.readBDouble();
        double urx = this.readBDouble();
        double ury = this.readBDouble();
        this.builder.setBoundingBox(llx, lly, urx, ury);
        this.builder.fontEnd();
    }

    private double readSDouble() throws IOException {
        return this.in.readSDouble() * this.size;
    }

    private double readBDouble() throws IOException {
        return this.in.readBDouble() * this.size;
    }
}

