/*
 * Decompiled with CFR 0.152.
 */
package jsesh.bzr;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import jsesh.bzr.BzrCodes;

public class BzrPortableFile
extends FilterInputStream
implements BzrCodes {
    public static final double MAXREAL = 255.99998474121094;
    private double[] buffer = new double[3];
    private boolean isPositive;

    public BzrPortableFile(InputStream in) {
        super(in);
    }

    public double readBDouble() throws IOException {
        this.readBuffer(3);
        double d = this.buffer[0] + this.buffer[1] / 256.0 + this.buffer[2] / 65536.0;
        if (!this.isPositive) {
            d -= 255.99998474121094;
        }
        return d;
    }

    public double readSDouble() throws IOException {
        this.readBuffer(2);
        double d = this.buffer[0] / 256.0 + this.buffer[1] / 65536.0;
        if (!this.isPositive) {
            d -= 1.0;
        }
        return d;
    }

    private void readBuffer(int n) throws IOException {
        int hi = this.read();
        this.isPositive = (hi & 0x80) == 0;
        this.buffer[0] = hi;
        for (int i = 1; i < n; ++i) {
            this.buffer[i] = this.read();
        }
    }

    public int skipNops() throws IOException {
        int c;
        while ((c = this.read()) == 120) {
        }
        return c;
    }

    public String readString() throws IOException {
        int size = this.read();
        byte[] b = new byte[size];
        this.read(b);
        return new String(b, "ISO-8859-1");
    }
}

