/*
 * Decompiled with CFR 0.152.
 */
package jsesh.bzr.simple;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import jsesh.utils.DoubleUtils;

public class ShapeChar {
    private Shape shape;
    private Rectangle2D bbox;
    private Rectangle2D[] zones;

    public Rectangle2D getBbox() {
        return this.bbox;
    }

    public void setBbox(Rectangle2D v) {
        this.bbox = v;
    }

    public void setBBox(double llx, double lly, double urx, double ury) {
        this.bbox = new Rectangle2D.Double(llx, ury, urx - llx, lly - ury);
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape v) {
        this.shape = v;
    }

    public void draw(Graphics2D g, double x, double y, double xscale, double yscale, float angle) {
        Graphics2D tmpG = (Graphics2D)g.create();
        tmpG.translate(x, y);
        Shape s = this.getShape();
        tmpG.scale(xscale, yscale);
        if (angle != 0.0f) {
            s = AffineTransform.getRotateInstance(angle).createTransformedShape(s);
            Rectangle2D r = s.getBounds2D();
            tmpG.translate(-r.getMinX(), -r.getMinY());
        }
        tmpG.fill(s);
        tmpG.dispose();
    }

    public Shape getTransformedShape(double x, double y, double xscale, double yscale, double angle) {
        Shape result = this.getShape();
        if (angle != 0.0) {
            AffineTransform tr0 = AffineTransform.getRotateInstance(angle);
            result = tr0.createTransformedShape(this.getShape());
            Rectangle2D r = result.getBounds2D();
            x -= r.getMinX() * xscale;
            y -= r.getMinY() * yscale;
        }
        AffineTransform tr = AffineTransform.getTranslateInstance(x, y);
        tr.concatenate(AffineTransform.getScaleInstance(xscale, yscale));
        result = tr.createTransformedShape(result);
        return result;
    }

    public Area getSignArea(double x, double y, double xscale, double yscale, double angle) {
        Area s1 = new Area();
        Shape s = this.getTransformedShape(x, y, xscale, yscale, angle);
        PathIterator iter = s.getPathIterator(null);
        Path2D current = null;
        while (!iter.isDone()) {
            float[] coords = new float[6];
            int type = iter.currentSegment(coords);
            switch (type) {
                case 4: {
                    current.closePath();
                    s1.add(new Area(current));
                    current = null;
                    break;
                }
                case 3: {
                    ((Path2D.Float)current).curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 1: {
                    ((Path2D.Float)current).lineTo(coords[0], coords[1]);
                    break;
                }
                case 0: {
                    if (current != null) {
                        s1.add(new Area(current));
                    }
                    current = new GeneralPath(iter.getWindingRule());
                    ((Path2D.Float)current).moveTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    ((Path2D.Float)current).quadTo(coords[0], coords[1], coords[2], coords[3]);
                }
            }
            iter.next();
        }
        if (current != null) {
            s1.add(new Area(current));
        }
        return s1;
    }

    public void fixShape() {
        PathIterator it = this.shape.getPathIterator(null, 0.01);
        GeneralPath p = new GeneralPath();
        p.append(it, false);
        Rectangle2D r = p.getBounds2D();
        AffineTransform transform = AffineTransform.getTranslateInstance(-r.getMinX(), -r.getMinY());
        this.shape = transform.createTransformedShape(this.shape);
        if (this.zones != null) {
            for (int i = 0; i < this.zones.length; ++i) {
                if (this.zones[i] == null) continue;
                this.zones[i] = new Rectangle2D.Double(this.zones[i].getMinX() - r.getMinX(), this.zones[i].getMinY() - r.getMinY(), this.zones[i].getWidth(), this.zones[i].getHeight());
            }
        }
        this.setBBox(0.0, r.getMaxY() - r.getMinY(), r.getMaxX() - r.getMinX(), 0.0);
    }

    public void scaleToHeight(double h) {
        double s = h / this.getBbox().getHeight();
        this.setShape(AffineTransform.getScaleInstance(s, s).createTransformedShape(this.getShape()));
        if (this.zones != null) {
            for (int i = 0; i < this.zones.length; ++i) {
                if (this.zones[i] == null) continue;
                this.zones[i] = new Rectangle2D.Double(this.zones[i].getMinX() * s, this.zones[i].getMinY() * s, this.zones[i].getWidth() * s, this.zones[i].getHeight() * s);
            }
        }
        this.fixShape();
    }

    public void exportToSVG(OutputStream o, String encoding) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(o, encoding);
        out.write("<?xml version=\"1.0\" ");
        if (!"".equals(encoding)) {
            out.write("encoding =\"" + encoding + "\" ");
        }
        out.write("standalone=\"yes\"?>\n");
        out.write("<svg width=\"");
        out.write(DoubleUtils.writeInDecimal(this.bbox.getWidth()));
        out.write("\" height=\"");
        out.write(DoubleUtils.writeInDecimal(this.bbox.getHeight()));
        out.write("\">\n");
        out.write("<path style=\"fill:#000000; stroke:none\" d=\"");
        PathIterator iter = this.shape.getPathIterator(null);
        while (!iter.isDone()) {
            float[] coords = new float[6];
            int type = iter.currentSegment(coords);
            switch (type) {
                case 4: {
                    out.write(" Z ");
                    break;
                }
                case 3: {
                    out.write(" C ");
                    this.outputNumbers(out, coords, 6);
                    break;
                }
                case 1: {
                    out.write(" L ");
                    this.outputNumbers(out, coords, 2);
                    break;
                }
                case 0: {
                    out.write(" M ");
                    this.outputNumbers(out, coords, 2);
                    break;
                }
                case 2: {
                    out.write(" Q ");
                    this.outputNumbers(out, coords, 4);
                }
            }
            iter.next();
        }
        out.write("\"/>");
        out.write("</svg>\n");
        ((Writer)out).close();
    }

    private void outputNumbers(Writer out, float[] coords, int max) throws IOException {
        for (int i = 0; i < max; ++i) {
            out.write(DoubleUtils.writeInDecimal(coords[i]));
            out.write(32);
        }
    }

    public void setZone(int i, Rectangle2D rect) {
        if (this.zones == null) {
            this.zones = new Rectangle2D[3];
        }
        this.zones[i] = rect;
    }

    public Rectangle2D getZone(int i) {
        if (this.zones == null) {
            return null;
        }
        return this.zones[i];
    }
}

