/*
 * Decompiled with CFR 0.152.
 */
package jsesh.externalFonts.model;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import jsesh.bzr.BzrFormatException;
import jsesh.bzr.simple.ShapeChar;
import jsesh.externalFonts.model.BZRSignSource;
import jsesh.externalFonts.model.SVGSignSource;
import jsesh.externalFonts.model.SimpleSignSourceModel;
import jsesh.externalFonts.model.TTFSignSource;
import jsesh.externalFonts.model.TmlSignsImporter;
import jsesh.hieroglyphs.DefaultHieroglyphicFontManager;

public class ExternalSignImporterModel {
    private File sourceDirectory;
    private SimpleSignSourceModel newSigns;
    private ShapeChar referenceShape;

    public ExternalSignImporterModel() {
        DefaultHieroglyphicFontManager db = DefaultHieroglyphicFontManager.getInstance();
        this.referenceShape = db.get("A1");
        this.sourceDirectory = new File(".");
    }

    public boolean hasNext() {
        if (this.newSigns != null) {
            return this.newSigns.hasNext();
        }
        return false;
    }

    public boolean hasPrevious() {
        if (this.newSigns != null) {
            return this.newSigns.hasPrevious();
        }
        return false;
    }

    public ShapeChar getShapeChar() {
        if (this.newSigns != null) {
            return this.newSigns.getCurrentShape();
        }
        return null;
    }

    public ShapeChar getReferenceShape() {
        return this.referenceShape;
    }

    public void insertSign(String text) {
        DefaultHieroglyphicFontManager.getInstance().insertNewSign(text, this.getShapeChar());
    }

    public void previousSign() {
        if (this.newSigns != null) {
            this.newSigns.previous();
        }
    }

    public void nextSign() {
        if (this.newSigns != null) {
            this.newSigns.next();
        }
    }

    public void loadSigns(File file) throws IOException {
        String fileName = file.getName().toLowerCase();
        if (fileName.endsWith(".ttf")) {
            this.loadTTF(file);
        } else if (fileName.endsWith(".bzr")) {
            this.loadBZR(file);
        } else if (fileName.endsWith(".svg")) {
            this.loadSVG(file);
        } else if (fileName.endsWith(".tml")) {
            this.loadTml(file);
        } else {
            throw new IOException("Unknown format");
        }
        if (this.newSigns != null && this.newSigns.hasNext()) {
            this.newSigns.next();
        }
    }

    private void loadSVG(File file) throws IOException {
        this.newSigns = new SVGSignSource(file);
        while (this.newSigns.hasNext()) {
            this.newSigns.next();
        }
        this.newSigns.beforeFirst();
    }

    private void loadBZR(File file) throws IOException {
        try {
            this.newSigns = new BZRSignSource(file);
        }
        catch (BzrFormatException e) {
            throw new IOException("Bad file format");
        }
    }

    private void loadTTF(File file) throws IOException {
        this.newSigns = new TTFSignSource(file);
    }

    private void loadTml(File file) throws IOException {
        FileReader r = new FileReader(file);
        this.newSigns = new TmlSignsImporter(r);
    }

    public boolean fileFormatIsKnown(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String fileName = file.getName().toLowerCase();
        if (fileName.endsWith(".ttf")) {
            return true;
        }
        if (fileName.endsWith(".bzr")) {
            return true;
        }
        if (fileName.endsWith(".svg")) {
            return true;
        }
        return fileName.endsWith(".tml");
    }

    public String getKnownFormats() {
        return "TTF (true type fonts), bzr (Gnu font util fonts), SVG (svg sign drawing)";
    }

    public void flipHorizontally() {
        Shape s = this.getShapeChar().getShape();
        s = new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, (float)this.getShapeChar().getBbox().getWidth(), 0.0f).createTransformedShape(s);
        this.getShapeChar().setShape(s);
    }

    public void flipVertically() {
        Shape s = this.getShapeChar().getShape();
        s = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, (float)this.getShapeChar().getBbox().getHeight()).createTransformedShape(s);
        this.getShapeChar().setShape(s);
    }

    public void resizeVerticallyTo(double height) {
        double currentHeight = this.getShapeChar().getBbox().getHeight();
        double scale = height / currentHeight;
        Shape s = AffineTransform.getScaleInstance(scale, scale).createTransformedShape(this.getShapeChar().getShape());
        this.getShapeChar().setShape(s);
        this.getShapeChar().fixShape();
    }

    public String getDefaultSignCode() {
        if (this.newSigns != null) {
            return this.newSigns.getCurrentCode();
        }
        return "";
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }
}

