/*
 * Decompiled with CFR 0.152.
 */
package jsesh.externalFonts.model;

import java.awt.BasicStroke;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jsesh.bzr.simple.ShapeChar;
import jsesh.externalFonts.model.SimpleSignSourceModel;
import jsesh.hieroglyphs.HieroglyphsManager;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SVGSignSource
implements SimpleSignSourceModel {
    private ShapeChar shape;
    private String code;
    private int pos;

    public SVGSignSource(File file) {
        try {
            this.initSVGSignSource(file.toURI().toURL());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SVGSignSource(URL url) {
        this.initSVGSignSource(url);
    }

    private void initSVGSignSource(URL url) {
        try {
            this.code = this.getCodeForURL(url);
            if (this.code == null) {
                this.code = "";
            }
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setValidating(false);
            parserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            parserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            SAXParser parser = parserFactory.newSAXParser();
            SVGReader handler = new SVGReader();
            parser.parse(url.openStream(), (DefaultHandler)handler);
            this.shape = new ShapeChar();
            this.shape.setShape(handler.getGeneralPath());
            if (handler.getZones() != null) {
                for (int i = 0; i < handler.getZones().length; ++i) {
                    this.shape.setZone(i, handler.getZones()[i]);
                }
            }
            this.shape.fixShape();
            if (this.shape.getBbox().getHeight() > 60.0) {
                double newHeight = this.shape.getBbox().getHeight() / 100.0;
                this.shape.scaleToHeight(newHeight);
            }
            this.simplifyShape();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.beforeFirst();
    }

    private void simplifyShape() {
    }

    public ShapeChar getCurrentShape() {
        return this.shape;
    }

    public boolean hasNext() {
        return this.pos == -1;
    }

    public boolean hasPrevious() {
        return this.pos == 1;
    }

    public void next() {
        if (this.hasNext()) {
            ++this.pos;
        }
    }

    public void previous() {
        if (this.hasPrevious()) {
            --this.pos;
        }
    }

    public void beforeFirst() {
        this.pos = -1;
    }

    public void afterLast() {
        this.pos = 1;
    }

    public String getCurrentCode() {
        return this.code;
    }

    public static String getCodeForFileName(String fname) {
        int stopIndex;
        String code = (fname = fname.toUpperCase()).substring(0, stopIndex = fname.indexOf(46));
        if ("ntrw".equals(code.toLowerCase())) {
            code = "nTrw";
        } else if ("nn".equals(code.toLowerCase())) {
            code = "nn";
        } else if (code.startsWith("US")) {
            int i;
            StringBuffer buff = new StringBuffer();
            buff.append("US");
            for (i = 2; i < code.length() && Character.isDigit(code.charAt(i)); ++i) {
            }
            buff.append(code.substring(2, i));
            buff.append(SVGSignSource.canonizeCode(code.substring(i)));
            code = buff.toString();
        } else {
            code = SVGSignSource.canonizeCode(code);
        }
        if (!HieroglyphsManager.isCorrectBasicMdcCode(code)) {
            code = null;
        }
        return code;
    }

    private String getCodeForURL(URL url) {
        String path = url.getPath();
        int id = path.lastIndexOf(47);
        return SVGSignSource.getCodeForFileName(path.substring(id + 1));
    }

    private static String canonizeCode(String code) {
        if (code.length() >= 2 && (code.charAt(1) == 'A' || code.charAt(1) == 'F')) {
            code = "" + code.charAt(0) + Character.toLowerCase(code.charAt(1)) + code.substring(2);
        }
        return code;
    }

    class SVGReader
    extends DefaultHandler {
        private String zoneName = null;
        private Rectangle2D[] zones = null;
        private Area area = new Area();
        private Stack styles = new Stack();

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Style parentStyle = null;
            if (!this.styles.isEmpty()) {
                parentStyle = (Style)this.styles.peek();
            }
            Style style = new Style(parentStyle, attributes);
            this.styles.push(style);
            if ("a".equals(localName)) {
                this.readAnchor(attributes);
            } else if ("rect".equals(localName)) {
                if (this.zoneName != null) {
                    this.defineZone(attributes);
                }
            } else if ("path".equals(localName)) {
                String d = attributes.getValue("", "d");
                GeneralPath subPath = this.parsePath(d);
                if (subPath != null) {
                    this.addPathToArea(style, subPath);
                }
            } else if ("polygon".equals(localName)) {
                GeneralPath subPath = new GeneralPath();
                String pointsDef = attributes.getValue("", "points");
                if (pointsDef != null) {
                    String[] ps = pointsDef.split(" ");
                    for (int i = 0; i < ps.length; ++i) {
                        String[] coords = ps[i].split(",");
                        if (coords.length != 2) {
                            return;
                        }
                        if (i == 0) {
                            subPath.moveTo(Float.parseFloat(coords[0]), Float.parseFloat(coords[1]));
                            continue;
                        }
                        subPath.lineTo(Float.parseFloat(coords[0]), Float.parseFloat(coords[1]));
                    }
                    if (!style.outlined) {
                        subPath.closePath();
                    }
                    this.addPathToArea(style, subPath);
                }
            }
        }

        private void addPathToArea(Style style, GeneralPath subPath) {
            if (style.outlined) {
                this.area.add(new Area(new BasicStroke(style.strokeWidth).createStrokedShape(subPath)));
            }
            if (style.filled) {
                if (style.blackPaint) {
                    this.area.add(new Area(subPath));
                } else {
                    this.area.subtract(new Area(subPath));
                }
            }
        }

        private void defineZone(Attributes attributes) {
            int zoneId = 0;
            if ("zone2".equals(this.zoneName)) {
                zoneId = 1;
            }
            if (this.zones == null) {
                this.zones = new Rectangle2D.Double[2];
            }
            double[] values = new double[4];
            String[] attrNames = new String[]{"x", "y", "width", "height"};
            for (int i = 0; i < 4; ++i) {
                try {
                    values[i] = Double.parseDouble(attributes.getValue("", attrNames[i]));
                    continue;
                }
                catch (NumberFormatException exception) {
                    exception.printStackTrace();
                }
            }
            this.zones[zoneId] = new Rectangle2D.Double(values[0], values[1], values[2], values[3]);
        }

        private void readAnchor(Attributes attributes) {
            this.zoneName = null;
            for (int i = 0; this.zoneName == null && i < attributes.getLength(); ++i) {
                if (!"title".equals(attributes.getLocalName(i))) continue;
                this.zoneName = attributes.getValue(i);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("a".equals(localName)) {
                this.zoneName = null;
            }
            this.styles.pop();
        }

        private GeneralPath parsePath(String pathData) {
            GeneralPath result = new GeneralPath();
            String[] l = this.pathToList(pathData);
            Point2D.Float currentPos = new Point2D.Float();
            Point2D.Float previousCubicControlPoint = null;
            Point2D.Float previousQuadricControlPoint = null;
            Point2D.Float pathStart = new Point2D.Float();
            float[] args = null;
            char command = 'M';
            for (int i = 0; i < l.length; ++i) {
                char firstChar = l[i].charAt(0);
                if (Character.isLetter(firstChar)) {
                    command = firstChar;
                } else {
                    --i;
                }
                boolean relative = Character.isLowerCase(command);
                switch (command) {
                    case 'M': 
                    case 'm': {
                        args = new float[]{Float.parseFloat(l[++i]), Float.parseFloat(l[++i])};
                        this.fixArgs(args, currentPos, relative);
                        result.moveTo(args[0], args[1]);
                        pathStart.setLocation(args[0], args[1]);
                        break;
                    }
                    case 'L': 
                    case 'l': {
                        args = new float[]{Float.parseFloat(l[i + 1]), Float.parseFloat(l[i + 2])};
                        i += 2;
                        this.fixArgs(args, currentPos, relative);
                        result.lineTo(args[0], args[1]);
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        args = new float[]{Float.parseFloat(l[i + 1]), Float.parseFloat(l[i + 2]), Float.parseFloat(l[i + 3]), Float.parseFloat(l[i + 4]), Float.parseFloat(l[i + 5]), Float.parseFloat(l[i + 6])};
                        i += 6;
                        this.fixArgs(args, currentPos, relative);
                        result.curveTo(args[0], args[1], args[2], args[3], args[4], args[5]);
                        previousCubicControlPoint = new Point2D.Float(args[2], args[3]);
                        break;
                    }
                    case 'S': 
                    case 's': {
                        float cy;
                        float cx;
                        args = new float[]{Float.parseFloat(l[i + 1]), Float.parseFloat(l[i + 2]), Float.parseFloat(l[i + 3]), Float.parseFloat(l[i + 4])};
                        i += 4;
                        this.fixArgs(args, currentPos, relative);
                        if (previousCubicControlPoint != null) {
                            cx = 2.0f * currentPos.x - previousCubicControlPoint.x;
                            cy = 2.0f * currentPos.y - previousCubicControlPoint.y;
                        } else {
                            cx = currentPos.x;
                            cy = currentPos.y;
                        }
                        result.curveTo(cx, cy, args[0], args[1], args[2], args[3]);
                        previousCubicControlPoint = new Point2D.Float(args[1], args[2]);
                        break;
                    }
                    case 'Q': 
                    case 'q': {
                        args = new float[]{Float.parseFloat(l[i + 1]), Float.parseFloat(l[i + 2]), Float.parseFloat(l[i + 3]), Float.parseFloat(l[i + 4])};
                        i += 4;
                        this.fixArgs(args, currentPos, relative);
                        result.quadTo(args[0], args[1], args[2], args[3]);
                        previousQuadricControlPoint = new Point2D.Float(args[0], args[1]);
                        break;
                    }
                    case 'T': 
                    case 't': {
                        float cy;
                        float cx;
                        args = new float[]{Float.parseFloat(l[i + 1]), Float.parseFloat(l[i + 2])};
                        i += 2;
                        this.fixArgs(args, currentPos, relative);
                        if (previousCubicControlPoint != null) {
                            cx = 2.0f * currentPos.x - previousQuadricControlPoint.x;
                            cy = 2.0f * currentPos.y - previousQuadricControlPoint.y;
                        } else {
                            cx = currentPos.x;
                            cy = currentPos.y;
                        }
                        result.quadTo(cx, cy, args[0], args[1]);
                        previousQuadricControlPoint = new Point2D.Float(cx, cy);
                        break;
                    }
                    case 'A': 
                    case 'a': {
                        float startx = currentPos.x;
                        float starty = currentPos.y;
                        float rx = Float.parseFloat(l[i + 1]);
                        float ry = Float.parseFloat(l[i + 2]);
                        float rot = Float.parseFloat(l[i + 3]);
                        float largeArc = Float.parseFloat(l[i + 4]);
                        float sweep = Float.parseFloat(l[i + 5]);
                        args = new float[]{Float.parseFloat(l[i + 6]), Float.parseFloat(l[i + 7])};
                        i += 7;
                        this.fixArgs(args, currentPos, relative);
                        this.drawArc(result, startx, starty, rx, ry, rot, largeArc, sweep, args[0], args[1]);
                        break;
                    }
                    case 'Z': 
                    case 'z': {
                        result.closePath();
                        currentPos.setLocation(pathStart);
                        break;
                    }
                    case 'h': {
                        float dx = Float.parseFloat(l[++i]);
                        result.lineTo(dx + currentPos.x, currentPos.y);
                        currentPos.x += dx;
                        break;
                    }
                    case 'H': {
                        float newx = Float.parseFloat(l[++i]);
                        result.lineTo(newx, currentPos.y);
                        currentPos.x = newx;
                        break;
                    }
                    case 'v': {
                        float dy = Float.parseFloat(l[++i]);
                        result.lineTo(currentPos.x, dy + currentPos.y);
                        currentPos.y += dy;
                        break;
                    }
                    case 'V': {
                        float newy = Float.parseFloat(l[++i]);
                        result.lineTo(currentPos.x, newy);
                        currentPos.y = newy;
                        break;
                    }
                    default: {
                        System.err.println("unknown code" + l[i]);
                        return null;
                    }
                }
                if (Character.toLowerCase(command) != 'c' && Character.toLowerCase(command) != 's') {
                    previousCubicControlPoint = null;
                }
                if (Character.toLowerCase(command) == 'q' || Character.toLowerCase(command) == 't') continue;
                previousQuadricControlPoint = null;
            }
            return result;
        }

        private void drawArc(GeneralPath result, float startx, float starty, float rx, float ry, float rot, float largeArc, float sweep, float endx, float endy) {
            result.lineTo(endx, endy);
        }

        private String[] pathToList(String pathData) {
            String real = "[-+]?(?:\\d*\\.\\d+|\\d+\\.?)(?:[eE][-+]?\\d+)?";
            String keys = "[aAtTQqSsCcVvHhLlZzMm]";
            String command = "(" + real + "|" + keys + ")";
            Pattern p = Pattern.compile(command);
            Matcher m = p.matcher(pathData);
            ArrayList<String> result = new ArrayList<String>();
            while (m.find()) {
                result.add(m.group());
            }
            return result.toArray(new String[result.size()]);
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (publicId.indexOf(" SVG ") != -1) {
                return new InputSource(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
            }
            try {
                return super.resolveEntity(publicId, systemId);
            }
            catch (Exception e) {
                return null;
            }
        }

        public GeneralPath getGeneralPath() {
            GeneralPath shape = new GeneralPath();
            shape.append(this.area.getPathIterator(null), false);
            return shape;
        }

        public Rectangle2D[] getZones() {
            return this.zones;
        }

        private void fixArgs(float[] args, Point2D.Float current, boolean relative) {
            int i = 0;
            for (i = 0; i < args.length; i += 2) {
                if (!relative) continue;
                args[i] = args[i] + current.x;
                args[i + 1] = args[i + 1] + current.y;
            }
            current.setLocation(args[i - 2], args[i - 1]);
        }
    }

    static class Style {
        boolean blackPaint = true;
        boolean filled = true;
        boolean outlined = false;
        float strokeWidth = 0.0f;

        public Style() {
        }

        public Style(Style parent) {
            if (parent != null) {
                this.blackPaint = parent.blackPaint;
                this.outlined = parent.outlined;
                this.filled = parent.filled;
                this.strokeWidth = parent.strokeWidth;
            }
        }

        public Style(Style parent, Attributes attributes) {
            this(parent);
            String styleDef = attributes.getValue("", "style");
            if (styleDef != null) {
                this.parseStyleDef(styleDef);
            }
            this.parseAttributes(attributes);
        }

        private void parseAttributes(Attributes attributes) {
            String fillColorAttr = attributes.getValue("", "fill");
            if (fillColorAttr != null) {
                if ("none".equals(fillColorAttr)) {
                    this.filled = false;
                } else {
                    this.blackPaint = false;
                    if (fillColorAttr.startsWith("#000000")) {
                        this.blackPaint = true;
                    }
                    if ("black".equals(fillColorAttr)) {
                        this.blackPaint = true;
                    }
                    if (fillColorAttr.startsWith("rgb(0,0,0")) {
                        this.blackPaint = true;
                    }
                }
            }
            if ("none".equals(attributes.getValue("", "stroke"))) {
                this.outlined = false;
            } else if (attributes.getValue("", "stroke") != null) {
                this.outlined = true;
            }
            if (attributes.getValue("stroke-width") != null) {
                String w = attributes.getValue("stroke-width");
                int end = w.length() - 1;
                if (end >= 0) {
                    while (end >= 0 && !Character.isDigit(w.charAt(end))) {
                        --end;
                    }
                    this.strokeWidth = Float.parseFloat(w.substring(0, end + 1));
                } else {
                    this.strokeWidth = 0.0f;
                }
            }
        }

        private void parseStyleDef(String styleDef) {
            if (styleDef == null) {
                return;
            }
            if (styleDef.indexOf("fill:none") != -1) {
                this.filled = false;
            } else if (styleDef.indexOf("fill:") != -1) {
                this.filled = true;
                this.blackPaint = styleDef.indexOf("fill:#000000") != -1 || styleDef.indexOf("fill:rgb(0,0,0)") != -1 || styleDef.indexOf("fill:black") != -1;
            }
            if (styleDef.indexOf("stroke:none") != -1) {
                this.outlined = false;
            } else if (styleDef.indexOf("stroke:") != -1) {
                this.outlined = true;
            }
            int i = styleDef.indexOf("stroke-width:");
            if (i != -1) {
                int end;
                i = styleDef.indexOf(58, i);
                if ((end = styleDef.indexOf(59, ++i)) == -1) {
                    end = styleDef.length() - 1;
                }
                while (!Character.isDigit(styleDef.charAt(end))) {
                    --end;
                }
                String widthDef = styleDef.substring(i, end + 1);
                this.strokeWidth = Float.parseFloat(widthDef);
            }
        }
    }
}

