/*
 * Decompiled with CFR 0.152.
 */
package jsesh.externalFonts.old;

import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;

public class ExternalFontTableModel
extends AbstractTableModel {
    private static String[] fcolumnNames = new String[]{"glyph position", "image", "mdc code"};
    private ArrayList rows = new ArrayList();

    public void clear() {
        this.rows.clear();
        this.fireTableStructureChanged();
    }

    public int getColumnCount() {
        return 3;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public static String[] getColumnNames() {
        return fcolumnNames;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        FontTableGlyphModel glyphModel = (FontTableGlyphModel)this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return glyphModel.getIndex();
            }
            case 1: {
                return glyphModel.getImage();
            }
            case 2: {
                return glyphModel.getMdc();
            }
        }
        return null;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        FontTableGlyphModel glyphModel = (FontTableGlyphModel)this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                glyphModel.setIndex((Integer)aValue);
            }
            case 1: {
                glyphModel.setImage((ImageIcon)aValue);
            }
            case 2: {
                glyphModel.setMdc((String)aValue);
            }
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return ImageIcon.class;
            }
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    public void add(int charCode, ImageIcon image, String mdc) {
        this.rows.add(new FontTableGlyphModel(new Integer(charCode), image, mdc));
        this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
    }

    public static class FontTableGlyphModel {
        private Integer index;
        private String mdc;
        private ImageIcon image;

        public FontTableGlyphModel(Integer index, ImageIcon image, String mdc) {
            this.index = index;
            this.mdc = mdc;
            this.image = image;
        }

        public ImageIcon getImage() {
            return this.image;
        }

        public void setImage(ImageIcon image) {
            this.image = image;
        }

        public Integer getIndex() {
            return this.index;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        public String getMdc() {
            return this.mdc;
        }

        public void setMdc(String mdc) {
            this.mdc = mdc;
        }
    }
}

