/*
 * Decompiled with CFR 0.152.
 */
package jsesh.fontEditor.appli;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import jsesh.fontEditor.gui.SimpleDrawBarreDeCommande;
import jsesh.fontEditor.gui.SimpleDrawView;
import jsesh.fontEditor.gui.SimpleDrawViewControl;
import jsesh.fontEditor.gui.ToolContext;
import jsesh.fontEditor.model.Cercle;
import jsesh.fontEditor.model.GlyphModel;
import jsesh.fontEditor.model.Point;
import jsesh.fontEditor.model.Segment;

public class SimpleDrawAppli {
    private ToolContext contexte;
    private JFrame frame = new JFrame("SimpleDraw 1");
    private GlyphModel dessin = new GlyphModel();
    private JMenuBar menu;
    private SimpleDrawView vue = new SimpleDrawView(this.dessin);
    private SimpleDrawView petiteVue = new SimpleDrawView(this.dessin);
    private SimpleDrawViewControl controle;
    private SimpleDrawBarreDeCommande barre;

    private void creerMenus() {
        this.menu = new JMenuBar();
        JMenu edit = new JMenu("Edit");
        edit.add(new AbstractAction("undo"){

            public void actionPerformed(ActionEvent e) {
                SimpleDrawAppli.this.contexte.undo();
            }
        });
        edit.add(new AbstractAction("redo"){

            public void actionPerformed(ActionEvent e) {
                SimpleDrawAppli.this.contexte.redo();
            }
        });
        JMenu voir = new JMenu("Vue");
        voir.add(new AbstractAction("Zoom in"){

            public void actionPerformed(ActionEvent e) {
                SimpleDrawAppli.this.vue.setScale(SimpleDrawAppli.this.vue.getScale() * 2.0);
            }
        });
        voir.add(new AbstractAction("Zoom out"){

            public void actionPerformed(ActionEvent e) {
                SimpleDrawAppli.this.vue.setScale(SimpleDrawAppli.this.vue.getScale() / 2.0);
            }
        });
        voir.add(new AbstractAction("Zoom 100%"){

            public void actionPerformed(ActionEvent e) {
                SimpleDrawAppli.this.vue.setScale(1.0);
            }
        });
        this.menu.add(edit);
        this.menu.add(voir);
        this.frame.setJMenuBar(this.menu);
    }

    public SimpleDrawAppli() {
        this.contexte = new ToolContext(this.vue);
        this.controle = new SimpleDrawViewControl(this.contexte);
        this.barre = new SimpleDrawBarreDeCommande(this.controle);
        this.creerMenus();
        this.petiteVue.setSize(100, 100);
        this.petiteVue.setScale(0.25);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)this.barre, "West");
        this.frame.getContentPane().add((Component)this.vue, "Center");
        this.frame.getContentPane().add((Component)this.petiteVue, "East");
        this.frame.pack();
        this.frame.setVisible(true);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    public static void main(String[] args) {
        SimpleDrawAppli appli = new SimpleDrawAppli();
        appli.dessin.add(new Cercle(new Point(100.0, 100.0), 100.0));
        appli.dessin.add(new Cercle(new Point(10.0, 10.0), 10.0));
        appli.dessin.add(new Cercle(new Point(0.5, 0.5), 15.2));
        appli.dessin.add(new Segment(new Point(10.0, 0.0), new Point(100.0, 40.0)));
    }
}

