/*
 * Decompiled with CFR 0.152.
 */
package jsesh.graphicExport;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.NumberFormatter;
import jsesh.graphicExport.ExportOptionPanel;
import jsesh.graphicExport.LabeledField;
import jsesh.mdc.model.AlphabeticText;
import jsesh.mdc.model.LineBreak;
import jsesh.mdc.model.ModelElement;
import jsesh.mdc.model.ModelElementAdapter;
import jsesh.mdc.model.PageBreak;
import jsesh.mdc.model.TopItemList;
import jsesh.mdcDisplayer.draw.ViewDrawer;
import jsesh.mdcDisplayer.layout.SimpleViewBuilder;
import jsesh.mdcDisplayer.mdcView.MDCView;
import jsesh.mdcDisplayer.preferences.DrawingSpecifications;
import jsesh.swingUtils.GraphicsUtils;

public class HTMLExporter {
    private boolean respectPages;
    private File directory;
    private String baseName;
    private String title;
    private Color backgroundColor = new Color(0, 0, 0, 0);
    private int lineHeight;
    private int pictureMargin;
    private boolean htmlSpecialProtected;
    private boolean generatePictureSize;
    private boolean centerPictures;
    private int pictureScale;
    public static final int SPACE = 0;
    public static final int BREAK = 1;
    public static final int PARAGRAPH = 2;
    private int newLinesReplacement;
    private DrawingSpecifications drawingSpecifications;

    public HTMLExporter() {
        this.setDefaults();
    }

    public void setDefaults() {
        this.directory = new File(".");
        this.baseName = "egyptian";
        this.respectPages = true;
        this.lineHeight = 30;
        this.pictureMargin = 0;
        this.htmlSpecialProtected = true;
        this.newLinesReplacement = 2;
        this.generatePictureSize = true;
        this.pictureScale = 100;
        this.centerPictures = true;
        this.setDrawingSpecifications(new DrawingSpecifications());
    }

    public void setDrawingSpecifications(DrawingSpecifications drawingSpecifications) {
        this.drawingSpecifications = drawingSpecifications.copy();
        this.drawingSpecifications.setTopMargin(0.0f);
        this.drawingSpecifications.setLeftMargin(0.0f);
    }

    public DrawingSpecifications getDrawingSpecifications() {
        return this.drawingSpecifications;
    }

    public ExportOptionPanel getOptionPanel(Component parent, String title) {
        return new OptionPanel(parent, title);
    }

    public void exportModel(TopItemList model) {
        this.directory.mkdirs();
        HTMLExporterAux visitor = new HTMLExporterAux();
        model.accept(visitor);
    }

    public String getBaseName() {
        return this.baseName;
    }

    public File getDirectory() {
        return this.directory;
    }

    public boolean isRespectPages() {
        return this.respectPages;
    }

    public String getTitle() {
        return this.title;
    }

    public void setBaseName(String string) {
        this.baseName = string;
    }

    public void setDirectory(File file) {
        this.directory = file;
    }

    public void setRespectPages(boolean b) {
        this.respectPages = b;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public void setLineHeight(int i) {
        this.lineHeight = i;
    }

    public int getPictureMargin() {
        return this.pictureMargin;
    }

    public void setPictureMargin(int pictureMargin) {
        this.pictureMargin = pictureMargin;
    }

    public boolean isGeneratePictureSize() {
        return this.generatePictureSize;
    }

    public void setGeneratePictureSize(boolean generatePictureSize) {
        this.generatePictureSize = generatePictureSize;
    }

    public boolean isCenterPictures() {
        return this.centerPictures;
    }

    public void setCenterPictures(boolean centerPictures) {
        this.centerPictures = centerPictures;
    }

    public int getPictureScale() {
        return this.pictureScale;
    }

    public void setPictureScale(int pictureScale) {
        this.pictureScale = pictureScale;
    }

    class OptionPanel
    extends ExportOptionPanel
    implements ActionListener {
        JTextField baseNameField;
        JFormattedTextField directoryField;
        JCheckBox respectPageField;
        JTextField titleField;
        JFormattedTextField lineHeightField;
        JFormattedTextField pictureMarginField;
        JFormattedTextField pictureScaleField;
        JCheckBox protectSpecialField;
        JCheckBox generatePictureSizeField;
        JCheckBox centerPictureField;
        JComboBox newLineReplacementField;
        JButton browse;

        private OptionPanel(Component parent, String paneltitle) {
            super(parent, paneltitle);
            this.titleField = new JTextField(HTMLExporter.this.title, 40);
            this.titleField.setToolTipText("Title of the html document");
            this.directoryField = new JFormattedTextField();
            this.directoryField.setValue(HTMLExporter.this.directory);
            this.directoryField.setColumns(40);
            this.browse = new JButton("Browse");
            this.browse.addActionListener(this);
            this.baseNameField = new JTextField(HTMLExporter.this.baseName, 20);
            this.baseNameField.setToolTipText("each html file name will start with this string.");
            this.respectPageField = new JCheckBox("Respect pages", HTMLExporter.this.respectPages);
            this.respectPageField.setToolTipText("Output one html file for each manuel de codage page");
            this.lineHeightField = new JFormattedTextField();
            this.lineHeightField.setValue(new Integer(HTMLExporter.this.lineHeight));
            this.lineHeightField.setToolTipText("height of a typical line of hieroglyphs");
            this.pictureMarginField = new JFormattedTextField();
            this.pictureMarginField.setValue(new Integer(HTMLExporter.this.pictureMargin));
            this.pictureMarginField.setToolTipText("Top and bottom margin around pictures, expressed in pixels.");
            this.protectSpecialField = new JCheckBox("Protect html specials");
            this.protectSpecialField.setToolTipText("If checked, all special HTML characters (a, <, >) will be escaped, and printed as normal char in HTML");
            this.protectSpecialField.setSelected(HTMLExporter.this.htmlSpecialProtected);
            this.newLineReplacementField = new JComboBox<String>(new String[]{"new line", "<br>", "<p>"});
            this.newLineReplacementField.setSelectedIndex(HTMLExporter.this.newLinesReplacement);
            NumberFormatter formatter = new NumberFormatter(new DecimalFormat("###"));
            this.pictureScaleField = new JFormattedTextField(formatter);
            this.pictureScaleField.setValue(new Integer(HTMLExporter.this.pictureScale));
            this.pictureScaleField.setColumns(4);
            this.pictureScaleField.setToolTipText("Picture scale in HTML output.\nNormally 100%; but can be set to a smaller value if one wants to print the page.\nYou can for example, set picture height to 300 and picture scale to 10");
            this.generatePictureSizeField = new JCheckBox("Set picture size in HTML");
            this.generatePictureSizeField.setToolTipText("If checked, the HTML code IMG tags will contain WIDTH=... HEIGHT=... declaration\n");
            this.generatePictureSizeField.setSelected(HTMLExporter.this.generatePictureSize);
            this.centerPictureField = new JCheckBox("Center pictures vertically");
            this.centerPictureField.setToolTipText("If checked, the HTML code IMG tags will align='center' declaration\n");
            this.centerPictureField.setSelected(HTMLExporter.this.centerPictures);
            GridBagLayout layout = new GridBagLayout();
            this.setLayout(layout);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.insets = new Insets(3, 3, 3, 3);
            c.gridwidth = 1;
            c.anchor = 17;
            this.add((Component)new LabeledField("document title", this.titleField), c);
            ++c.gridy;
            this.add((Component)new LabeledField("directory", this.directoryField), c);
            c.gridx = 1;
            this.add((Component)this.browse, c);
            c.gridx = 0;
            ++c.gridy;
            this.add((Component)new LabeledField("base name", this.baseNameField), c);
            ++c.gridy;
            this.add((Component)this.respectPageField, c);
            ++c.gridy;
            this.add((Component)new LabeledField("line height", this.lineHeightField), c);
            ++c.gridy;
            Insets oldInset = c.insets;
            c.insets = new Insets(20, 0, 0, 0);
            this.add((Component)new JLabel("Advanced settings:"), c);
            c.insets = oldInset;
            ++c.gridy;
            this.add((Component)new LabeledField("Pictures vertical margin", this.pictureMarginField), c);
            ++c.gridy;
            this.add((Component)new LabeledField("Pictures scales", this.pictureScaleField), c);
            ++c.gridy;
            this.add((Component)this.protectSpecialField, c);
            ++c.gridy;
            this.add((Component)this.generatePictureSizeField, c);
            ++c.gridy;
            this.add((Component)this.centerPictureField, c);
            ++c.gridy;
            this.add((Component)new LabeledField("Html replacement for newlines", this.newLineReplacementField), c);
        }

        public void setOptions() {
            HTMLExporter.this.directory = new File(this.directoryField.getText());
            HTMLExporter.this.baseName = this.baseNameField.getText();
            HTMLExporter.this.lineHeight = (Integer)this.lineHeightField.getValue();
            HTMLExporter.this.title = this.titleField.getText();
            HTMLExporter.this.respectPages = this.respectPageField.isSelected();
            HTMLExporter.this.htmlSpecialProtected = this.protectSpecialField.isSelected();
            HTMLExporter.this.newLinesReplacement = this.newLineReplacementField.getSelectedIndex();
            HTMLExporter.this.generatePictureSize = this.generatePictureSizeField.isSelected();
            HTMLExporter.this.centerPictures = this.centerPictureField.isSelected();
            HTMLExporter.this.pictureScale = ((Number)this.pictureScaleField.getValue()).intValue();
            HTMLExporter.this.pictureMargin = (Integer)this.pictureMarginField.getValue();
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.browse) {
                JFileChooser chooser = new JFileChooser(HTMLExporter.this.directory);
                chooser.setFileSelectionMode(1);
                chooser.setApproveButtonText("Choose Directory");
                chooser.setFileFilter(new FileFilter(){

                    public String getDescription() {
                        return "directory for the html files";
                    }

                    public boolean accept(File f) {
                        return !f.exists() || f.isDirectory();
                    }
                });
                int res = chooser.showOpenDialog(this);
                if (res == 0) {
                    this.directoryField.setValue(chooser.getSelectedFile());
                }
            }
        }
    }

    private class HTMLExporterAux
    extends ModelElementAdapter {
        ArrayList elements;
        Writer writer;
        int imageNumber = 0;
        int pageNumber = 0;

        private HTMLExporterAux() {
        }

        public void visitTopItemList(TopItemList t) {
            try {
                this.elements = null;
                this.startPage();
                for (int i = 0; i < t.getNumberOfChildren(); ++i) {
                    t.getChildAt(i).accept(this);
                }
                this.closePage(false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void visitAlphabeticText(AlphabeticText t) {
            this.flushElements();
            switch (t.getScriptCode()) {
                case 'b': {
                    this.write("<b>");
                    break;
                }
                case 'i': {
                    this.write("<i>");
                    break;
                }
                case 't': {
                    this.write("<font face=\"MDCTranslitLC,TransliterationItalic\">");
                    break;
                }
                case '+': {
                    this.write("<!--");
                }
            }
            if (HTMLExporter.this.htmlSpecialProtected) {
                this.write(t.getText().toString().replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
            } else {
                this.write(t.getText());
            }
            switch (t.getScriptCode()) {
                case 'b': {
                    this.write("</b>");
                    break;
                }
                case 'i': {
                    this.write("</i>");
                    break;
                }
                case 't': {
                    this.write("</font>");
                    break;
                }
                case '+': {
                    this.write("-->");
                }
            }
        }

        public void visitPageBreak(PageBreak b) {
            this.flushElements();
            if (HTMLExporter.this.respectPages) {
                this.closePage(true);
                try {
                    this.startPage();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.write("<br/>\n<hrule/>\n");
            }
        }

        public void visitLineBreak(LineBreak b) {
            this.flushElements();
            switch (HTMLExporter.this.newLinesReplacement) {
                case 0: {
                    this.writeln("");
                    break;
                }
                case 1: {
                    this.writeln("<br/>");
                    break;
                }
                case 2: {
                    this.writeln("<p>");
                }
            }
        }

        public void visitDefault(ModelElement t) {
            this.getElements().add(t);
        }

        private void write(String s) {
            try {
                this.writer.write(s);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void writeln(String s) {
            this.write(s);
            this.write("\n");
        }

        private List getElements() {
            if (this.elements == null) {
                this.elements = new ArrayList();
            }
            return this.elements;
        }

        private void flushElements() {
            if (this.elements != null) {
                TopItemList smallModel = new TopItemList();
                smallModel.addAll(this.elements);
                SimpleViewBuilder builder = new SimpleViewBuilder();
                double scale = (double)HTMLExporter.this.lineHeight / (double)HTMLExporter.this.drawingSpecifications.getMaxCadratHeight();
                MDCView view = builder.buildView(smallModel, HTMLExporter.this.drawingSpecifications);
                if (view.getWidth() == 0.0f || view.getHeight() == 0.0f) {
                    return;
                }
                ViewDrawer drawer = new ViewDrawer();
                BufferedImage image = new BufferedImage((int)Math.ceil((double)view.getWidth() * scale + 1.0), (int)Math.ceil((double)view.getHeight() * scale + (double)(2 * HTMLExporter.this.pictureMargin) + 1.0), 2);
                Graphics2D g = image.createGraphics();
                GraphicsUtils.antialias(g);
                g.setBackground(HTMLExporter.this.backgroundColor);
                g.clearRect(0, 0, image.getWidth(), image.getHeight());
                g.translate(1, 1 + HTMLExporter.this.pictureMargin);
                g.scale(scale, scale);
                drawer.draw(g, view, HTMLExporter.this.drawingSpecifications);
                g.dispose();
                File fic = this.getImageFile(this.imageNumber);
                try {
                    ImageIO.write((RenderedImage)image, "png", fic);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                String center = "";
                if (HTMLExporter.this.centerPictures) {
                    center = " align='center' ";
                }
                if (HTMLExporter.this.pictureScale != 100) {
                    this.write("<img " + center + " src='" + fic.getName() + "' width='" + HTMLExporter.this.pictureScale + "%' height='" + HTMLExporter.this.pictureScale + "%'>");
                } else if (HTMLExporter.this.generatePictureSize) {
                    this.write("<img " + center + " src='" + fic.getName() + "' width='" + image.getWidth() + "' height='" + image.getHeight() + "'>");
                } else {
                    this.write("<img " + center + "src='" + fic.getName() + "'>");
                }
                ++this.imageNumber;
                image.flush();
                this.elements = null;
            }
        }

        private File getImageFile(int i) {
            return new File(HTMLExporter.this.directory, "img" + i + ".png");
        }

        private String getFileName(int i) {
            return HTMLExporter.this.baseName + this.formatNum(i) + ".html";
        }

        private void startPage() throws IOException {
            ++this.pageNumber;
            this.writer = new FileWriter(new File(HTMLExporter.this.directory, this.getFileName(this.pageNumber)));
            this.outPutHeader();
        }

        private String formatNum(int i) {
            return "" + i;
        }

        private void closePage(boolean hasNext) {
            this.outPutFooter(hasNext);
            try {
                this.writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void outPutHeader() {
            this.flushElements();
            this.writeln("<html>");
            this.writeln("<head>");
            this.writeln("<title>" + HTMLExporter.this.title + "(" + this.pageNumber + ")</title>");
            this.writeln("</head>");
            this.writeln("<body>");
            if (this.pageNumber == 1 && HTMLExporter.this.title != null) {
                this.writeln("<h1>" + HTMLExporter.this.title + "</h1>");
            }
        }

        private void outPutFooter(boolean hasNext) {
            if (hasNext) {
                this.outputNextLink(this.pageNumber + 1);
            }
            this.writeln("</body>");
            this.writeln("</html>");
        }

        private void outputNextLink(int num) {
            this.writeln("<p>");
            this.write("<a href='" + this.getFileName(num) + "'> next </a>");
            this.writeln("</p>");
        }
    }
}

