/*
 * Decompiled with CFR 0.152.
 */
package jsesh.graphicExport;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.rtf.RtfWriter2;
import com.lowagie.text.rtf.style.RtfFont;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import jsesh.graphicExport.RTFExportPreferences;
import jsesh.graphicExport.TopItemSimpleDrawer;
import jsesh.graphics.generic.RandomAccessByteArray;
import jsesh.graphics.wmfexport.WMFGraphics2D;
import jsesh.mdc.model.AlphabeticText;
import jsesh.mdc.model.LineBreak;
import jsesh.mdc.model.ModelElementDeepAdapter;
import jsesh.mdc.model.PageBreak;
import jsesh.mdc.model.TopItem;
import jsesh.mdc.model.TopItemList;
import jsesh.mdcDisplayer.layout.ViewBuilder;
import jsesh.mdcDisplayer.preferences.DrawingSpecifications;
import jsesh.utils.TranslitterationUtilities;

public class RTFExporter {
    private ViewBuilder viewBuilder;
    private DrawingSpecifications drawingSpecifications;
    private RTFExportPreferences rtfPreferences = new RTFExportPreferences();
    private Document rtfDocument;

    public void ExportModelTo(TopItemList model, OutputStream outputStream) {
        this.rtfDocument = new Document();
        RtfWriter2.getInstance((Document)this.rtfDocument, (OutputStream)outputStream);
        this.rtfDocument.open();
        if (this.rtfPreferences.getExportGranularity().equals(RTFExportPreferences.RTFExportGranularity.ONE_LARGE_PICTURE)) {
            this.exportAsPicture(model);
        } else {
            RTFExporterAux aux = new RTFExporterAux();
            model.accept(aux);
            aux.close();
        }
        this.rtfDocument.close();
    }

    private void exportAsPicture(TopItemList model) {
        RandomAccessByteArray b = new RandomAccessByteArray();
        WMFSimpleDrawer simpleDrawer = this.buildSimpleDrawer(b);
        simpleDrawer.drawTopItemList(model);
        try {
            Image img = Image.getInstance((byte[])b.getByteArray());
            this.rtfDocument.add((Element)img);
        }
        catch (BadElementException exception) {
            exception.printStackTrace();
        }
        catch (MalformedURLException exception) {
            exception.printStackTrace();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        catch (DocumentException exception) {
            exception.printStackTrace();
        }
    }

    public void setViewBuilder(ViewBuilder viewBuilder) {
        this.viewBuilder = viewBuilder;
    }

    public void setDrawingSpecifications(DrawingSpecifications drawingSpecifications) {
        this.drawingSpecifications = drawingSpecifications.copy();
        this.drawingSpecifications.setLeftMargin(1.0f);
        this.drawingSpecifications.setTopMargin(1.0f);
    }

    public void setRtfPreferences(RTFExportPreferences rtfPreferences) {
        this.rtfPreferences = rtfPreferences;
    }

    WMFSimpleDrawer buildSimpleDrawer(RandomAccessByteArray b) {
        return new WMFSimpleDrawer(this.viewBuilder, (double)this.rtfPreferences.getCadratHeight() * 1.83, b);
    }

    private class WMFSimpleDrawer
    extends TopItemSimpleDrawer {
        RandomAccessByteArray b;

        protected WMFSimpleDrawer(ViewBuilder viewBuilder, double cadratHeight, RandomAccessByteArray b) {
            super(viewBuilder, RTFExporter.this.drawingSpecifications, cadratHeight);
            this.b = b;
        }

        protected WMFSimpleDrawer(ViewBuilder viewBuilder, double cadratHeight) {
            super(viewBuilder, RTFExporter.this.drawingSpecifications, cadratHeight);
        }

        protected Graphics2D buildGraphics() {
            WMFGraphics2D g = null;
            try {
                g = new WMFGraphics2D(this.b, new Dimension((int)Math.ceil(this.getScaledWidth()), (int)Math.ceil(this.getScaledHeight())));
                g.setPrecision(1.0);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return g;
        }
    }

    public class RTFExporterAux
    extends ModelElementDeepAdapter {
        static final String TIMES = "Times New Roman";
        private RtfFont romanFont = new RtfFont("Times New Roman", 12.0f);
        private RtfFont boldFont = new RtfFont("Times New Roman", 12.0f, 1);
        private RtfFont italicFont = new RtfFont("Times New Roman", 12.0f, 2);
        private RtfFont translitFont = new RtfFont("MDCTranslitLC", 12.0f);
        private Paragraph currentParagraph = null;
        TopItemList toDraw = null;

        public void visitTopItemList(TopItemList t) {
            for (int i = 0; i < t.getNumberOfChildren(); ++i) {
                t.getTopItemAt(i).accept(this);
            }
        }

        public void visitAlphabeticText(AlphabeticText t) {
            this.flushElements();
            RtfFont f = null;
            String text = t.getText();
            switch (t.getScriptCode()) {
                case 'l': {
                    f = this.romanFont;
                    break;
                }
                case 'b': {
                    f = this.boldFont;
                    break;
                }
                case 'i': {
                    f = this.italicFont;
                    break;
                }
                case 't': {
                    f = this.translitFont;
                    text = TranslitterationUtilities.toLowerCase(text);
                    break;
                }
                default: {
                    return;
                }
            }
            this.write(text, f);
        }

        public void visitLineBreak(LineBreak b) {
            this.flushElements();
            this.flushParagraph();
        }

        public void visitPageBreak(PageBreak b) {
            this.flushElements();
            this.flushParagraph();
        }

        public void visitTopItem(TopItem t) {
            if (RTFExporter.this.rtfPreferences.getExportGranularity().equals(RTFExportPreferences.RTFExportGranularity.GROUPED_CADRATS)) {
                if (this.toDraw == null) {
                    this.toDraw = new TopItemList();
                }
                this.toDraw.addTopItem((TopItem)t.deepCopy());
            } else {
                this.drawElement(t);
            }
        }

        private void flushElements() {
            if (RTFExporter.this.rtfPreferences.getExportGranularity().equals(RTFExportPreferences.RTFExportGranularity.GROUPED_CADRATS) && this.toDraw != null) {
                try {
                    RandomAccessByteArray b = new RandomAccessByteArray();
                    WMFSimpleDrawer simpleDrawer = RTFExporter.this.buildSimpleDrawer(b);
                    simpleDrawer.drawTopItemList(this.toDraw);
                    Image img = Image.getInstance((byte[])b.getByteArray());
                    float deltay = 0.0f;
                    if (simpleDrawer.getCurrentView().getFirstSubView() != null) {
                        deltay = (float)simpleDrawer.getCurrentView().getFirstSubView().getDeltaBaseY();
                    }
                    this.getCurrentParagraph().add((Object)new Chunk(img, 0.0f, -6.0f + deltay, true));
                }
                catch (BadElementException exception) {
                    exception.printStackTrace();
                }
                catch (MalformedURLException exception) {
                    exception.printStackTrace();
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
                this.toDraw = null;
            }
        }

        public Paragraph getCurrentParagraph() {
            if (this.currentParagraph == null) {
                this.currentParagraph = new Paragraph();
            }
            return this.currentParagraph;
        }

        public void close() {
            this.flushElements();
            this.flushParagraph();
        }

        private void flushParagraph() {
            try {
                RTFExporter.this.rtfDocument.add((Element)this.getCurrentParagraph());
            }
            catch (DocumentException exception) {
                exception.printStackTrace();
            }
            this.currentParagraph = null;
        }

        private void write(String text, RtfFont f) {
            this.getCurrentParagraph().add((Object)new Chunk(text, (Font)f));
        }

        private void drawElement(TopItem t) {
            RandomAccessByteArray b = new RandomAccessByteArray();
            WMFSimpleDrawer simpleDrawer = RTFExporter.this.buildSimpleDrawer(b);
            simpleDrawer.drawElement(t);
            try {
                Image img = Image.getInstance((byte[])b.getByteArray());
                float deltay = 0.0f;
                if (simpleDrawer.getCurrentView().getFirstSubView() != null) {
                    deltay = (float)simpleDrawer.getCurrentView().getFirstSubView().getDeltaBaseY();
                }
                this.getCurrentParagraph().add((Object)new Chunk(img, 0.0f, -6.0f + deltay, true));
            }
            catch (BadElementException e) {
                e.printStackTrace();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

