/*
 * Decompiled with CFR 0.152.
 */
package jsesh.graphicExport;

import java.awt.Graphics2D;
import jsesh.mdc.model.TopItem;
import jsesh.mdc.model.TopItemList;
import jsesh.mdcDisplayer.draw.ViewDrawer;
import jsesh.mdcDisplayer.layout.ViewBuilder;
import jsesh.mdcDisplayer.mdcView.MDCView;
import jsesh.mdcDisplayer.preferences.DrawingSpecifications;

public abstract class TopItemSimpleDrawer {
    private MDCView currentView;
    private float scaledWidth;
    private float scaledHeight;
    private double cadratHeight;
    private ViewBuilder viewBuilder;
    private DrawingSpecifications drawingSpecifications;

    protected TopItemSimpleDrawer(ViewBuilder viewBuilder, DrawingSpecifications drawingSpecifications, double cadratHeight) {
        this.viewBuilder = viewBuilder;
        this.drawingSpecifications = drawingSpecifications;
        this.cadratHeight = cadratHeight;
    }

    public void drawTopItemList(TopItemList list) {
        double scale = this.getCadratHeight() / (double)this.getDrawingSpecifications().getMaxCadratHeight();
        this.currentView = this.getBuilder().buildView(list, this.getDrawingSpecifications());
        if (this.currentView.getWidth() == 0.0f || this.currentView.getHeight() == 0.0f) {
            return;
        }
        ViewDrawer drawer = new ViewDrawer();
        this.scaledWidth = (float)((double)this.currentView.getWidth() * scale);
        this.scaledHeight = (float)((double)this.currentView.getHeight() * scale);
        Graphics2D g = this.buildGraphics();
        g.setColor(this.getDrawingSpecifications().getBlackColor());
        g.setBackground(this.getDrawingSpecifications().getBackgroundColor());
        g.scale(scale, scale);
        drawer.draw(g, this.currentView, this.getDrawingSpecifications());
        g.dispose();
    }

    public void drawElement(TopItem elt) {
        TopItemList smallModel = new TopItemList();
        smallModel.addTopItem((TopItem)elt.deepCopy());
        this.drawTopItemList(smallModel);
    }

    protected abstract Graphics2D buildGraphics();

    public ViewBuilder getBuilder() {
        return this.viewBuilder;
    }

    public DrawingSpecifications getDrawingSpecifications() {
        return this.drawingSpecifications;
    }

    public void setCadratHeight(double cadratHeight) {
        this.cadratHeight = cadratHeight;
    }

    public double getCadratHeight() {
        return this.cadratHeight;
    }

    public MDCView getCurrentView() {
        return this.currentView;
    }

    public float getScaledHeight() {
        return this.scaledHeight;
    }

    public float getScaledWidth() {
        return this.scaledWidth;
    }
}

