/*
 * Decompiled with CFR 0.152.
 */
package jsesh.graphicExport;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import jsesh.graphicExport.BaseGraphics2DFactory;
import jsesh.graphicExport.ExportData;
import jsesh.graphicExport.SelectionExporter;
import jsesh.graphics.generic.BaseGraphics2D;
import jsesh.graphics.wmfexport.WMFGraphics2D;

public class WMFExporter
implements BaseGraphics2DFactory {
    private File exportFile = new File(".");
    private Component frame = null;
    private Dimension scaledDimension;

    public void export(ExportData exportData) {
        try {
            SelectionExporter selectionExporter = new SelectionExporter(exportData, this);
            selectionExporter.exportSelection();
        }
        catch (HeadlessException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(this.frame, "Can't open file", "Error", 0);
        }
    }

    public int askUser() {
        int returnval = 0;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                String n = f.getName();
                return n.endsWith(".wmf") || n.endsWith(".WMF") || f.isDirectory();
            }

            public String getDescription() {
                return "WMF files";
            }
        });
        if (this.exportFile.isDirectory()) {
            chooser.setSelectedFile(new File(this.exportFile, "unnamed.wmf"));
        } else {
            chooser.setSelectedFile(this.exportFile);
        }
        returnval = chooser.showSaveDialog(this.frame);
        if (returnval == 0) {
            this.exportFile = chooser.getSelectedFile();
            if (this.exportFile.exists()) {
                returnval = JOptionPane.showConfirmDialog(this.frame, "File " + this.exportFile.getName() + " exists. Do you want to continue ?", "File exists", 2, 2);
            }
        }
        return returnval;
    }

    protected String getOptionsTitle() {
        return "type".toUpperCase() + " options";
    }

    public File getExportFile() {
        return this.exportFile;
    }

    public void setExportFile(File exportFile) {
        this.exportFile = exportFile;
    }

    public void setDimension(Dimension scaledDimensions) {
        this.scaledDimension = scaledDimensions;
    }

    public BaseGraphics2D buildGraphics() throws IOException {
        return new WMFGraphics2D(this.exportFile, this.scaledDimension);
    }
}

