/*
 * Decompiled with CFR 0.152.
 */
package jsesh.graphics.bitmaps;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.imageio.ImageIO;
import jsesh.graphics.bitmaps.StreamGraphics2DDelegate;
import jsesh.swingUtils.GraphicsUtils;

public class BitmapStreamGraphics
extends StreamGraphics2DDelegate {
    OutputStream out;
    String format;
    BufferedImage image;

    public BitmapStreamGraphics(OutputStream out, Dimension dim, String format, boolean transparency) {
        this.format = format;
        this.out = out;
        int imageType = transparency ? 2 : 1;
        this.image = new BufferedImage(dim.width, dim.height, imageType);
        this.proxy = (Graphics2D)this.image.getGraphics();
        GraphicsUtils.antialias(this.proxy);
    }

    public void dispose() {
        this.proxy.dispose();
        this.proxy = null;
        try {
            ImageIO.write((RenderedImage)this.image, this.format, this.out);
            this.out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.image = null;
        this.out = null;
    }

    public void setProperties(Properties properties) {
    }
}

