/*
 * Decompiled with CFR 0.152.
 */
package jsesh.graphics.bitmaps;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Properties;
import jsesh.graphics.generic.BaseGraphics2D;
import jsesh.graphics.generic.BaseGraphics2DException;

public class MultiFileGraphics
extends BaseGraphics2D {
    private Properties properties;
    private BaseGraphics2D g;
    private int pageNumber = 0;
    private Graphics2DFactory factory;
    private File directory;
    private String base;
    private String extension;

    public MultiFileGraphics(Graphics2DFactory factory, File directory, String base, String extension) {
        this.factory = factory;
        this.base = base;
        this.directory = directory;
        this.extension = extension;
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.g.copyArea(x, y, width, height, dx, dy);
    }

    public Graphics create() {
        if (this.g != null) {
            return this.g.create();
        }
        return null;
    }

    public void dispose() {
        if (this.g != null) {
            this.g.dispose();
        }
    }

    public void draw(Shape s) {
        this.g.draw(s);
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return false;
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
    }

    public void fill(Shape s) {
        this.g.fill(s);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.g.getDeviceConfiguration();
    }

    public FontRenderContext getFontRenderContext() {
        return this.g.getFontRenderContext();
    }

    public void setPaintMode() {
        this.g.setPaintMode();
    }

    public void setXORMode(Color c1) {
        this.g.setXORMode(c1);
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void openPage(Dimension dimensions, String title) throws BaseGraphics2DException {
        try {
            String num = this.stringFormat(this.pageNumber + 1);
            File f = new File(this.directory, this.base + num + "." + this.extension);
            this.g = null;
            this.g = this.factory.createGraphics(f, this.pageNumber, dimensions);
            this.g.setProperties(this.properties);
            this.g.transform(this.getTransform());
            ++this.pageNumber;
        }
        catch (FileNotFoundException e) {
            throw new BaseGraphics2DException(e);
        }
    }

    public void transform(AffineTransform Tx) {
        super.transform(Tx);
        if (this.g != null) {
            this.g.transform(Tx);
        }
    }

    private String stringFormat(int i) {
        return "" + i;
    }

    public void closePage() throws BaseGraphics2DException {
        this.g.closePage();
        if (this.g != null) {
            this.g.dispose();
        }
        this.g = null;
    }

    public static interface Graphics2DFactory {
        public BaseGraphics2D createGraphics(File var1, int var2, Dimension var3) throws FileNotFoundException;
    }
}

