/*
 * Decompiled with CFR 0.152.
 */
package jsesh.graphics.generic;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jsesh.graphics.generic.BaseGraphics2DException;
import jsesh.graphics.generic.SimpleFontMetrics;

public abstract class BaseGraphics2D
extends Graphics2D {
    private Composite composite;
    private Color currentBackground;
    private Shape currentClip;
    private Font currentFont;
    private Color currentForeground;
    private Paint currentPaint;
    private Stroke currentStroke;
    private AffineTransform currentTransform;
    private HashMap renderingHints = new HashMap();

    protected BaseGraphics2D() {
        this.currentBackground = Color.WHITE;
        this.currentForeground = Color.BLACK;
        this.currentFont = new Font("Serif", 0, 12);
        this.currentTransform = new AffineTransform();
    }

    public BaseGraphics2D(BaseGraphics2D g) {
        if (g.currentClip != null) {
            this.currentClip = g.currentClip;
        }
        if (g.composite != null) {
            this.composite = g.composite;
        }
        this.currentBackground = g.currentBackground;
        this.currentFont = g.currentFont;
        this.currentForeground = g.currentForeground;
        this.currentPaint = g.currentPaint;
        this.currentStroke = g.currentStroke;
        this.currentTransform = (AffineTransform)g.currentTransform.clone();
        this.renderingHints = g.renderingHints;
    }

    public void addRenderingHints(Map hints) {
        this.renderingHints.putAll(hints);
    }

    public void clearRect(int x, int y, int width, int height) {
        Color c = this.getColor();
        this.setColor(this.getBackground());
        this.fillRect(x, y, width, height);
        this.setColor(c);
    }

    public void clip(Shape s) {
        if (this.currentClip == null) {
            this.currentClip = s;
        } else {
            Area a = this.currentClip instanceof Area ? (Area)this.currentClip : new Area(this.currentClip);
            a.intersect(new Area(s));
            this.currentClip = a;
        }
    }

    public void clipRect(int x, int y, int width, int height) {
        Area clip = this.currentClip instanceof Area ? (Area)this.currentClip : new Area(this.currentClip);
        clip.intersect(new Area(new Rectangle(x, y, width, height)));
    }

    public abstract void copyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract Graphics create();

    public abstract void dispose();

    public abstract void draw(Shape var1);

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.draw(new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 0));
    }

    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.translate(x, y);
        for (int i = 0; i < g.getNumGlyphs(); ++i) {
            this.fill(g.getGlyphOutline(i));
        }
        this.translate(-x, -y);
    }

    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        BufferedImage img1 = op.filter(img, null);
        this.drawImage(img1, AffineTransform.getTranslateInstance(x, y), null);
    }

    public abstract boolean drawImage(Image var1, AffineTransform var2, ImageObserver var3);

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        if (w != -1 && h != -1) {
            Color col = this.getColor();
            this.setColor(bgcolor);
            this.fillRect(x, y, w, h);
            this.drawImage(img, x, y, observer);
            this.setColor(col);
        }
        return false;
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, AffineTransform.getTranslateInstance(x, y), observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        if (w == -1) {
            w = width;
        }
        if (h == -1) {
            h = height;
        }
        float xscale = (float)width / (float)w;
        float yscale = (float)height / (float)h;
        Color col = this.getColor();
        if (w != -1 && h != -1) {
            this.setColor(bgcolor);
            this.fillRect(x, y, width, height);
        }
        AffineTransform tr = new AffineTransform(xscale, 0.0f, x, 0.0f, yscale, y);
        boolean result = this.drawImage(img, tr, observer);
        this.setColor(col);
        return result;
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(img, x, y, width, height, this.getBackground(), observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return false;
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.draw(new Line2D.Float(x1, y1, x2, y2));
    }

    public void drawOval(int x, int y, int width, int height) {
        this.draw(new Ellipse2D.Float(x, y, width, height));
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath s = this.getPathFor(xPoints, yPoints, nPoints);
        if (s != null) {
            s.closePath();
            this.draw(s);
        }
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath s = this.getPathFor(xPoints, yPoints, nPoints);
        this.draw(s);
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        RenderedImage img1 = img.createDefaultRendering();
        this.drawRenderedImage(img1, xform);
    }

    public abstract void drawRenderedImage(RenderedImage var1, AffineTransform var2);

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.draw(new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight));
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        GlyphVector vect = this.getFont().createGlyphVector(this.getFontRenderContext(), iterator);
        this.drawGlyphVector(vect, x, y);
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    public void drawString(String s, float x, float y) {
        GlyphVector vect = this.getFont().createGlyphVector(this.getFontRenderContext(), s);
        this.drawGlyphVector(vect, x, y);
    }

    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    public abstract void fill(Shape var1);

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.fill(new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 2));
    }

    public void fillOval(int x, int y, int width, int height) {
        this.draw(new Ellipse2D.Float(x, y, width, height));
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath s = this.getPathFor(xPoints, yPoints, nPoints);
        if (s != null) {
            s.closePath();
            this.fill(s);
        }
    }

    public void fillRect(int x, int y, int width, int height) {
        this.fill(new Rectangle2D.Float(x, y, width, height));
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fill(new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight));
    }

    public Color getBackground() {
        return this.currentBackground;
    }

    public Shape getClip() {
        return this.currentClip;
    }

    public Rectangle getClipBounds() {
        return this.currentClip.getBounds();
    }

    public Color getColor() {
        return this.currentForeground;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public abstract GraphicsConfiguration getDeviceConfiguration();

    public Font getFont() {
        return this.currentFont;
    }

    public FontMetrics getFontMetrics(Font f) {
        return new SimpleFontMetrics(f);
    }

    public abstract FontRenderContext getFontRenderContext();

    public Paint getPaint() {
        if (this.currentPaint == null) {
            return this.currentForeground;
        }
        return this.currentPaint;
    }

    protected GeneralPath getPathFor(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath s = null;
        if (nPoints != 0) {
            s = new GeneralPath();
            s.moveTo(xPoints[0], yPoints[0]);
            for (int i = 1; i < nPoints; ++i) {
                s.lineTo(xPoints[i], yPoints[i]);
            }
        }
        return s;
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.renderingHints.get(hintKey);
    }

    public RenderingHints getRenderingHints() {
        return new RenderingHints(this.renderingHints);
    }

    public Stroke getStroke() {
        return this.currentStroke;
    }

    public AffineTransform getTransform() {
        return this.currentTransform;
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return false;
    }

    public void rotate(double theta) {
        this.rotate(theta, 0.0, 0.0);
    }

    public void rotate(double theta, double x, double y) {
        this.transform(AffineTransform.getRotateInstance(theta, x, y));
    }

    public void scale(double sx, double sy) {
        this.transform(AffineTransform.getScaleInstance(sx, sy));
    }

    public void setBackground(Color color) {
        this.currentBackground = color;
    }

    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height));
    }

    public void setClip(Shape clip) {
        this.currentClip = clip;
    }

    public void setColor(Color c) {
        this.currentForeground = c;
    }

    public void setComposite(Composite comp) {
        this.composite = comp;
    }

    public void setFont(Font font) {
        this.currentFont = font;
    }

    public void setPaint(Paint paint) {
        if (paint != null) {
            this.currentPaint = paint;
            if (paint instanceof Color) {
                this.currentForeground = (Color)paint;
            }
        }
    }

    public abstract void setPaintMode();

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.renderingHints.put(hintKey, hintValue);
    }

    public void setRenderingHints(Map hints) {
        this.renderingHints.clear();
        this.renderingHints.putAll(hints);
    }

    public void setStroke(Stroke s) {
        this.currentStroke = s;
    }

    public void setTransform(AffineTransform Tx) {
        this.currentTransform = (AffineTransform)Tx.clone();
    }

    public abstract void setXORMode(Color var1);

    public void shear(double shx, double shy) {
        this.transform(AffineTransform.getShearInstance(shx, shy));
    }

    public void transform(AffineTransform Tx) {
        this.currentTransform.concatenate(Tx);
    }

    public void translate(double tx, double ty) {
        this.transform(AffineTransform.getTranslateInstance(tx, ty));
    }

    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    public abstract void setProperties(Properties var1);

    public void openPage(Dimension dimensions, String title) throws BaseGraphics2DException {
    }

    public void closePage() throws BaseGraphics2DException {
    }

    public boolean canMultiPage() {
        return false;
    }
}

