/*
 * Decompiled with CFR 0.152.
 */
package jsesh.graphics.wmfexport;

import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import jsesh.graphics.generic.RandomAccessFileAdapter;
import jsesh.graphics.generic.RandomAccessStream;
import jsesh.graphics.wmfexport.WMFConstants;
import jsesh.graphics.wmfexport.WMFFunctionCodes;
import jsesh.graphics.wmfexport.WMFPen;
import jsesh.graphics.wmfexport.WMFPoint;

public class WMFDeviceContext
implements WMFFunctionCodes,
WMFConstants {
    WindowsMetaHeader head;
    PlaceableMetaHeader meta;
    ArrayList objects;
    RandomAccessStream out;

    static long buildColor(int r, int g, int b) {
        return r | g << 8 | b << 16;
    }

    static long buildColor(Color col) {
        return WMFDeviceContext.buildColor(col.getRed(), col.getGreen(), col.getBlue());
    }

    public static void main(String[] args) throws IOException {
        RandomAccessFile o = new RandomAccessFile("test.wmf", "rw");
        WMFDeviceContext wmf = new WMFDeviceContext(new RandomAccessFileAdapter(o), 200, 200);
        WMFPoint[] pol = new WMFPoint[]{new WMFPoint(20, 20), new WMFPoint(40, 20), new WMFPoint(100, 110), new WMFPoint(200, 40), new WMFPoint(405, 200)};
        wmf.setWindowOrg((short)0, (short)0);
        wmf.setWindowExt((short)200, (short)200);
        wmf.MoveTo((short)10, (short)10);
        wmf.LineTo((short)50, (short)100);
        wmf.LineTo((short)100, (short)50);
        wmf.LineTo((short)10, (short)10);
        wmf.Polygon(pol, (short)4);
    }

    public WMFDeviceContext(RandomAccessStream stream, Dimension dims) throws IOException {
        this(stream, (int)dims.getWidth(), (int)dims.getHeight());
    }

    public WMFDeviceContext(RandomAccessStream stream, int width, int height) throws IOException {
        this.initLowLevelGraphics(stream, width, height);
    }

    private void addCommand(short func) throws IOException {
        this.addRecord(func, 0);
    }

    private void addCommandABCD(short func, short a, short b, short c, short d) throws IOException {
        this.addRecord(func, 4);
        this.writeS16(d);
        this.writeS16(c);
        this.writeS16(b);
        this.writeS16(a);
    }

    private void addCommandL(short func, long x) throws IOException {
        this.addRecord(func, 2);
        this.writeS32(x);
    }

    private void addCommandLINES(short func, WMFPoint[] p, short nbr) throws IOException {
        this.addRecord(func, 2 * nbr + 1);
        this.writeS16((short)nbr);
        for (int i = 0; i < nbr; ++i) {
            this.writeS16(p[i].x);
            this.writeS16(p[i].y);
        }
    }

    private void addCommandX(short func, short x) throws IOException {
        this.addRecord(func, 1);
        this.writeS16(x);
    }

    private void addCommandXY(short func, short x, short y) throws IOException {
        this.addRecord(func, 2);
        this.writeS16(y);
        this.writeS16(x);
    }

    private void addCommandXYL(short func, short a, short b, long c) throws IOException {
        this.addRecord(func, 4);
        this.writeS32(c);
        this.writeS16(b);
        this.writeS16(a);
    }

    private void addRecord(short function, int nbrshorts) throws IOException {
        int size = 3 + nbrshorts;
        this.head.NumOfObjects = (short)(this.head.NumOfObjects + 1);
        if (this.head.MaxRecordSize < (long)size) {
            this.head.MaxRecordSize = size;
        }
        this.head.FileSize += (long)size;
        this.writeS32(size);
        this.writeS16(function);
    }

    private short allocObject() {
        short result;
        int i;
        for (i = 0; i < this.objects.size() && ((Boolean)this.objects.get(i)).booleanValue(); ++i) {
        }
        if (i == this.objects.size()) {
            result = (short)i;
            this.objects.add(Boolean.TRUE);
        } else {
            result = (short)i;
            this.objects.set(i, Boolean.TRUE);
        }
        return result;
    }

    public void arc(short left, short top, short right, short bottom, short xstart, short ystart, short xend, short yend) throws IOException {
        this.addRecord((short)2071, 8);
        this.writeS16(yend);
        this.writeS16(xend);
        this.writeS16(ystart);
        this.writeS16(xstart);
        this.writeS16(bottom);
        this.writeS16(right);
        this.writeS16(top);
        this.writeS16(left);
    }

    void close() throws IOException {
        this.addCommand((short)0);
        this.out.seek(0);
        this.writeHEADER();
        this.out.close();
    }

    public WMFPen createPenBrush(int penStyle, short width, long penColour, short fillhatch, long fillColour, int fillStyle) throws IOException {
        short p = this.createPenIndirect(penStyle, width, penColour);
        short b = this.createBrushIndirect(fillhatch, fillColour, fillStyle);
        return new WMFPen(p, b);
    }

    public WMFPen createDrawPen(int penStyle, short width, long colour) throws IOException {
        return this.createPenBrush(penStyle, width, colour, (short)1, colour, 1);
    }

    public WMFPen createDrawPen(short width, long colour) throws IOException {
        return this.createPenBrush(0, width, colour, (short)1, colour, 1);
    }

    public WMFPen createFillPen(short fillHatch, long colour, int fillStyle) throws IOException {
        return this.createPenBrush(5, (short)0, colour, fillHatch, colour, fillStyle);
    }

    public WMFPen createFillPen(long colour) throws IOException {
        return this.createPenBrush(5, (short)0, colour, (short)1, colour, 0);
    }

    public void selectPen(WMFPen pen) throws IOException {
        this.SelectObject(pen.getPenNum());
        this.SelectObject(pen.getBrushNum());
    }

    public void freePen(WMFPen pen) throws IOException {
        this.deleteObject(pen.getPenNum());
        this.deleteObject(pen.getBrushNum());
    }

    short createBrushIndirect(short hatch, long colour, int style) throws IOException {
        this.addRecord((short)764, 4);
        this.writeU16(style);
        this.writeS32(colour);
        this.writeS16(hatch);
        return this.allocObject();
    }

    int createFontIndirect(short height, int width, int escapement, int orientation, int weight, char italic, char underlined, char striked, char charset, char outPrecision, char clipPrecision, char quality, char pitch, char[] name) throws IOException {
        this.addRecord((short)763, 25);
        this.writeS16(height);
        this.writeU16(width);
        this.writeU16(escapement);
        this.writeU16(orientation);
        this.writeU16(weight);
        this.writeU8(italic);
        this.writeU8(underlined);
        this.writeU8(striked);
        this.writeU8(charset);
        this.writeU8(outPrecision);
        this.writeU8(clipPrecision);
        this.writeU8(quality);
        this.writeU8(pitch);
        for (int i = 0; i < 32; ++i) {
            this.writeU8(name[i]);
        }
        return this.allocObject();
    }

    short createPenIndirect(int style, short width, long colour) throws IOException {
        this.addRecord((short)762, 5);
        this.writeU16(style);
        this.writeS16(width);
        this.writeS16((short)0);
        this.writeS32(colour);
        return this.allocObject();
    }

    int createRegion(short left, short top, short right, short bottom) throws IOException {
        this.addCommandABCD((short)1791, left, top, right, bottom);
        return this.allocObject();
    }

    void deleteObject(short nobj) throws IOException {
        this.FreeObject(nobj);
        this.addCommandX((short)496, nobj);
    }

    void ellipse(short left, short top, short right, short bottom) throws IOException {
        this.addCommandABCD((short)1048, left, top, right, bottom);
    }

    void ExcludeClipRect(short left, short top, short right, short bottom) throws IOException {
        this.addCommandABCD((short)1045, left, top, right, bottom);
    }

    void FillRgn(short nbrush, short nregion) throws IOException {
        this.addCommandXY((short)552, nbrush, nregion);
    }

    void FloodFill(short x, short y, long colour) throws IOException {
        this.addCommandXYL((short)1049, x, y, colour);
    }

    void FreeObject(int nobj) {
        this.objects.set(nobj, Boolean.FALSE);
    }

    private void initLowLevelGraphics(RandomAccessStream out, int width, int height) throws IOException {
        out.setLength(0);
        this.objects = new ArrayList();
        this.meta = new PlaceableMetaHeader();
        this.head = new WindowsMetaHeader();
        this.meta.Key = -1698247209L;
        this.meta.Handle = 0;
        this.meta.Left = 0;
        this.meta.Top = 0;
        this.meta.Right = width;
        this.meta.Bottom = height;
        this.meta.Inch = (short)1440;
        this.meta.Reserved = 0L;
        this.meta.Checksum = 0;
        this.head.FileType = 1;
        this.head.HeaderSize = (short)9;
        this.head.Version = (short)768;
        this.head.FileSize = 9L;
        this.head.NumOfObjects = 0;
        this.head.MaxRecordSize = 0L;
        this.head.NumOfParams = 0;
        this.out = out;
        this.writeHEADER();
    }

    void IntersectClipRetc(short left, short top, short right, short bottom) throws IOException {
        this.addCommandABCD((short)1046, left, top, right, bottom);
    }

    void InvertRgn(short nregion) throws IOException {
        this.addCommandX((short)298, nregion);
    }

    void LineTo(short x, short y) throws IOException {
        this.addCommandXY((short)531, x, y);
    }

    void LineTo(WMFPoint p) throws IOException {
        this.LineTo(p.x, p.y);
    }

    void MoveTo(short x, short y) throws IOException {
        this.addCommandXY((short)532, x, y);
    }

    void MoveTo(WMFPoint p) throws IOException {
        this.MoveTo(p.x, p.y);
    }

    void OffsetViewportOrg(short x, short y) throws IOException {
        this.addCommandXY((short)529, x, y);
    }

    void OffsetWindowOrg(short x, short y) throws IOException {
        this.addCommandXY((short)527, x, y);
    }

    void PaintRgn(short nregion) throws IOException {
        this.addCommandX((short)299, nregion);
    }

    void PatBlt(short left, short top, short right, short bottom, long rop) throws IOException {
        this.addRecord((short)1565, 6);
        this.writeS32(rop);
        this.writeS16(bottom);
        this.writeS16(right);
        this.writeS16(top);
        this.writeS16(left);
    }

    void Polygon(WMFPoint[] p, short nbr) throws IOException {
        this.addCommandLINES((short)804, p, nbr);
    }

    void PolyLine(WMFPoint[] p, short nbr) throws IOException {
        this.addCommandLINES((short)805, p, nbr);
    }

    void rectangle(short left, short top, short right, short bottom) throws IOException {
        this.addCommandABCD((short)1051, left, top, right, bottom);
    }

    void RestoreDC(short lev) throws IOException {
        this.addCommandX((short)295, lev);
    }

    void RoundRectangle(short left, short top, short right, short bottom, short wi, short h) throws IOException {
        this.addRecord((short)1564, 6);
        this.writeS16(h);
        this.writeS16(wi);
        this.writeS16(bottom);
        this.writeS16(right);
        this.writeS16(top);
        this.writeS16(left);
    }

    void SaveDC() throws IOException {
        this.addCommand((short)30);
    }

    void ScaleViewportExt(short xnum, short xdenom, short ynum, short ydenom) throws IOException {
        this.addRecord((short)1042, 4);
        this.writeS16(ydenom);
        this.writeS16(ynum);
        this.writeS16(xdenom);
        this.writeS16(xnum);
    }

    void ScaleWindowExt(short xnum, short xdenom, short ynum, short ydenom) throws IOException {
        this.addRecord((short)1040, 4);
        this.writeS16(ydenom);
        this.writeS16(ynum);
        this.writeS16(xdenom);
        this.writeS16(xnum);
    }

    void SelectClipRgn(short nregion) throws IOException {
        this.addCommandX((short)300, nregion);
    }

    void SelectObject(short nobj) throws IOException {
        this.addCommandX((short)301, nobj);
    }

    void SetBKColor(long color) throws IOException {
        this.addCommandL((short)513, color);
    }

    void SetBKMode(short mode) throws IOException {
        this.addCommandX((short)258, mode);
    }

    void SetMapMode(short map) throws IOException {
        this.addCommandX((short)259, map);
    }

    void SetPixel(short x, short y, long colour) throws IOException {
        this.addCommandXYL((short)1055, x, y, colour);
    }

    void SetPixel(WMFPoint p, long colour) throws IOException {
        this.SetPixel(p.x, p.y, colour);
    }

    void SetPolyFillMode(short fillmode) throws IOException {
        this.addCommandX((short)262, fillmode);
    }

    void SetROP2(long rop) throws IOException {
        this.addCommandL((short)260, rop);
    }

    void SetTextCharacterExtra(short extra) throws IOException {
        this.addCommandX((short)521, extra);
    }

    void SetTextColor(long color) throws IOException {
        this.addCommandL((short)521, color);
    }

    void setViewportExt(short x, short y) throws IOException {
        this.addCommandXY((short)526, x, y);
    }

    void setViewportExt(WMFPoint p) throws IOException {
        this.setViewportExt(p.x, p.y);
    }

    void setViewportOrg(short x, short y) throws IOException {
        this.addCommandXY((short)525, x, y);
    }

    void setWindowExt(short x, short y) throws IOException {
        this.addCommandXY((short)524, x, y);
    }

    void setWindowExt(WMFPoint p) throws IOException {
        this.setWindowExt(p.x, p.y);
    }

    void setWindowOrg(short x, short y) throws IOException {
        this.addCommandXY((short)523, x, y);
    }

    void textOut(short x, short y, char[] s) throws IOException {
        int length = s.length;
        this.addRecord((short)1313, (length + 1) / 2 + 3);
        this.writeS16((short)length);
        for (int i = 0; i < length; ++i) {
            this.writeU8(s[i]);
        }
        if (length % 2 != 0) {
            this.writeU8('\u0000');
        }
        this.writeS16(y);
        this.writeS16(x);
    }

    public void textOut(short x, short y, String txt) throws IOException {
        char[] t = txt.toCharArray();
        this.textOut(x, y, t);
    }

    void textOut(WMFPoint p, char[] s) throws IOException {
        this.textOut(p.x, p.y, s);
    }

    public void textOut(WMFPoint p, String txt) throws IOException {
        this.textOut(p.x, p.y, txt);
    }

    private void writeHEADER() throws IOException {
        this.meta.compute_checksum();
        this.meta.write();
        this.head.write();
    }

    private void writeClipboardHeader(PlaceableMetaHeader meta2) throws IOException {
        this.writeS32(6L);
        this.writeS32(meta2.Right);
        this.writeS32(meta2.Bottom);
        this.writeS32(0L);
    }

    private void writeS16(short x) throws IOException {
        int s0 = x & 0xFF;
        int s1 = (x & 0xFF00) >>> 8;
        this.out.write(s0);
        this.out.write(s1);
    }

    private void writeS32(long x32) throws IOException {
        int x = (int)x32;
        int s0 = x & 0xFF;
        int s1 = (x & 0xFF00) >>> 8;
        int s2 = (x & 0xFF0000) >>> 16;
        int s3 = (x & 0xFF000000) >>> 24;
        this.out.write(s0);
        this.out.write(s1);
        this.out.write(s2);
        this.out.write(s3);
    }

    private void writeU16(int x) throws IOException {
        int s0 = x & 0xFF;
        int s1 = (x & 0xFF00) >>> 8;
        this.out.write(s0);
        this.out.write(s1);
    }

    private void writeU8(char c) throws IOException {
        this.out.write(c);
    }

    class WindowsMetaHeader {
        long FileSize;
        short FileType;
        short HeaderSize;
        long MaxRecordSize;
        short NumOfObjects;
        short NumOfParams;
        short Version;

        WindowsMetaHeader() {
        }

        public void write() throws IOException {
            WMFDeviceContext.this.writeS16(this.FileType);
            WMFDeviceContext.this.writeS16(this.HeaderSize);
            WMFDeviceContext.this.writeS16(this.Version);
            WMFDeviceContext.this.writeS32(this.FileSize);
            WMFDeviceContext.this.writeS16(this.NumOfObjects);
            WMFDeviceContext.this.writeS32(this.MaxRecordSize);
            WMFDeviceContext.this.writeS16(this.NumOfParams);
        }
    }

    class PlaceableMetaHeader {
        int Bottom;
        short Checksum;
        short Handle;
        short Inch;
        long Key;
        int Left;
        long Reserved;
        int Right;
        int Top;

        PlaceableMetaHeader() {
        }

        void compute_checksum() {
            this.Checksum = 0;
            short[] b = new short[]{(short)(this.Key & 0xFFL), (short)((this.Key & 0xFF00L) >>> 16), (short)this.Left, (short)this.Top, (short)this.Right, (short)this.Bottom, this.Inch, (short)(this.Reserved & 0xFFL), (short)((this.Reserved & 0xFF00L) >>> 16)};
            for (int i = 0; i < b.length; ++i) {
                this.Checksum = (short)(this.Checksum ^ b[i]);
            }
        }

        public void write() throws IOException {
            WMFDeviceContext.this.writeS32(this.Key);
            WMFDeviceContext.this.writeS16(this.Handle);
            WMFDeviceContext.this.writeU16(this.Left);
            WMFDeviceContext.this.writeU16(this.Top);
            WMFDeviceContext.this.writeU16(this.Right);
            WMFDeviceContext.this.writeU16(this.Bottom);
            WMFDeviceContext.this.writeS16(this.Inch);
            WMFDeviceContext.this.writeS32(this.Reserved);
            WMFDeviceContext.this.writeS16(this.Checksum);
        }
    }
}

