/*
 * Decompiled with CFR 0.152.
 */
package jsesh.hieroglyphs;

import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import jsesh.bzr.simple.ShapeChar;
import jsesh.hieroglyphs.HieroglyphicFontManager;
import jsesh.hieroglyphs.MemoryHieroglyphicFontManager;

public class HieroglyphicDB
implements HieroglyphicFontManager {
    Connection db;
    HashMap glyphs;
    boolean hasNewSigns;

    public HieroglyphicDB() throws SQLException {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.hasNewSigns = true;
        this.glyphs = new HashMap();
    }

    private void open() throws SQLException {
        this.db = DriverManager.getConnection("jdbc:hsqldb:file:test;readonly=false", "sa", "");
    }

    private void openRO() throws SQLException {
        this.db = DriverManager.getConnection("jdbc:hsqldb:file:test;readonly=true", "sa", "");
    }

    public ShapeChar getFromDatabase(String code) {
        ShapeChar result = null;
        try {
            this.openRO();
            PreparedStatement pst = this.db.prepareStatement("select minx, miny, maxx, maxy, data from glyph where code = ?");
            pst.setString(1, code);
            ResultSet rs = pst.executeQuery();
            if (rs.next()) {
                String data = rs.getString(5);
                result = this.decodeChar(data);
                result.setBBox(rs.getDouble("minx"), rs.getDouble("maxy"), rs.getDouble("maxx"), rs.getDouble("miny"));
            }
            rs.close();
            pst.close();
            this.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public ShapeChar get(String code) {
        if (this.glyphs.containsKey(code)) {
            return (ShapeChar)this.glyphs.get(code);
        }
        ShapeChar result = this.getFromDatabase(code);
        if (result != null) {
            this.glyphs.put(code, result);
        }
        return result;
    }

    public Set getCodes() {
        TreeSet<String> set = new TreeSet<String>();
        try {
            this.openRO();
            Statement st = this.db.createStatement();
            ResultSet rs = st.executeQuery("select code from glyph");
            while (rs.next()) {
                set.add(rs.getString(1));
            }
            rs.close();
            st.close();
            this.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return set;
    }

    private void appendNumberToStringBuffer(StringBuffer buf, double d) {
        int i;
        if (d < 0.0) {
            buf.append("-");
            d = -d;
        }
        buf.append((int)d);
        double frac = d - (double)((int)d);
        buf.append('.');
        for (i = 0; i < 6; ++i) {
            buf.append((int)(frac *= 10.0));
            frac -= (double)((int)frac);
        }
        i = buf.length() - 1;
        while (buf.charAt(i) != '.' && buf.charAt(i) == '0') {
            buf.delete(i, i + 1);
            --i;
        }
    }

    private String encodeChar(ShapeChar glyph) {
        PathIterator iterator = glyph.getShape().getPathIterator(null);
        StringBuffer buff = new StringBuffer();
        String toAdd = "";
        while (!iterator.isDone()) {
            double[] coords = new double[6];
            int type = iterator.currentSegment(coords);
            buff.append(toAdd);
            switch (type) {
                case 4: {
                    buff.append("s");
                    break;
                }
                case 3: {
                    int i;
                    buff.append("c");
                    for (i = 0; i < 6; ++i) {
                        buff.append(" ");
                        this.appendNumberToStringBuffer(buff, coords[i]);
                    }
                    break;
                }
                case 2: {
                    int i;
                    buff.append("q");
                    for (i = 0; i < 4; ++i) {
                        buff.append(" ");
                        this.appendNumberToStringBuffer(buff, coords[i]);
                    }
                    break;
                }
                case 0: {
                    int i;
                    buff.append("m");
                    for (i = 0; i < 2; ++i) {
                        buff.append(" ");
                        this.appendNumberToStringBuffer(buff, coords[i]);
                    }
                    break;
                }
                case 1: {
                    int i;
                    buff.append("l");
                    for (i = 0; i < 2; ++i) {
                        buff.append(" ");
                        this.appendNumberToStringBuffer(buff, coords[i]);
                    }
                    break;
                }
                default: {
                    System.err.println("unexpected code " + type + " in " + glyph.toString());
                }
            }
            toAdd = " ";
            iterator.next();
        }
        return buff.toString();
    }

    private ShapeChar decodeChar(String glyph) {
        GeneralPath path = new GeneralPath();
        StreamTokenizer tok = new StreamTokenizer(new StringReader(glyph));
        try {
            int curr = 0;
            float[] coords = new float[6];
            int command = 32;
            do {
                tok.nextToken();
                if (tok.ttype == -2) {
                    coords[curr++] = (float)tok.nval;
                }
                if (command != 32) {
                    switch (command) {
                        case 109: {
                            if (curr != 2) break;
                            path.moveTo(coords[0], coords[1]);
                            command = 32;
                            curr = 0;
                            break;
                        }
                        case 115: {
                            if (curr != 0) break;
                            path.closePath();
                            command = 32;
                            curr = 0;
                            break;
                        }
                        case 108: {
                            if (curr != 2) break;
                            path.lineTo(coords[0], coords[1]);
                            command = 32;
                            curr = 0;
                            break;
                        }
                        case 113: {
                            if (curr != 4) break;
                            path.quadTo(coords[0], coords[1], coords[2], coords[3]);
                            command = 32;
                            curr = 0;
                            break;
                        }
                        case 99: {
                            if (curr != 6) break;
                            path.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                            command = 32;
                            curr = 0;
                        }
                    }
                }
                if (tok.ttype != -3) continue;
                command = tok.sval.charAt(0);
            } while (tok.ttype != -1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ShapeChar result = new ShapeChar();
        result.setShape(path);
        result.setBbox(path.getBounds2D());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareDataBase() {
        MemoryHieroglyphicFontManager manager = new MemoryHieroglyphicFontManager();
        Set codes = manager.getCodes();
        try {
            Statement st;
            this.open();
            try {
                st = this.db.createStatement();
                st.executeUpdate("drop table glyph");
                st.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                st = this.db.createStatement();
                st.executeUpdate("create cached table glyph (code varchar(10) primary key, minx float, miny float, maxx float, maxy float, data varchar(10240));");
                st.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                PreparedStatement pst = this.db.prepareStatement("insert into glyph values (?,?,?,?,?,?)");
                Iterator i = codes.iterator();
                while (i.hasNext()) {
                    String code = (String)i.next();
                    ShapeChar shapeChar = manager.get(code);
                    pst.setString(1, code);
                    pst.setDouble(2, shapeChar.getBbox().getMinX());
                    pst.setDouble(3, shapeChar.getBbox().getMinY());
                    pst.setDouble(4, shapeChar.getBbox().getMaxX());
                    pst.setDouble(5, shapeChar.getBbox().getMaxY());
                    pst.setString(6, this.encodeChar(shapeChar));
                    pst.executeUpdate();
                }
                pst.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.shutdownAndClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertNewSign(String code, ShapeChar shapeChar) {
        try {
            this.open();
            this.shutdownAndClose();
            this.open();
            PreparedStatement pst = this.db.prepareStatement("insert into glyph values (?,?,?,?,?,?)");
            pst.setString(1, code);
            pst.setDouble(2, shapeChar.getBbox().getMinX());
            pst.setDouble(3, shapeChar.getBbox().getMinY());
            pst.setDouble(4, shapeChar.getBbox().getMaxX());
            pst.setDouble(5, shapeChar.getBbox().getMaxY());
            pst.setString(6, this.encodeChar(shapeChar));
            pst.executeUpdate();
            pst.close();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        finally {
            this.shutdownAndClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownAndClose() {
        if (this.db == null) {
            return;
        }
        try {
            Statement st = this.db.createStatement();
            st.executeUpdate("SHUTDOWN COMPACT");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close();
        }
    }

    public boolean hasNewSigns() {
        return false;
    }

    public void close() {
        if (this.db == null) {
            return;
        }
        try {
            this.db.close();
            this.db = null;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected void finalize() throws Throwable {
        if (this.db != null) {
            this.db.close();
            this.db = null;
        }
    }

    public static void main(String[] args) throws SQLException {
        if (args.length > 0 && "create".equals(args[0])) {
            HieroglyphicDB db = new HieroglyphicDB();
            db.prepareDataBase();
            db.close();
        } else {
            HieroglyphicDB db = new HieroglyphicDB();
            ShapeChar c = db.get("p");
            System.out.println("shape is " + c.getShape());
            System.out.println(db.encodeChar(c));
            db.close();
        }
    }
}

