/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdc.constants;

public class LexicalSymbolsUtils {
    private static String[] codesForSymbols = null;

    private static String[] getCodesForSymbols() {
        if (codesForSymbols == null) {
            codesForSymbols = new String[255];
            LexicalSymbolsUtils.codesForSymbols[1] = ".";
            LexicalSymbolsUtils.codesForSymbols[2] = "..";
            LexicalSymbolsUtils.codesForSymbols[3] = "o";
            LexicalSymbolsUtils.codesForSymbols[4] = "O";
            LexicalSymbolsUtils.codesForSymbols[5] = "////";
            LexicalSymbolsUtils.codesForSymbols[6] = "v/";
            LexicalSymbolsUtils.codesForSymbols[7] = "h/";
            LexicalSymbolsUtils.codesForSymbols[8] = "//";
            LexicalSymbolsUtils.codesForSymbols[100] = "[[";
            LexicalSymbolsUtils.codesForSymbols[101] = "]]";
            LexicalSymbolsUtils.codesForSymbols[102] = "[&";
            LexicalSymbolsUtils.codesForSymbols[103] = "&]";
            LexicalSymbolsUtils.codesForSymbols[104] = "[{";
            LexicalSymbolsUtils.codesForSymbols[105] = "}]";
            LexicalSymbolsUtils.codesForSymbols[106] = "[\"";
            LexicalSymbolsUtils.codesForSymbols[107] = "\"]";
            LexicalSymbolsUtils.codesForSymbols[108] = "['";
            LexicalSymbolsUtils.codesForSymbols[109] = "']";
        }
        return codesForSymbols;
    }

    public static String getStringForPhilology(int code) {
        String result = "??";
        switch (code) {
            case 100: {
                result = "[";
                break;
            }
            case 101: {
                result = "]";
                break;
            }
            case 102: {
                result = "<";
                break;
            }
            case 103: {
                result = ">";
                break;
            }
            case 104: {
                result = "{";
                break;
            }
            case 105: {
                result = "}";
                break;
            }
            case 106: {
                result = "[|";
                break;
            }
            case 107: {
                result = "|]";
                break;
            }
            case 108: {
                result = "'";
                break;
            }
            case 109: {
                result = "'";
            }
        }
        return result;
    }

    public static String getOpenCodeForPhilology(int code) {
        String result = null;
        switch (code) {
            case 50: {
                result = "[[";
                break;
            }
            case 51: {
                result = "[&";
                break;
            }
            case 52: {
                result = "[{";
                break;
            }
            case 53: {
                result = "[|";
                break;
            }
            case 54: {
                result = "['";
            }
        }
        return result;
    }

    public static String getCloseCodeForPhilology(int code) {
        String result = null;
        switch (code) {
            case 50: {
                result = "]]";
                break;
            }
            case 51: {
                result = "&]";
                break;
            }
            case 52: {
                result = "}]";
                break;
            }
            case 53: {
                result = "|]";
                break;
            }
            case 54: {
                result = "']";
            }
        }
        return result;
    }

    public static String getStringForLexicalItem(int itemType) {
        return LexicalSymbolsUtils.getCodesForSymbols()[itemType];
    }
}

