/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdc.model;

import jsesh.mdc.interfaces.CadratInterface;
import jsesh.mdc.interfaces.VBoxInterface;
import jsesh.mdc.model.BasicItem;
import jsesh.mdc.model.HBox;
import jsesh.mdc.model.HBoxIterator;
import jsesh.mdc.model.ModelElement;
import jsesh.mdc.model.ModelElementVisitor;

public class Cadrat
extends BasicItem
implements CadratInterface,
VBoxInterface {
    public static final int TOP_START = 1;
    public static final int TOP_END = 2;
    public static final int BOTTOM_START = 4;
    public static final int BOTTOM_END = 8;
    public static final int FULL = 15;
    public static final int NONE = 0;
    private int shading = 0;

    public void addHBox(HBox hBox) {
        this.addChild(hBox);
    }

    public void removeHBox(HBox hBox) {
        this.removeChild(hBox);
    }

    public HBox getHBox(int idx) {
        return (HBox)this.getChildAt(idx);
    }

    public int getNumberOfHBoxes() {
        return this.getNumberOfChildren();
    }

    public int getShading() {
        return this.shading;
    }

    public void setShading(int shading) {
        this.shading = shading;
        this.notifyModification();
    }

    public void setShade(int cadratPart, boolean isShaded) {
        this.shading = isShaded ? (this.shading |= cadratPart) : (this.shading ^= cadratPart);
        this.notifyModification();
    }

    public boolean isShaded(int cadratPart) {
        return (cadratPart & this.shading) != 0;
    }

    public void accept(ModelElementVisitor v) {
        v.visitCadrat(this);
    }

    public HBoxIterator iterator() {
        return new HBoxIterator(this.getListIterator());
    }

    public HBoxIterator iterator(int idx) {
        return new HBoxIterator(this.getListIterator(idx));
    }

    public String toString() {
        return "(cadrat " + this.getChildrenAsString() + ")";
    }

    public boolean isWide() {
        boolean result = false;
        for (int i = 0; !result && i < this.getNumberOfHBoxes(); result |= this.getHBox(i).isWide(), ++i) {
        }
        return result;
    }

    public int compareToAux(ModelElement e) {
        int result = this.compareContents(e);
        if (result == 0) {
            result = this.getShading() - ((Cadrat)e).getShading();
        }
        if (result == 0) {
            result = this.getState().compareTo(((Cadrat)e).getState());
        }
        return result;
    }

    public ModelElement deepCopy() {
        Cadrat result = new Cadrat();
        result.shading = this.shading;
        this.copyContentTo(result);
        this.copyStateTo(result);
        return result;
    }
}

