/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdc.model;

import jsesh.mdc.constants.LexicalSymbolsUtils;
import jsesh.mdc.constants.WordEndingCode;
import jsesh.mdc.interfaces.HieroglyphInterface;
import jsesh.mdc.model.InnerGroup;
import jsesh.mdc.model.ModelElement;
import jsesh.mdc.model.ModelElementVisitor;
import jsesh.mdc.model.ModifiersList;

public class Hieroglyph
extends InnerGroup
implements HieroglyphInterface {
    private String code = null;
    private WordEndingCode endingCode = WordEndingCode.NONE;
    private boolean grammar = false;
    private int type = 9;
    private int x;
    private int y;

    private Hieroglyph() {
        this.addChild(new ModifiersList());
    }

    public Hieroglyph(int type) {
        this();
        switch (type) {
            case 9: {
                this.setCode("A1");
                break;
            }
            default: {
                this.type = type;
                this.setCode(LexicalSymbolsUtils.getStringForLexicalItem(type));
            }
        }
    }

    public Hieroglyph(ModifiersList listMod) {
        this();
        this.clearChildren();
        this.addChild(listMod);
    }

    public Hieroglyph(String code) {
        this();
        this.setCode(code);
    }

    public void accept(ModelElementVisitor v) {
        v.visitHieroglyph(this);
    }

    public int compareToAux(ModelElement e) {
        int i2;
        int i1;
        Hieroglyph h = (Hieroglyph)e;
        int result = this.getCode().compareTo(h.getCode());
        if (result == 0 && (result = this.getType() - h.getType()) == 0 && (result = this.x - h.x) == 0 && (result = this.y - h.y) == 0 && (result = this.endingCode.getId() - h.endingCode.getId()) == 0 && (result = (i1 = this.grammar ? 1 : 0) - (i2 = h.grammar ? 1 : 0)) == 0) {
            result = this.compareContents(h);
        }
        return result;
    }

    public ModelElement deepCopy() {
        Hieroglyph result = new Hieroglyph(this.code);
        result.endingCode = this.endingCode;
        result.grammar = this.grammar;
        result.type = this.type;
        result.x = this.x;
        result.y = this.y;
        this.copyContentTo(result);
        return result;
    }

    public int getAngle() {
        return this.getModifiers().getAngle();
    }

    public String getCode() {
        return this.code;
    }

    public WordEndingCode getEndingCode() {
        return this.endingCode;
    }

    public ModifiersList getModifiers() {
        return (ModifiersList)this.getChildAt(0);
    }

    public int getRelativeSize() {
        return this.getModifiers().getScale();
    }

    public int getType() {
        return this.type;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isGrammar() {
        return this.grammar;
    }

    public boolean isReversed() {
        return this.getModifiers().isReversed();
    }

    public boolean isWide() {
        boolean result = false;
        result = this.getModifiers().getBoolean("l");
        return result;
    }

    public void setAngle(int _angle) {
        this.getModifiers().setAngle(_angle);
    }

    public void setCode(String code) {
        if (code.startsWith("J")) {
            code = "Aa" + code.substring(1);
        }
        this.code = code;
        this.notifyModification();
    }

    public void setEndingCode(WordEndingCode _endingCode) {
        this.endingCode = _endingCode;
        this.notifyModification();
    }

    public void setExplicitPosition(int x, int y, int scale) {
        this.x = x;
        this.y = y;
        this.getModifiers().setScale(scale);
    }

    public void setGrammar(boolean _grammar) {
        this.grammar = _grammar;
        this.notifyModification();
    }

    public void setModifiers(ModifiersList modifiers) {
        this.setChildAt(0, modifiers);
        this.notifyModification();
    }

    public void setRelativeSize(int _relativeSize) {
        this.getModifiers().setScale(_relativeSize);
    }

    public void setReversed(boolean _reversed) {
        this.getModifiers().setReversed(_reversed);
    }

    public void setType(int _type) {
        this.type = _type;
        this.notifyModification();
    }

    public String toString() {
        String result = "(glyph " + this.code;
        if (this.getRelativeSize() != 100 || this.getX() != 0 || this.getY() != 0) {
            result = result + " [" + this.getX() + "," + this.getY() + ", " + this.getRelativeSize() + "%]";
        }
        result = result + ")";
        return result;
    }
}

