/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdc.model;

import java.util.List;
import jsesh.mdc.model.MDCPosition;
import jsesh.mdc.model.TopItem;
import jsesh.mdc.model.TopItemList;
import jsesh.mdc.model.operations.ChildOperation;
import jsesh.mdc.model.operations.Deletion;
import jsesh.mdc.model.operations.Insertion;
import jsesh.mdc.model.operations.ModelOperation;
import jsesh.mdc.model.operations.ModelOperationVisitor;
import jsesh.mdc.model.operations.Modification;
import jsesh.mdc.model.operations.Replacement;
import jsesh.mdc.model.operations.ZoneModification;
import jsesh.utils.EnumBase;

public class MDCMark {
    private MDCPosition position;
    private Gravity gravity;
    List listeners = null;
    private MarkUpdater markUpdater;

    public MDCMark(MDCPosition position) {
        this(position, Gravity.FORWARD);
    }

    public MDCMark(MDCPosition position, Gravity gravity) {
        this.position = position;
        this.gravity = gravity;
        this.markUpdater = new MarkUpdater();
        position.getTopItemList().addMark(this);
    }

    public MDCPosition getPosition() {
        return this.position;
    }

    public void release() {
        this.position.getTopItemList().removeMark(this);
        this.position = null;
    }

    void updateMark(ModelOperation op) {
        op.accept(this.markUpdater);
    }

    public Gravity getGravity() {
        return this.gravity;
    }

    private void setIndex(int index) {
        if (index < 0 || index > this.position.getTopItemList().getNumberOfChildren()) {
            return;
        }
        if (this.position.getIndex() != index) {
            this.position = new MDCPosition(this.position.getTopItemList(), index);
        }
    }

    private void advanceBy(int i) {
        this.setIndex(this.position.getIndex() + i);
    }

    public TopItem getElementAfter() {
        return this.position.getElementAfter();
    }

    public TopItem getElementBefore() {
        return this.position.getElementBefore();
    }

    public int getIndex() {
        return this.position.getIndex();
    }

    public MDCPosition getNextPosition(int i) {
        return this.position.getNextPosition(i);
    }

    public MDCPosition getPositionAt(int k) {
        return this.position.getPositionAt(k);
    }

    public TopItemList getTopItemList() {
        return this.position.getTopItemList();
    }

    public String toString() {
        return this.position.toString();
    }

    public boolean hasNext() {
        return this.position.hasNext();
    }

    public boolean hasPrevious() {
        return this.position.hasPrevious();
    }

    private class MarkUpdater
    implements ModelOperationVisitor {
        private MarkUpdater() {
        }

        public void observedElementChanged(ModelOperation operation) {
            operation.accept(this);
        }

        public void visitInsertion(Insertion insertion) {
            if (insertion.getIndex() < MDCMark.this.position.getIndex()) {
                MDCMark.this.advanceBy(insertion.getChildren().size());
            } else if (insertion.getIndex() == MDCMark.this.position.getIndex() && MDCMark.this.gravity.equals(Gravity.FORWARD)) {
                MDCMark.this.advanceBy(insertion.getChildren().size());
            }
        }

        public void visitDeletion(Deletion deletion) {
            if (deletion.getEnd() <= MDCMark.this.position.getIndex()) {
                MDCMark.this.advanceBy(-deletion.getEnd() + deletion.getStart());
            } else if (deletion.getStart() < MDCMark.this.position.getIndex()) {
                MDCMark.this.setIndex(deletion.getStart());
            }
        }

        public void visitReplacement(Replacement replacement) {
        }

        public void visitModification(Modification modification) {
        }

        public void visitChildOperation(ChildOperation operation) {
        }

        public void visitZoneModification(ZoneModification modification) {
        }
    }

    public static class Gravity
    extends EnumBase {
        public static Gravity BACKWARD = new Gravity(1, "BACKWARD");
        public static Gravity FORWARD = new Gravity(2, "FORWARD");

        private Gravity(int id, String designation) {
            super(id, designation);
        }
    }
}

