/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdc.model;

import jsesh.mdc.constants.ToggleType;
import jsesh.mdc.constants.WordEndingCode;
import jsesh.mdc.interfaces.AbsoluteGroupInterface;
import jsesh.mdc.interfaces.BasicItemListInterface;
import jsesh.mdc.interfaces.CadratInterface;
import jsesh.mdc.interfaces.CartoucheInterface;
import jsesh.mdc.interfaces.ComplexLigatureInterface;
import jsesh.mdc.interfaces.HBoxInterface;
import jsesh.mdc.interfaces.HieroglyphInterface;
import jsesh.mdc.interfaces.HorizontalListElementInterface;
import jsesh.mdc.interfaces.InnerGroupInterface;
import jsesh.mdc.interfaces.LigatureInterface;
import jsesh.mdc.interfaces.MDCBuilder;
import jsesh.mdc.interfaces.MDCFileInterface;
import jsesh.mdc.interfaces.ModifierListInterface;
import jsesh.mdc.interfaces.OptionListInterface;
import jsesh.mdc.interfaces.OverwriteInterface;
import jsesh.mdc.interfaces.PhilologyInterface;
import jsesh.mdc.interfaces.SubCadratInterface;
import jsesh.mdc.interfaces.TopItemListInterface;
import jsesh.mdc.interfaces.VBoxInterface;
import jsesh.mdc.interfaces.ZoneStartInterface;
import jsesh.mdc.model.AbsoluteGroup;
import jsesh.mdc.model.AlphabeticText;
import jsesh.mdc.model.BasicItemList;
import jsesh.mdc.model.Cadrat;
import jsesh.mdc.model.Cartouche;
import jsesh.mdc.model.ComplexLigature;
import jsesh.mdc.model.HBox;
import jsesh.mdc.model.HRule;
import jsesh.mdc.model.Hieroglyph;
import jsesh.mdc.model.HorizontalListElement;
import jsesh.mdc.model.InnerGroup;
import jsesh.mdc.model.Ligature;
import jsesh.mdc.model.LineBreak;
import jsesh.mdc.model.Modifier;
import jsesh.mdc.model.ModifiersList;
import jsesh.mdc.model.OptionsMap;
import jsesh.mdc.model.Overwrite;
import jsesh.mdc.model.PageBreak;
import jsesh.mdc.model.Philology;
import jsesh.mdc.model.SubCadrat;
import jsesh.mdc.model.Superscript;
import jsesh.mdc.model.TabStop;
import jsesh.mdc.model.TopItem;
import jsesh.mdc.model.TopItemList;
import jsesh.mdc.model.TopItemState;
import jsesh.mdc.model.ZoneStart;

public class MDCModelBuilder
implements MDCBuilder {
    private TopItemList result = null;
    private TopItemState currentState = new TopItemState();

    private void addToTop(TopItemListInterface l, TopItem elt) {
        elt.setState(this.currentState.duplicate());
        ((TopItemList)l).addTopItem(elt);
    }

    public void addCadratToBasicItemList(BasicItemListInterface l, CadratInterface c, int shading) {
        Cadrat cadrat = (Cadrat)c;
        cadrat.setShading(shading);
        ((BasicItemList)l).addBasicItem(cadrat);
    }

    public void addCadratToTopItemList(TopItemListInterface l, CadratInterface e, int shading) {
        Cadrat c = (Cadrat)e;
        c.setShading(shading);
        this.addToTop(l, c);
    }

    public void addCartoucheToTopItemList(TopItemListInterface l, CartoucheInterface c) {
        this.addToTop(l, (TopItem)((Object)c));
    }

    public void addHRuleToTopItemList(TopItemListInterface l, char lineType, int startPos, int endPos) {
        this.addToTop(l, new HRule(lineType, startPos, endPos));
    }

    public void addLineBreakToTopItemList(TopItemListInterface l, int skip) {
        LineBreak t = new LineBreak(skip);
        this.addToTop(l, t);
    }

    public void addModifierToModifierList(ModifierListInterface mods, String name, Integer value) {
        ((ModifiersList)mods).includeModifier(new Modifier(name, value));
    }

    public void addPageBreakToTopItemList(TopItemListInterface l) {
        this.addToTop(l, new PageBreak());
    }

    public void addTabStopToTopItemList(TopItemListInterface l, int stopWidth) {
        this.addToTop(l, new TabStop(stopWidth));
    }

    public void addTextSuperscriptToTopItemList(TopItemListInterface l, String text) {
        Superscript t = new Superscript(text);
        this.addToTop(l, t);
    }

    public void addTextToBasicItemList(BasicItemListInterface l, char scriptCode, String text) {
        ((BasicItemList)l).addBasicItem(new AlphabeticText(scriptCode, text));
    }

    public void addTextToTopItemList(TopItemListInterface l, char scriptCode, String text) {
        AlphabeticText t = new AlphabeticText(scriptCode, text);
        this.addToTop(l, t);
    }

    public void addToggleToBasicItemList(BasicItemListInterface l, ToggleType toggleCode) {
        this.addToggle(toggleCode);
    }

    public void addToggleToTopItemList(TopItemListInterface l, ToggleType toggleCode) {
        this.addToggle(toggleCode);
    }

    private void addToggle(ToggleType toggle) {
        if (toggle == ToggleType.BLACK) {
            this.currentState.setRed(false);
        } else if (toggle == ToggleType.BLACKRED) {
            this.currentState.setRed(!this.currentState.isRed());
        } else if (toggle != ToggleType.LACUNA && toggle != ToggleType.LINELACUNA && toggle != ToggleType.OMMIT) {
            if (toggle == ToggleType.RED) {
                this.currentState.setRed(true);
            } else if (toggle == ToggleType.SHADINGOFF) {
                this.currentState.setShaded(false);
            } else if (toggle == ToggleType.SHADINGON) {
                this.currentState.setShaded(true);
            } else if (toggle == ToggleType.SHADINGTOGGLE) {
                this.currentState.setShaded(!this.currentState.isShaded());
            }
        }
    }

    public void addToHorizontalList(HBoxInterface h, HorizontalListElementInterface elt) {
        ((HBox)h).addHorizontalListElement((HorizontalListElement)elt);
    }

    public void addToLigature(LigatureInterface i, HieroglyphInterface h) {
        Ligature l = (Ligature)i;
        l.addHieroglyph((Hieroglyph)h);
    }

    public void addToVerticalList(VBoxInterface l, HBoxInterface h) {
        ((Cadrat)l).addHBox((HBox)h);
    }

    public BasicItemListInterface buildBasicItemList() {
        return new BasicItemList();
    }

    public CadratInterface buildCadrat(VBoxInterface e) {
        return (CadratInterface)((Object)e);
    }

    public CartoucheInterface buildCartouche(int type, int leftPart, BasicItemListInterface e, int rightPart) {
        Cartouche c = new Cartouche(type, leftPart, rightPart, (BasicItemList)e);
        return c;
    }

    public HBoxInterface buildHBox() {
        return new HBox();
    }

    public HieroglyphInterface buildHieroglyph(boolean isGrammar, int type, String code, ModifierListInterface m, int isEnd) {
        Hieroglyph result = new Hieroglyph(code);
        result.setGrammar(isGrammar);
        result.setType(type);
        switch (isEnd) {
            case 0: {
                result.setEndingCode(WordEndingCode.NONE);
                break;
            }
            case 1: {
                result.setEndingCode(WordEndingCode.WORD_END);
                break;
            }
            case 2: {
                result.setEndingCode(WordEndingCode.SENTENCE_END);
            }
        }
        result.setModifiers((ModifiersList)m);
        return result;
    }

    public LigatureInterface buildLigature() {
        return new Ligature();
    }

    public MDCFileInterface buildMDCFileInterface(TopItemListInterface l) {
        this.result = (TopItemList)l;
        return (MDCFileInterface)((Object)l);
    }

    public ModifierListInterface buildModifierList() {
        return new ModifiersList();
    }

    public OverwriteInterface buildOverwrite(HieroglyphInterface e1, HieroglyphInterface e2) {
        Overwrite result = new Overwrite((Hieroglyph)e1, (Hieroglyph)e2);
        return result;
    }

    public PhilologyInterface buildPhilology(int code1, BasicItemListInterface e, int code2) {
        return new Philology(code1, (BasicItemList)e);
    }

    public SubCadratInterface buildSubCadrat(BasicItemListInterface e) {
        SubCadrat result = new SubCadrat((BasicItemList)e);
        return result;
    }

    public TopItemListInterface buildTopItemList() {
        return new TopItemList();
    }

    public VBoxInterface buildVBox() {
        return new Cadrat();
    }

    public void completeLigature(LigatureInterface i) {
    }

    public TopItemList getResult() {
        return this.result;
    }

    public void addStartHieroglyphicTextToTopItemList(TopItemListInterface l) {
    }

    public void addStartHieroglyphicTextToBasicItemList(BasicItemListInterface l) {
    }

    public void reset() {
        this.result = null;
    }

    public void setHieroglyphPosition(HieroglyphInterface h, int x, int y, int scale) {
        Hieroglyph hiero = (Hieroglyph)h;
        hiero.setExplicitPosition(x, y, scale);
    }

    public AbsoluteGroupInterface buildAbsoluteGroup() {
        return new AbsoluteGroup();
    }

    public void addHieroglyphToAbsoluteGroup(AbsoluteGroupInterface group, HieroglyphInterface e) {
        AbsoluteGroup grp = (AbsoluteGroup)group;
        grp.addHieroglyph((Hieroglyph)e);
    }

    public void addZoneStartToTopItemList(TopItemListInterface e1, ZoneStartInterface e2) {
    }

    public void addOption(OptionListInterface e1, String optName, int val) {
    }

    public void addOption(OptionListInterface e1, String optName, String val) {
    }

    public void addOption(OptionListInterface e1, String optName) {
    }

    public OptionListInterface buildOptionList() {
        return new OptionsMap();
    }

    public ZoneStartInterface buildZone() {
        return new ZoneStart();
    }

    public void setOptionList(ZoneStartInterface result, OptionListInterface e1) {
    }

    public void setOptionList(CadratInterface result, OptionListInterface e1) {
    }

    public ComplexLigatureInterface buildComplexLigature(InnerGroupInterface e1, HieroglyphInterface e2, InnerGroupInterface e3) {
        return new ComplexLigature((InnerGroup)e1, (Hieroglyph)e2, (InnerGroup)e3);
    }
}

