/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdc.model.utilities;

import java.util.ArrayList;
import java.util.List;
import jsesh.mdc.model.AbsoluteGroup;
import jsesh.mdc.model.Cadrat;
import jsesh.mdc.model.Cartouche;
import jsesh.mdc.model.HBox;
import jsesh.mdc.model.Hieroglyph;
import jsesh.mdc.model.ModelElement;
import jsesh.mdc.model.ModelElementDeepAdapter;
import jsesh.mdc.model.SubCadrat;
import jsesh.mdc.model.TopItem;

public class GroupExploder {
    List result = null;

    public List explode(TopItem item) {
        this.result = new ArrayList();
        GroupExploderAux aux = new GroupExploderAux();
        item.accept(aux);
        return this.result;
    }

    private class GroupExploderAux
    extends ModelElementDeepAdapter {
        private GroupExploderAux() {
        }

        public void visitCadrat(Cadrat c) {
            if (c.getNumberOfHBoxes() == 0) {
                GroupExploder.this.result.add(c);
            } else if (c.getNumberOfHBoxes() > 1) {
                for (int i = 0; i < c.getNumberOfHBoxes(); ++i) {
                    GroupExploder.this.result.add(c.getChildAt(i).buildTopItem());
                }
            } else {
                HBox hbox = c.getHBox(0);
                hbox.accept(this);
            }
        }

        public void visitCartouche(Cartouche c) {
            for (int i = 0; i < c.getBasicItemList().getNumberOfChildren(); ++i) {
                GroupExploder.this.result.add(c.getBasicItemList().getChildAt(i).deepCopy());
            }
        }

        public void visitHBox(HBox hbox) {
            int nb = hbox.getNumberOfChildren();
            if (nb != 0) {
                if (nb == 1) {
                    hbox.getChildAt(0).accept(this);
                } else {
                    this.visitDefault(hbox);
                }
            }
        }

        public void visitTopItem(TopItem t) {
            GroupExploder.this.result.add(t.deepCopy());
        }

        public void visitSubCadrat(SubCadrat c) {
            c.getBasicItemList().accept(this);
        }

        public void visitHieroglyph(Hieroglyph h) {
            GroupExploder.this.result.add(h.buildTopItem());
        }

        public void visitDefault(ModelElement t) {
            for (int i = 0; i < t.getNumberOfChildren(); ++i) {
                TopItem item = t.getChildAt(i).buildTopItem();
                if (item == null) continue;
                GroupExploder.this.result.add(item);
            }
        }

        public void visitAbsoluteGroup(AbsoluteGroup g) {
            for (int i = 0; i < g.getNumberOfChildren(); ++i) {
                Hieroglyph h = (Hieroglyph)g.getHieroglyphAt(i).deepCopy();
                h.setExplicitPosition(0, 0, 100);
                GroupExploder.this.result.add(h.buildTopItem());
            }
        }
    }
}

