/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.clipboard;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import jsesh.graphicExport.RTFExportPreferences;
import jsesh.graphicExport.RTFExporter;
import jsesh.mdc.model.ListOfTopItems;
import jsesh.mdc.model.TopItemList;
import jsesh.mdc.output.ModelWriter;
import jsesh.mdcDisplayer.draw.MDCDrawingFacade;
import jsesh.mdcDisplayer.layout.SimpleViewBuilder;
import jsesh.mdcDisplayer.preferences.DrawingSpecifications;

public class MDCModelTransferable
implements Transferable {
    private static final DataFlavor RTFFlavor = new DataFlavor("text/rtf", null);
    public static final DataFlavor ListOfTopItemsFlavor = new DataFlavor(ListOfTopItems.class, null);
    private TopItemList topItemList;
    private RTFExportPreferences rtfPreferences;
    private DrawingSpecifications drawingSpecifications;
    private boolean bitmapWanted;
    private int maxBitmapWidth;
    private int maxBitmapHeight;

    public MDCModelTransferable(TopItemList list) {
        this.topItemList = list;
        this.bitmapWanted = false;
        this.maxBitmapWidth = 2000;
        this.maxBitmapHeight = 2000;
        this.rtfPreferences = new RTFExportPreferences();
        this.drawingSpecifications = new DrawingSpecifications();
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] result = new DataFlavor[]{ListOfTopItemsFlavor, RTFFlavor, DataFlavor.stringFlavor, ListOfTopItemsFlavor};
        if (this.bitmapWanted) {
            result = new DataFlavor[]{ListOfTopItemsFlavor, RTFFlavor, DataFlavor.imageFlavor, DataFlavor.stringFlavor};
        }
        return result;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        System.err.println("calling isDFS " + flavor);
        DataFlavor[] flavors = this.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        void var2_11;
        Object result;
        System.out.println("asking for " + flavor);
        if (RTFFlavor.equals(flavor)) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            if (this.topItemList.getNumberOfChildren() < 1000) {
                DrawingSpecifications drawingSpecifications = this.getDrawingSpecifications();
                drawingSpecifications.setTopMargin(0.0f);
                drawingSpecifications.setLeftMargin(0.0f);
                RTFExporter rtfExporter = new RTFExporter();
                rtfExporter.setDrawingSpecifications(drawingSpecifications);
                rtfExporter.setViewBuilder(new SimpleViewBuilder());
                rtfExporter.setRtfPreferences(this.rtfPreferences);
                rtfExporter.ExportModelTo(this.topItemList, outputStream);
                result = new ByteArrayInputStream(outputStream.toByteArray());
            } else {
                String data = "{\\rtf1\\ansi\\ansicpg1252Jsesh : sorry, data too large for RTF cut and paste. Please copy a smaller part of your text.\\par}";
                result = new ByteArrayInputStream(data.getBytes("US-ASCII"));
            }
        } else {
            if (DataFlavor.stringFlavor.equals(flavor)) {
                StringWriter writer = new StringWriter();
                ModelWriter modelWriter = new ModelWriter();
                modelWriter.write(writer, this.topItemList);
                return writer.toString();
            }
            if (ListOfTopItemsFlavor.equals(flavor)) {
                ListOfTopItems l = new ListOfTopItems();
                for (int i = 0; i < this.topItemList.getNumberOfChildren(); ++i) {
                    l.add(this.topItemList.getTopItemAt(i).deepCopy());
                }
                System.err.println("copy made.");
                return l;
            }
            if (DataFlavor.imageFlavor.equals(flavor)) {
                MDCDrawingFacade facade = new MDCDrawingFacade();
                facade.setDrawingSpecifications(this.getDrawingSpecifications());
                facade.setMaxSize(this.maxBitmapWidth, this.maxBitmapHeight);
                facade.setCadratHeight(this.rtfPreferences.getCadratHeight());
                result = facade.createImage(this.topItemList);
            } else {
                throw new UnsupportedFlavorException(flavor);
            }
        }
        return var2_11;
    }

    public DrawingSpecifications getDrawingSpecifications() {
        return this.drawingSpecifications;
    }

    public void setDrawingSpecifications(DrawingSpecifications drawingSpecifications) {
        this.drawingSpecifications = drawingSpecifications.copy();
    }

    public RTFExportPreferences getRtfPreferences() {
        return this.rtfPreferences;
    }

    public void setRtfPreferences(RTFExportPreferences rtfPreferences) {
        this.rtfPreferences = rtfPreferences;
    }

    public boolean isBitmapWanted() {
        return this.bitmapWanted;
    }

    public void setBitmapWanted(boolean bitmapWanted) {
        this.bitmapWanted = bitmapWanted;
    }
}

