/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.draw;

import java.util.List;
import jsesh.mdc.model.AbsoluteGroup;
import jsesh.mdc.model.Hieroglyph;
import jsesh.mdc.model.InnerGroup;
import jsesh.mdc.model.ModelElement;
import jsesh.mdc.model.ModelElementAdapter;
import jsesh.mdc.model.TopItem;
import jsesh.mdc.model.utilities.InnerGroupLister;
import jsesh.mdcDisplayer.layout.SimpleViewBuilder;
import jsesh.mdcDisplayer.mdcView.MDCView;
import jsesh.mdcDisplayer.preferences.DrawingSpecifications;

public class DrawUtilities {
    public static AbsoluteGroup createAbsoluteGroupFrom(List topItems, DrawingSpecifications specs) {
        TopItem item;
        InnerGroup[] groups;
        AbsoluteGroup result = null;
        if (topItems.size() == 1 && (groups = InnerGroupLister.getInnerGroups(item = (TopItem)topItems.get(0))).length == 1 && groups[0] instanceof AbsoluteGroup) {
            result = (AbsoluteGroup)groups[0].deepCopy();
        }
        if (result == null) {
            AbsoluteGroupComposer composer = new AbsoluteGroupComposer();
            composer.createAbsoluteGroupFrom(topItems, specs);
            result = composer.result;
        }
        return result;
    }

    private static class AbsoluteGroupComposer
    extends ModelElementAdapter {
        AbsoluteGroup result;
        float origx;
        float origy;
        float scale;
        float sizeofA1;

        private AbsoluteGroupComposer() {
        }

        public AbsoluteGroup createAbsoluteGroupFrom(List topItems, DrawingSpecifications drawingSpecifications) {
            this.result = new AbsoluteGroup();
            SimpleViewBuilder builder = new SimpleViewBuilder();
            this.sizeofA1 = drawingSpecifications.getBaseLength();
            this.origx = 0.0f;
            this.origy = 0.0f;
            for (int i = 0; i < topItems.size(); ++i) {
                this.scale = 1.0f;
                MDCView v = builder.buildView((ModelElement)topItems.get(i), drawingSpecifications);
                this.scanView(v);
                this.origx += v.getWidth();
                this.origy = 0.0f;
            }
            return this.result;
        }

        private void scanView(MDCView v) {
            this.scale *= v.getXScale();
            v.getModel().accept(this);
            for (int i = 0; i < v.getNumberOfSubviews(); ++i) {
                MDCView subv = v.getSubView(i);
                float oldScale = this.scale;
                float oldx = this.origx;
                float oldy = this.origy;
                this.origx = (float)((double)this.origx + subv.getPosition().x * (double)this.scale);
                this.origy = (float)((double)this.origy + subv.getPosition().y * (double)this.scale);
                this.scanView(subv);
                this.origx = oldx;
                this.origy = oldy;
                this.scale = oldScale;
            }
        }

        public void visitHieroglyph(Hieroglyph oldh) {
            Hieroglyph h = (Hieroglyph)oldh.deepCopy();
            int xx = (int)((double)this.origx * 1000.0 / (double)this.sizeofA1);
            int yy = (int)((double)this.origy * 1000.0 / (double)this.sizeofA1);
            int s = (int)(this.scale * (float)h.getRelativeSize());
            h.setExplicitPosition(xx, yy, s);
            this.result.addHieroglyph(h);
        }
    }
}

